/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.parts.IPartModel;
import appeng.api.util.DimensionalCoord;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PartP2PFluids
extends PartP2PTunnel<PartP2PFluids> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fluids");
    private static final ThreadLocal<Deque<PartP2PFluids>> DEPTH = new ThreadLocal();
    private static final FluidTankProperties[] INACTIVE_TANK = new FluidTankProperties[]{new FluidTankProperties(null, 0, false, false)};
    private int tmpUsed;
    private IFluidHandler inputHandler = new InputHandler();
    private IFluidHandler outputHandler = new OutputHandler();
    private static final IFluidHandler NULL_FLUID_HANDLER = new NullFluidHandler();

    public PartP2PFluids(ItemStack is) {
        super(is);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void onTunnelNetworkChange() {
        if (this.isOutput()) {
            PartP2PFluids input = (PartP2PFluids)this.getInput();
            if (input != null) {
                input.getHost().notifyNeighbors();
            }
        } else {
            this.getHost().notifyNeighbors();
        }
    }

    @Override
    public void onNeighborChanged() {
        if (this.isOutput()) {
            PartP2PFluids in = (PartP2PFluids)this.getInput();
            if (in != null) {
                in.onTunnelNetworkChange();
            }
        } else {
            try {
                for (PartP2PFluids p : this.getOutputs()) {
                    MinecraftServer s;
                    DimensionalCoord loc = p.getLocation();
                    if (loc.getWorld().field_72995_K || (s = loc.getWorld().func_73046_m()) == null) continue;
                    s.func_152344_a(() -> {
                        BlockPos pos = loc.getPos().func_177972_a(p.getSide().getFacing());
                        IBlockState state = loc.getWorld().func_180495_p(pos);
                        state.func_177230_c().onNeighborChange((IBlockAccess)loc.getWorld(), pos, loc.getPos());
                    });
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capabilityClass) {
        return capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capabilityClass);
    }

    @Override
    public <T> T getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.isActive()) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)NULL_FLUID_HANDLER);
            }
            if (this.isOutput()) {
                return (T)(this.getInput() != null && ((PartP2PFluids)this.getInput()).getTarget() != null ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.outputHandler) : CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)NULL_FLUID_HANDLER));
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.inputHandler);
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private List<PartP2PFluids> getOutputs(Fluid input) {
        LinkedList<PartP2PFluids> outs = new LinkedList<PartP2PFluids>();
        try {
            for (PartP2PFluids l : this.getOutputs()) {
                IFluidHandler handler = l.getTarget();
                if (handler == null) continue;
                outs.add(l);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return outs;
    }

    private IFluidHandler getTarget() {
        if (!this.getProxy().isActive()) {
            return null;
        }
        EnumFacing opposite = this.getSide().getFacing().func_176734_d();
        TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(this.getSide().getFacing()));
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opposite)) {
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opposite);
        }
        return null;
    }

    private Deque<PartP2PFluids> getDepth() {
        Deque<PartP2PFluids> s = DEPTH.get();
        if (s == null) {
            s = new LinkedList<PartP2PFluids>();
            DEPTH.set(s);
        }
        return s;
    }

    private static class FluidTankProxy
    implements IFluidTankProperties {
        private IFluidTankProperties parent;
        private boolean allowFill;
        private boolean allowDrain;

        FluidTankProxy(IFluidTankProperties parent, boolean allowFill, boolean allowDrain) {
            this.parent = parent;
            this.allowFill = allowFill;
            this.allowDrain = allowDrain;
        }

        @Nullable
        public FluidStack getContents() {
            return this.parent.getContents();
        }

        public int getCapacity() {
            return this.parent.getCapacity();
        }

        public boolean canFill() {
            return this.allowFill && this.parent.canFill();
        }

        public boolean canDrain() {
            return this.allowDrain && this.parent.canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return this.allowFill && this.parent.canFillFluidType(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return this.allowDrain && this.parent.canDrainFluidType(fluidStack);
        }
    }

    private static class NullFluidHandler
    implements IFluidHandler {
        private NullFluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }

    private class InputHandler
    implements IFluidHandler {
        private InputHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            if (PartP2PFluids.this.isOutput()) {
                return INACTIVE_TANK;
            }
            ArrayList<FluidTankProxy> tanks = new ArrayList<FluidTankProxy>();
            List outputs = PartP2PFluids.this.getOutputs(null);
            for (PartP2PFluids p : outputs) {
                IFluidTankProperties[] t = p.getTarget().getTankProperties();
                if (t == null) continue;
                for (IFluidTankProperties ft : t) {
                    tanks.add(new FluidTankProxy(ft, true, false));
                }
            }
            return tanks.toArray(new IFluidTankProperties[tanks.size()]);
        }

        public int fill(FluidStack resource, boolean doFill) {
            Deque stack = PartP2PFluids.this.getDepth();
            for (PartP2PFluids t : stack) {
                if (t != PartP2PFluids.this) continue;
                return 0;
            }
            stack.push(PartP2PFluids.this);
            List list = PartP2PFluids.this.getOutputs(resource.getFluid());
            int requestTotal = 0;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                PartP2PFluids l = (PartP2PFluids)i.next();
                IFluidHandler tank = l.getTarget();
                if (tank != null) {
                    l.tmpUsed = tank.fill(resource.copy(), false);
                } else {
                    l.tmpUsed = 0;
                }
                if (l.tmpUsed <= 0) {
                    i.remove();
                    continue;
                }
                requestTotal += l.tmpUsed;
            }
            if (requestTotal <= 0) {
                if (stack.pop() != PartP2PFluids.this) {
                    throw new IllegalStateException("Invalid Recursion detected.");
                }
                return 0;
            }
            if (!doFill) {
                if (stack.pop() != PartP2PFluids.this) {
                    throw new IllegalStateException("Invalid Recursion detected.");
                }
                return Math.min(resource.amount, requestTotal);
            }
            int available = resource.amount;
            i = list.iterator();
            int used = 0;
            while (i.hasNext()) {
                IFluidHandler tank;
                PartP2PFluids l = (PartP2PFluids)i.next();
                FluidStack insert = resource.copy();
                insert.amount = (int)Math.ceil((double)insert.amount * ((double)l.tmpUsed / (double)requestTotal));
                if (insert.amount > available) {
                    insert.amount = available;
                }
                if ((tank = l.getTarget()) != null) {
                    l.tmpUsed = tank.fill(insert.copy(), true);
                } else {
                    l.tmpUsed = 0;
                }
                available -= insert.amount;
                used += insert.amount;
            }
            if (stack.pop() != PartP2PFluids.this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return used;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }

    private class OutputHandler
    implements IFluidHandler {
        private OutputHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            IFluidTankProperties[] t;
            IFluidHandler inH;
            PartP2PFluids tun;
            if (PartP2PFluids.this.isOutput() && (tun = (PartP2PFluids)PartP2PFluids.this.getInput()) != null && (inH = tun.getTarget()) != null && (t = inH.getTankProperties()) != null) {
                ArrayList<FluidTankProxy> tanks = new ArrayList<FluidTankProxy>();
                for (IFluidTankProperties ft : t) {
                    tanks.add(new FluidTankProxy(ft, false, true));
                }
                return tanks.toArray(new IFluidTankProperties[tanks.size()]);
            }
            return INACTIVE_TANK;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            PartP2PFluids tun;
            if (PartP2PFluids.this.isOutput() && (tun = (PartP2PFluids)PartP2PFluids.this.getInput()) != null) {
                IFluidHandler inH = tun.getTarget();
                return inH != null ? inH.drain(resource, doDrain) : null;
            }
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            PartP2PFluids tun;
            if (PartP2PFluids.this.isOutput() && (tun = (PartP2PFluids)PartP2PFluids.this.getInput()) != null) {
                IFluidHandler inH = tun.getTarget();
                return inH != null ? inH.drain(maxDrain, doDrain) : null;
            }
            return null;
        }
    }
}

