/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import java.util.List;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public final class PartP2PForgeEnergy
extends PartP2PTunnel<PartP2PForgeEnergy> {
    private static final ThreadLocal<Stack<PartP2PForgeEnergy>> THREAD_STACK = new ThreadLocal();
    private static final IEnergyStorage NULL_HANDLER = new EnergyStorage(0);
    private final IEnergyStorage inputCap = new FEInputCap();
    private final IEnergyStorage outputCap = new FEOutputCap();
    private TileEntity myHost;
    private BlockPos facingPos;
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fe");

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartP2PForgeEnergy(ItemStack is) {
        super(is);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.getHost().notifyNeighbors();
    }

    private Stack<PartP2PForgeEnergy> getDepth() {
        Stack<PartP2PForgeEnergy> s = THREAD_STACK.get();
        if (s == null) {
            s = new Stack();
            THREAD_STACK.set(s);
        }
        return s;
    }

    private IEnergyStorage getFacingProvider() {
        IEnergyStorage outputTarget = null;
        TileEntity te = this.myHost.func_145831_w().func_175625_s(this.facingPos);
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, this.getSide().getOpposite().getFacing())) {
            outputTarget = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.getSide().getOpposite().getFacing());
        }
        if (outputTarget == null) {
            return NULL_HANDLER;
        }
        return outputTarget;
    }

    private IEnergyStorage getOutput() {
        return this.isOutput() && this.isActive() ? this.getFacingProvider() : NULL_HANDLER;
    }

    private IEnergyStorage getInputCap() {
        return !this.isOutput() && this.isActive() ? this.getFacingProvider() : NULL_HANDLER;
    }

    @Override
    public boolean hasCapability(Capability<?> capabilityClass) {
        return capabilityClass == CapabilityEnergy.ENERGY && this.isActive() && this.getInput() != null || super.hasCapability(capabilityClass);
    }

    @Override
    public <T> T getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityEnergy.ENERGY && this.isActive() && this.getInput() != null) {
            if (this.isOutput() && this.getInput() != null) {
                return (T)this.outputCap;
            }
            try {
                if (!this.getOutputs().isEmpty()) {
                    return (T)this.inputCap;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return (T)NULL_HANDLER;
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.myHost = this.getTile();
        this.facingPos = this.getHost().getLocation().getPos().func_177972_a(this.getSide().getFacing());
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private class FEOutputCap
    implements IEnergyStorage {
        private FEOutputCap() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (PartP2PForgeEnergy.this.getInput() == null) {
                return 0;
            }
            return ((PartP2PForgeEnergy)PartP2PForgeEnergy.this.getInput()).getInputCap().extractEnergy(maxExtract, simulate);
        }

        public int getEnergyStored() {
            if (PartP2PForgeEnergy.this.getInput() == null) {
                return 0;
            }
            return ((PartP2PForgeEnergy)PartP2PForgeEnergy.this.getInput()).getInputCap().getEnergyStored();
        }

        public int getMaxEnergyStored() {
            if (PartP2PForgeEnergy.this.getInput() == null) {
                return 0;
            }
            return ((PartP2PForgeEnergy)PartP2PForgeEnergy.this.getInput()).getInputCap().getMaxEnergyStored();
        }

        public boolean canExtract() {
            return PartP2PForgeEnergy.this.getInput() != null && ((PartP2PForgeEnergy)PartP2PForgeEnergy.this.getInput()).getInputCap().canExtract();
        }

        public boolean canReceive() {
            return false;
        }
    }

    private class FEInputCap
    implements IEnergyStorage {
        private FEInputCap() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (PartP2PForgeEnergy.this.isOutput()) {
                return 0;
            }
            if (PartP2PForgeEnergy.this.isActive()) {
                Stack stack = PartP2PForgeEnergy.this.getDepth();
                for (PartP2PForgeEnergy t : stack) {
                    if (t != PartP2PForgeEnergy.this) continue;
                    return 0;
                }
                stack.push(PartP2PForgeEnergy.this);
                int total = 0;
                try {
                    int receiver;
                    for (PartP2PForgeEnergy t : PartP2PForgeEnergy.this.getOutputs()) {
                        if (Platform.getRandomInt() % 2 <= 0) continue;
                        receiver = t.getOutput().receiveEnergy(maxReceive, simulate);
                        total += receiver;
                        if ((maxReceive -= receiver) > 0) continue;
                        break;
                    }
                    if (maxReceive > 0) {
                        for (PartP2PForgeEnergy t : PartP2PForgeEnergy.this.getOutputs()) {
                            receiver = t.getOutput().receiveEnergy(maxReceive, simulate);
                            total += receiver;
                            if ((maxReceive -= receiver) > 0) continue;
                            break;
                        }
                    }
                    PartP2PForgeEnergy.this.queueTunnelDrain(PowerUnits.RF, total);
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
                if (stack.pop() != PartP2PForgeEnergy.this) {
                    throw new IllegalStateException("Invalid Recursion detected.");
                }
                return total;
            }
            return 0;
        }

        public int getEnergyStored() {
            if (PartP2PForgeEnergy.this.isOutput() || !PartP2PForgeEnergy.this.isActive()) {
                return 0;
            }
            int total = 0;
            Stack stack = PartP2PForgeEnergy.this.getDepth();
            for (PartP2PForgeEnergy t : stack) {
                if (t != PartP2PForgeEnergy.this) continue;
                return 0;
            }
            stack.push(PartP2PForgeEnergy.this);
            try {
                for (PartP2PForgeEnergy t : PartP2PForgeEnergy.this.getOutputs()) {
                    total += t.getOutput().getEnergyStored();
                }
            }
            catch (GridAccessException e) {
                return 0;
            }
            if (stack.pop() != PartP2PForgeEnergy.this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return total;
        }

        public int getMaxEnergyStored() {
            if (PartP2PForgeEnergy.this.isOutput() || !PartP2PForgeEnergy.this.isActive()) {
                return 0;
            }
            int total = 0;
            Stack stack = PartP2PForgeEnergy.this.getDepth();
            for (PartP2PForgeEnergy t : stack) {
                if (t != PartP2PForgeEnergy.this) continue;
                return 0;
            }
            stack.push(PartP2PForgeEnergy.this);
            try {
                for (PartP2PForgeEnergy t : PartP2PForgeEnergy.this.getOutputs()) {
                    total += t.getOutput().getMaxEnergyStored();
                }
            }
            catch (GridAccessException e) {
                return 0;
            }
            if (stack.pop() != PartP2PForgeEnergy.this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return total;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }
    }
}

