/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.inv.NullItemHandler;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class PartP2PItems
extends PartP2PTunnel<PartP2PItems> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_items");
    private final LinkedList<PartP2PItems> which = new LinkedList();
    private int oldSize = 0;
    private static IItemHandler NULL_ITEM_HANDLER = new NullItemHandler();
    private IItemHandler outputHandler = new OutputHandler();
    private IItemHandler inputHandler = new InputHandler();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartP2PItems(ItemStack is) {
        super(is);
    }

    @Override
    public void onNeighborChanged() {
        PartP2PItems input = (PartP2PItems)this.getInput();
        if (input != null && this.isOutput()) {
            input.onTunnelNetworkChange();
        }
    }

    private IItemHandler getOutputInv() {
        IItemHandler output = null;
        if (this.getProxy().isActive()) {
            if (this.which.contains(this)) {
                return null;
            }
            TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(this.getSide().getFacing()));
            if (te == null) {
                return null;
            }
            this.which.push(this);
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d());
            if (handler != null) {
                output = handler;
            } else if (te instanceof ISidedInventory) {
                output = new SidedInvWrapper((ISidedInventory)te, this.getSide().getFacing().func_176734_d());
            } else if (te instanceof IInventory) {
                output = new InvWrapper((IInventory)te);
            }
            this.which.pop();
        }
        return output;
    }

    private void checkNumSlots() {
        int olderSize = this.oldSize;
        this.oldSize = this.inputHandler.getSlots();
        if (olderSize != this.oldSize) {
            this.getHost().notifyNeighbors();
        }
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        if (!this.isOutput()) {
            this.checkNumSlots();
        }
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        if (!this.isOutput()) {
            this.checkNumSlots();
        }
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        if (!this.isOutput()) {
            this.checkNumSlots();
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        if (!this.isOutput()) {
            this.checkNumSlots();
        } else {
            PartP2PItems input = (PartP2PItems)this.getInput();
            if (input != null) {
                input.getHost().notifyNeighbors();
            }
        }
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    public boolean hasCapability(Capability<?> capabilityClass) {
        return capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capabilityClass);
    }

    @Override
    public <T> T getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.isActive()) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)NULL_ITEM_HANDLER);
            }
            if (this.isOutput()) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.outputHandler);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inputHandler);
        }
        return super.getCapability(capabilityClass);
    }

    private class OutputHandler
    implements IItemHandler {
        private OutputHandler() {
        }

        public int getSlots() {
            IItemHandler h;
            if (!PartP2PItems.this.isActive() || !PartP2PItems.this.isOutput()) {
                return 0;
            }
            PartP2PItems in = (PartP2PItems)PartP2PItems.this.getInput();
            if (in != null && (h = in.getOutputInv()) != null) {
                return h.getSlots();
            }
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            IItemHandler h;
            if (!PartP2PItems.this.isActive() || !PartP2PItems.this.isOutput()) {
                return ItemStack.field_190927_a;
            }
            PartP2PItems in = (PartP2PItems)PartP2PItems.this.getInput();
            if (in != null && (h = in.getOutputInv()) != null) {
                return h.getStackInSlot(slot);
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            IItemHandler h;
            if (!PartP2PItems.this.isActive() || !PartP2PItems.this.isOutput()) {
                return ItemStack.field_190927_a;
            }
            PartP2PItems in = (PartP2PItems)PartP2PItems.this.getInput();
            if (in != null && (h = in.getOutputInv()) != null) {
                return h.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            IItemHandler h;
            if (!PartP2PItems.this.isActive() || !PartP2PItems.this.isOutput()) {
                return 0;
            }
            PartP2PItems in = (PartP2PItems)PartP2PItems.this.getInput();
            if (in != null && (h = in.getOutputInv()) != null) {
                return h.getSlotLimit(slot);
            }
            return 0;
        }
    }

    private class InputHandler
    implements IItemHandler {
        private InputHandler() {
        }

        public int getSlots() {
            if (PartP2PItems.this.isOutput()) {
                return 0;
            }
            int totalSlots = 0;
            try {
                for (PartP2PItems p : PartP2PItems.this.getOutputs()) {
                    IItemHandler h = p.getOutputInv();
                    if (h == null) continue;
                    totalSlots += h.getSlots();
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return totalSlots;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (PartP2PItems.this.isOutput()) {
                return ItemStack.field_190927_a;
            }
            int totalSlots = 0;
            try {
                for (PartP2PItems p : PartP2PItems.this.getOutputs()) {
                    IItemHandler h = p.getOutputInv();
                    if (h == null) continue;
                    if (slot - totalSlots < h.getSlots()) {
                        return h.getStackInSlot(slot - totalSlots);
                    }
                    totalSlots += h.getSlots();
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack input, boolean simulate) {
            if (PartP2PItems.this.isOutput()) {
                return input;
            }
            int totalSlots = 0;
            try {
                for (PartP2PItems p : PartP2PItems.this.getOutputs()) {
                    IItemHandler h = p.getOutputInv();
                    if (h == null) continue;
                    if (slot - totalSlots < h.getSlots()) {
                        return h.insertItem(slot - totalSlots, input, simulate);
                    }
                    totalSlots += h.getSlots();
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return input;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            if (PartP2PItems.this.isOutput()) {
                return 0;
            }
            int totalSlots = 0;
            try {
                for (PartP2PItems p : PartP2PItems.this.getOutputs()) {
                    IItemHandler h = p.getOutputInv();
                    if (h == null) continue;
                    if (slot - totalSlots < h.getSlots()) {
                        return h.getSlotLimit(slot - totalSlots);
                    }
                    totalSlots += h.getSlots();
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return 0;
        }
    }
}

