/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItems;
import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.features.IRecipeHandlerRegistry;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.api.recipes.IRecipeHandler;
import appeng.api.recipes.IRecipeLoader;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.items.materials.ItemMaterial;
import appeng.items.parts.ItemPart;
import appeng.recipes.GroupIngredient;
import appeng.recipes.Ingredient;
import appeng.recipes.IngredientSet;
import appeng.recipes.MissedIngredientSet;
import appeng.recipes.RecipeData;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.recipes.handlers.OreRegistration;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.registries.IForgeRegistry;

public class RecipeHandler
implements IRecipeHandler {
    private final RecipeData data;
    private final List<String> tokens = new LinkedList<String>();

    public RecipeHandler() {
        this.data = new RecipeData();
    }

    RecipeHandler(RecipeHandler parent) {
        Preconditions.checkNotNull((Object)parent);
        this.data = parent.data;
    }

    private void addCrafting(ICraftHandler ch) {
        this.data.handlers.add(ch);
    }

    public String getName(@Nonnull IIngredient i) {
        try {
            ItemStack[] itemStackArray = i.getItemStackSet();
            int n = itemStackArray.length;
            int n2 = 0;
            if (n2 < n) {
                ItemStack is = itemStackArray[n2];
                return this.getName(is);
            }
        }
        catch (RecipeError recipeError) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return i.getNameSpace() + ':' + i.getItemName();
    }

    private String getName(ItemStack is) throws RecipeError {
        Preconditions.checkNotNull((Object)is);
        ResourceLocation id = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)is.func_77973_b());
        String realName = id.toString();
        if (!id.func_110624_b().equals("appliedenergistics2") && !id.func_110624_b().equals("minecraft")) {
            throw new RecipeError("Not applicable for website");
        }
        IDefinitions definitions = AEApi.instance().definitions();
        IItems items = definitions.items();
        IBlocks blocks = definitions.blocks();
        Optional<Item> maybeCrystalSeedItem = items.crystalSeed().maybeItem();
        Optional<Item> maybeSkyStoneItem = blocks.skyStoneBlock().maybeItem();
        Optional<Item> maybeCStorageItem = blocks.craftingStorage1k().maybeItem();
        Optional<Item> maybeCUnitItem = blocks.craftingUnit().maybeItem();
        Optional<Item> maybeSkyChestItem = blocks.skyStoneChest().maybeItem();
        if (maybeCrystalSeedItem.isPresent() && is.func_77973_b() == maybeCrystalSeedItem.get()) {
            int dmg = is.func_77952_i();
            if (dmg < 600) {
                realName = realName + ".Certus";
            } else if (dmg < 1200) {
                realName = realName + ".Nether";
            } else if (dmg < 1800) {
                realName = realName + ".Fluix";
            }
        } else if (maybeSkyStoneItem.isPresent() && is.func_77973_b() == maybeSkyStoneItem.get()) {
            switch (is.func_77952_i()) {
                case 1: {
                    realName = realName + ".Block";
                    break;
                }
                case 2: {
                    realName = realName + ".Brick";
                    break;
                }
                case 3: {
                    realName = realName + ".SmallBrick";
                    break;
                }
            }
        } else if (maybeCStorageItem.isPresent() && is.func_77973_b() == maybeCStorageItem.get()) {
            switch (is.func_77952_i()) {
                case 1: {
                    realName = realName + "4k";
                    break;
                }
                case 2: {
                    realName = realName + "16k";
                    break;
                }
                case 3: {
                    realName = realName + "64k";
                    break;
                }
            }
        } else if (maybeCUnitItem.isPresent() && is.func_77973_b() == maybeCUnitItem.get()) {
            switch (is.func_77952_i()) {
                case 1: {
                    realName = realName.replace("Unit", "Accelerator");
                    break;
                }
            }
        } else if (maybeSkyChestItem.isPresent() && is.func_77973_b() == maybeSkyChestItem.get()) {
            switch (is.func_77952_i()) {
                case 1: {
                    realName = realName + ".Block";
                    break;
                }
            }
        } else if (is.func_77973_b() instanceof ItemMaterial) {
            realName = realName.replace("ItemMultiMaterial", "ItemMaterial");
            realName = realName + '.' + ((ItemMaterial)is.func_77973_b()).getTypeByStack(is).name();
        } else if (is.func_77973_b() instanceof ItemPart) {
            realName = realName.replace("ItemPart", "ItemPart");
            realName = realName + '.' + ((ItemPart)is.func_77973_b()).getTypeByStack(is).name();
        } else if (is.func_77952_i() > 0) {
            realName = realName + "." + is.func_77952_i();
        }
        return realName;
    }

    String alias(String in) {
        Preconditions.checkNotNull((Object)in);
        String out = this.data.aliases.get(in);
        if (out != null) {
            return out;
        }
        return in;
    }

    @Override
    public void parseRecipes(IRecipeLoader loader, String path) {
        block23: {
            Preconditions.checkNotNull((Object)loader);
            Preconditions.checkNotNull((Object)path);
            try {
                BufferedReader reader = null;
                try {
                    reader = loader.getFile(path);
                }
                catch (Exception err) {
                    AELog.warn("Error Loading Recipe File:" + path, new Object[0]);
                    if (this.data.exceptions) {
                        AELog.debug(err);
                    }
                    return;
                }
                boolean inQuote = false;
                boolean inComment = false;
                String token = "";
                int line = 0;
                int val = -1;
                block14: while ((val = reader.read()) != -1) {
                    char c = (char)val;
                    if (c == '\n') {
                        ++line;
                    }
                    if (inComment) {
                        if (c != '\n' && c != '\r') continue;
                        inComment = false;
                        continue;
                    }
                    if (inQuote) {
                        switch (c) {
                            case '\"': {
                                inQuote = !inQuote;
                                continue block14;
                            }
                        }
                        token = token + c;
                        continue;
                    }
                    switch (c) {
                        case '\"': {
                            inQuote = !inQuote;
                            continue block14;
                        }
                        case ',': {
                            if (token.length() > 0) {
                                this.tokens.add(token);
                                this.tokens.add(",");
                            }
                            token = "";
                            continue block14;
                        }
                        case '=': {
                            this.processTokens(loader, path, line);
                            if (token.length() > 0) {
                                this.tokens.add(token);
                            }
                            token = "";
                            continue block14;
                        }
                        case '#': {
                            inComment = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (token.length() > 0) {
                                this.tokens.add(token);
                            }
                            token = "";
                            continue block14;
                        }
                    }
                    token = token + c;
                }
                if (token.length() > 0) {
                    this.tokens.add(token);
                }
                reader.close();
                this.processTokens(loader, path, line);
            }
            catch (Throwable e) {
                AELog.debug(e);
                if (!this.data.crash) break block23;
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void injectRecipes(IForgeRegistry<IRecipe> registry) {
        if (Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            throw new IllegalStateException("Recipes must now be loaded in Init.");
        }
        this.data.handlers.sort(new Comparator<ICraftHandler>(){

            @Override
            public int compare(ICraftHandler o1, ICraftHandler o2) {
                Class<?> o2Clazz;
                Class<?> o1Clazz = o1.getClass();
                if (o1Clazz == (o2Clazz = o2.getClass())) {
                    return 0;
                }
                if (o1Clazz == OreRegistration.class) {
                    return -1;
                }
                if (o2Clazz == OreRegistration.class) {
                    return 1;
                }
                return 0;
            }
        });
        HashMap processed = new HashMap();
        for (ICraftHandler iCraftHandler : this.data.handlers) {
            try {
                iCraftHandler.register(registry);
                Class<?> clz = iCraftHandler.getClass();
                Integer i = (Integer)processed.get(clz);
                if (i == null) {
                    processed.put(clz, 1);
                    continue;
                }
                processed.put(clz, i + 1);
            }
            catch (MissingIngredientError e) {
                if (!this.data.errorOnMissing) continue;
                AELog.warn("Unable to register a recipe:" + e.getMessage(), new Object[0]);
                if (this.data.exceptions) {
                    AELog.debug(e);
                }
                if (!this.data.crash) continue;
                throw new IllegalStateException(e);
            }
            catch (Throwable e) {
                AELog.warn("Unable to register a recipe: " + e.getMessage(), new Object[0]);
                if (this.data.exceptions) {
                    AELog.debug(e);
                }
                if (!this.data.crash) continue;
                throw new IllegalStateException(e);
            }
        }
        for (Map.Entry entry : processed.entrySet()) {
            AELog.info("Recipes Loading: " + ((Class)entry.getKey()).getSimpleName() + ": " + entry.getValue() + " loaded.", new Object[0]);
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.WEBSITE_RECIPES)) {
            try {
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream("recipes.zip"));
                HashMultimap hashMultimap = HashMultimap.create();
                for (String s : this.data.knownItem) {
                    try {
                        Ingredient i = new Ingredient(this, s, 1);
                        for (ItemStack is : i.getItemStackSet()) {
                            String realName = this.getName(is);
                            List<IWebsiteSerializer> recipes = this.findRecipe(is);
                            if (recipes.isEmpty()) continue;
                            hashMultimap.putAll((Object)realName, recipes);
                        }
                    }
                    catch (RecipeError i) {
                    }
                    catch (MissedIngredientSet i) {
                    }
                    catch (RegistrationError i) {
                    }
                    catch (MissingIngredientError i) {
                    }
                }
                for (String realName : hashMultimap.keySet()) {
                    int offset = 0;
                    for (IWebsiteSerializer ws : hashMultimap.get((Object)realName)) {
                        String rew = ws.getPattern(this);
                        if (rew == null || rew.length() <= 0) continue;
                        out.putNextEntry(new ZipEntry(realName + '_' + offset + ".txt"));
                        ++offset;
                        out.write(rew.getBytes());
                    }
                }
                out.close();
            }
            catch (FileNotFoundException e1) {
                AELog.debug(e1);
            }
            catch (IOException e1) {
                AELog.debug(e1);
            }
        }
    }

    private List<IWebsiteSerializer> findRecipe(ItemStack output) {
        LinkedList<IWebsiteSerializer> out = new LinkedList<IWebsiteSerializer>();
        for (ICraftHandler ch : this.data.handlers) {
            try {
                if (!(ch instanceof IWebsiteSerializer) || !((IWebsiteSerializer)((Object)ch)).canCraft(output)) continue;
                out.add((IWebsiteSerializer)((Object)ch));
            }
            catch (Throwable t) {
                AELog.debug(t);
            }
        }
        return out;
    }

    RecipeData getData() {
        return this.data;
    }

    private void processTokens(IRecipeLoader loader, String file, int line) throws RecipeError {
        block20: {
            try {
                IRecipeHandlerRegistry cr = AEApi.instance().registries().recipes();
                if (this.tokens.isEmpty()) {
                    return;
                }
                int split = this.tokens.indexOf("->");
                if (split != -1) {
                    String operation = this.tokens.remove(0).toLowerCase(Locale.ENGLISH);
                    if (operation.equals("alias")) {
                        if (this.tokens.size() == 3 && this.tokens.indexOf("->") == 1) {
                            this.data.aliases.put(this.tokens.get(0), this.tokens.get(2));
                            break block20;
                        }
                        throw new RecipeError("Alias must have exactly 1 input and 1 output.");
                    }
                    if (operation.equals("group")) {
                        List<String> pre = this.tokens.subList(0, split - 1);
                        List<String> post = this.tokens.subList(split, this.tokens.size());
                        List<List<IIngredient>> inputs = this.parseLines(pre);
                        if (inputs.size() == 1 && inputs.get(0).size() > 0 && post.size() == 1) {
                            this.data.groups.put(post.get(0), new GroupIngredient(post.get(0), inputs.get(0), 1));
                            break block20;
                        }
                        throw new RecipeError("Group must have exactly 1 output, and 1 or more inputs.");
                    }
                    if (operation.equals("ore")) {
                        List<String> pre = this.tokens.subList(0, split - 1);
                        List<String> post = this.tokens.subList(split, this.tokens.size());
                        List<List<IIngredient>> inputs = this.parseLines(pre);
                        if (inputs.size() == 1 && inputs.get(0).size() > 0 && post.size() == 1) {
                            OreRegistration ch = new OreRegistration(inputs.get(0), post.get(0));
                            this.addCrafting(ch);
                            break block20;
                        }
                        throw new RecipeError("Group must have exactly 1 output, and 1 or more inputs in a single row.");
                    }
                    List<String> pre = this.tokens.subList(0, split - 1);
                    List<String> post = this.tokens.subList(split, this.tokens.size());
                    List<List<IIngredient>> inputs = this.parseLines(pre);
                    List<List<IIngredient>> outputs = this.parseLines(post);
                    ICraftHandler ch = cr.getCraftHandlerFor(operation);
                    if (ch != null) {
                        ch.setup(inputs, outputs);
                        this.addCrafting(ch);
                        break block20;
                    }
                    throw new RecipeError("Invalid crafting type: " + operation);
                }
                String operation = this.tokens.remove(0).toLowerCase();
                if (operation.equals("exceptions") && (this.tokens.get(0).equals("true") || this.tokens.get(0).equals("false"))) {
                    if (this.tokens.size() == 1) {
                        this.data.exceptions = this.tokens.get(0).equals("true");
                        break block20;
                    }
                    throw new RecipeError("exceptions must be true or false explicitly.");
                }
                if (operation.equals("crash") && (this.tokens.get(0).equals("true") || this.tokens.get(0).equals("false"))) {
                    if (this.tokens.size() == 1) {
                        this.data.crash = this.tokens.get(0).equals("true");
                        break block20;
                    }
                    throw new RecipeError("crash must be true or false explicitly.");
                }
                if (operation.equals("erroronmissing")) {
                    if (this.tokens.size() == 1 && (this.tokens.get(0).equals("true") || this.tokens.get(0).equals("false"))) {
                        this.data.errorOnMissing = this.tokens.get(0).equals("true");
                        break block20;
                    }
                    throw new RecipeError("erroronmissing must be true or false explicitly.");
                }
                if (operation.equals("import")) {
                    if (this.tokens.size() == 1) {
                        new RecipeHandler(this).parseRecipes(loader, this.tokens.get(0));
                        break block20;
                    }
                    throw new RecipeError("Import must have exactly 1 input.");
                }
                throw new RecipeError(operation + ": " + this.tokens.toString() + "; recipe without an output.");
            }
            catch (RecipeError e) {
                AELog.warn("Recipe Error '" + e.getMessage() + "' near line:" + line + " in " + file + " with: " + this.tokens.toString(), new Object[0]);
                if (this.data.exceptions) {
                    AELog.debug(e);
                }
                if (!this.data.crash) break block20;
                throw e;
            }
        }
        this.tokens.clear();
    }

    private List<List<IIngredient>> parseLines(Iterable<String> subList) throws RecipeError {
        LinkedList<List<IIngredient>> out = new LinkedList<List<IIngredient>>();
        LinkedList<IIngredient> cList = new LinkedList<IIngredient>();
        boolean hasQty = false;
        int qty = 1;
        for (String v : subList) {
            if (v.equals(",")) {
                if (hasQty) {
                    throw new RecipeError("Qty found with no item.");
                }
                if (!cList.isEmpty()) {
                    out.add(cList);
                }
                cList = new LinkedList();
                continue;
            }
            if (this.isNumber(v)) {
                if (hasQty) {
                    throw new RecipeError("Qty found with no item.");
                }
                hasQty = true;
                qty = Integer.parseInt(v);
                continue;
            }
            if (hasQty) {
                cList.add(this.findIngredient(v, qty));
                hasQty = false;
                continue;
            }
            cList.add(this.findIngredient(v, 1));
        }
        if (!cList.isEmpty()) {
            out.add(cList);
        }
        return out;
    }

    private IIngredient findIngredient(String v, int qty) throws RecipeError {
        GroupIngredient gi = this.data.groups.get(v);
        if (gi != null) {
            return gi.copy(qty);
        }
        try {
            return new Ingredient(this, v, qty);
        }
        catch (MissedIngredientSet grp) {
            return new IngredientSet(grp.getResolverResultSet(), qty);
        }
    }

    private boolean isNumber(CharSequence v) {
        if (v.length() <= 0) {
            return false;
        }
        int l = v.length();
        for (int x = 0; x < l; ++x) {
            if (Character.isDigit(v.charAt(x))) continue;
            return false;
        }
        return true;
    }
}

