/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IItemList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class DisassembleRecipe
implements IRecipe {
    private static final ItemStack MISMATCHED_STACK = ItemStack.field_190927_a;
    private final Map<IItemDefinition, IItemDefinition> cellMappings;
    private final Map<IItemDefinition, IItemDefinition> nonCellMappings;
    private ResourceLocation name;

    public DisassembleRecipe() {
        IDefinitions definitions = AEApi.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IItems items = definitions.items();
        IMaterials mats = definitions.materials();
        this.cellMappings = new HashMap<IItemDefinition, IItemDefinition>(4);
        this.nonCellMappings = new HashMap<IItemDefinition, IItemDefinition>(5);
        this.cellMappings.put(items.cell1k(), mats.cell1kPart());
        this.cellMappings.put(items.cell4k(), mats.cell4kPart());
        this.cellMappings.put(items.cell16k(), mats.cell16kPart());
        this.cellMappings.put(items.cell64k(), mats.cell64kPart());
        this.nonCellMappings.put(items.encodedPattern(), mats.blankPattern());
        this.nonCellMappings.put(blocks.craftingStorage1k(), mats.cell1kPart());
        this.nonCellMappings.put(blocks.craftingStorage4k(), mats.cell4kPart());
        this.nonCellMappings.put(blocks.craftingStorage16k(), mats.cell16kPart());
        this.nonCellMappings.put(blocks.craftingStorage64k(), mats.cell64kPart());
    }

    public boolean func_77569_a(InventoryCrafting inv, World w) {
        return !this.getOutput((IInventory)inv).func_190926_b();
    }

    @Nullable
    private ItemStack getOutput(IInventory inventory) {
        int itemCount = 0;
        ItemStack output = MISMATCHED_STACK;
        for (int slotIndex = 0; slotIndex < inventory.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inventory.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            if (++itemCount > 1) {
                return MISMATCHED_STACK;
            }
            Optional<ItemStack> maybeCellOutput = this.getCellOutput(stackInSlot);
            if (maybeCellOutput.isPresent()) {
                IItemList list;
                ItemStack storageCellStack = maybeCellOutput.get();
                IMEInventoryHandler cellInv = AEApi.instance().registries().cell().getCellInventory(stackInSlot, null, StorageChannel.ITEMS);
                if (cellInv != null && !(list = cellInv.getAvailableItems(StorageChannel.ITEMS.createList())).isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                output = storageCellStack;
            }
            output = this.getNonCellOutput(stackInSlot).orElse(output);
        }
        return output;
    }

    @Nonnull
    private Optional<ItemStack> getCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.cellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<ItemStack> getNonCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.nonCellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.getOutput((IInventory)inv);
    }

    public boolean func_194133_a(int x, int y) {
        return 1 <= x * y;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }
}

