/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import appeng.recipes.game.IRecipeBakeable;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapelessRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe,
IRecipeBakeable {
    private final ArrayList<IIngredient> input = new ArrayList();
    private ItemStack output = ItemStack.field_190927_a;
    private boolean disable = false;
    private ResourceLocation name;

    public ShapelessRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (!(in instanceof IIngredient)) {
                StringBuilder ret = new StringBuilder("Invalid shapeless ore recipe: ");
                for (Object tmp : recipe) {
                    ret.append(tmp).append(", ");
                }
                ret.append(this.output);
                throw new IllegalArgumentException(ret.toString());
            }
            this.input.add((IIngredient)in);
        }
    }

    public boolean isEnabled() {
        return !this.disable;
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        if (this.disable) {
            return false;
        }
        ArrayList<IIngredient> required = new ArrayList<IIngredient>(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            for (IIngredient next : required) {
                boolean match = false;
                if (next instanceof IIngredient) {
                    try {
                        for (ItemStack item : next.getItemStackSet()) {
                            match = match || this.checkItemEquals(item, slot);
                        }
                    }
                    catch (RegistrationError registrationError) {
                    }
                    catch (MissingIngredientError missingIngredientError) {
                        // empty catch block
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        return target.func_77973_b() == input.func_77973_b() && (target.func_77952_i() == Short.MAX_VALUE || target.func_77952_i() == input.func_77952_i());
    }

    public ArrayList<IIngredient> getInput() {
        return this.input;
    }

    @Override
    public void bake() throws RegistrationError {
        try {
            this.disable = false;
            for (IIngredient o : this.input) {
                if (!(o instanceof IIngredient)) continue;
                o.bake();
            }
        }
        catch (MissingIngredientError e) {
            this.disable = true;
        }
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList out = NonNullList.func_191197_a((int)this.input.size(), (Object)Ingredient.field_193370_a);
        int index = 0;
        for (IIngredient in : this.input) {
            if (in == null) continue;
            try {
                out.set(index++, (Object)Ingredient.func_193369_a((ItemStack[])in.getItemStackSet()));
            }
            catch (MissingIngredientError | RegistrationError exception) {}
        }
        return out;
    }

    public String func_193358_e() {
        return "ae2";
    }
}

