/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.items.tools.powered.ToolWirelessTerminal;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class WirelessTerminalUpgradeRecipe
extends ShapelessRecipes {
    private final IItemDefinition termDef;

    public WirelessTerminalUpgradeRecipe(IItemDefinition termType) {
        super("", termType.maybeStack(1).orElseThrow(RuntimeException::new), NonNullList.func_191196_a());
        this.termDef = termType;
        this.field_77579_b.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{WirelessTerminalUpgradeRecipe.withUpgrade(termType)}));
        this.field_77579_b.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{AEApi.instance().definitions().materials().quantumDragonEgg().maybeStack(1).orElseThrow(RuntimeException::new)}));
    }

    private static ItemStack withUpgrade(IItemDefinition t) {
        ItemStack is = t.maybeStack(1).orElseThrow(RuntimeException::new);
        ToolWirelessTerminal.setHasQuantumEgg(is, true);
        return is;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack terminal = ItemStack.field_190927_a;
        block0: for (int i = 0; i < inv.func_174923_h() && terminal.func_190926_b(); ++i) {
            for (int j = 0; j < inv.func_174922_i(); ++j) {
                ItemStack itemstack = inv.func_70463_b(j, i);
                if (itemstack.func_190926_b() || !this.termDef.isSameAs(itemstack)) continue;
                terminal = itemstack.func_77946_l();
                continue block0;
            }
        }
        if (terminal.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ToolWirelessTerminal.setHasQuantumEgg(terminal, true);
        return terminal;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ArrayList list = Lists.newArrayList((Iterable)this.field_77579_b);
        for (int i = 0; i < inv.func_174923_h(); ++i) {
            for (int j = 0; j < inv.func_174922_i(); ++j) {
                ItemStack itemstack = inv.func_70463_b(j, i);
                if (itemstack.func_190926_b()) continue;
                boolean flag = false;
                for (Ingredient ingredient : list) {
                    if (!ingredient.apply(itemstack) || this.termDef.isSameAs(itemstack) && ToolWirelessTerminal.getHasQuantumEgg(itemstack)) continue;
                    flag = true;
                    list.remove(ingredient);
                    break;
                }
                if (flag) continue;
                return false;
            }
        }
        return list.isEmpty();
    }
}

