/*
 * Decompiled with CFR 0.152.
 */
package appeng.server;

import appeng.api.parts.CableRenderMode;
import appeng.block.AEBaseBlock;
import appeng.client.EffectType;
import appeng.core.CommonHelper;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.items.tools.ToolNetworkTool;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ServerHelper
extends CommonHelper {
    private EntityPlayer renderModeBased;

    @Override
    public void preinit() {
    }

    @Override
    public void init() {
    }

    @Override
    public World getWorld() {
        throw new UnsupportedOperationException("This is a server...");
    }

    @Override
    public void bindTileEntitySpecialRenderer(Class<? extends TileEntity> tile, AEBaseBlock blk) {
        throw new UnsupportedOperationException("This is a server...");
    }

    @Override
    public List<EntityPlayer> getPlayers() {
        MinecraftServer server;
        if (!Platform.isClient() && (server = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
            return server.func_184103_al().func_181057_v();
        }
        return new ArrayList<EntityPlayer>();
    }

    @Override
    public void sendToAllNearExcept(EntityPlayer p, double x, double y, double z, double dist, World w, AppEngPacket packet) {
        if (Platform.isClient()) {
            return;
        }
        for (EntityPlayer o : this.getPlayers()) {
            double dZ;
            double dY;
            double dX;
            EntityPlayerMP entityplayermp = (EntityPlayerMP)o;
            if (entityplayermp == p || entityplayermp.field_70170_p != w || !((dX = x - entityplayermp.field_70165_t) * dX + (dY = y - entityplayermp.field_70163_u) * dY + (dZ = z - entityplayermp.field_70161_v) * dZ < dist * dist)) continue;
            NetworkHandler.instance().sendTo(packet, entityplayermp);
        }
    }

    @Override
    public void spawnEffect(EffectType type, World world, double posX, double posY, double posZ, Object o) {
    }

    @Override
    public boolean shouldAddParticles(Random r) {
        return false;
    }

    @Override
    public RayTraceResult getRTR() {
        return null;
    }

    @Override
    public void postInit() {
    }

    @Override
    public CableRenderMode getRenderMode() {
        if (this.renderModeBased == null) {
            return CableRenderMode.STANDARD;
        }
        return this.renderModeForPlayer(this.renderModeBased);
    }

    @Override
    public void triggerUpdates() {
    }

    @Override
    public void updateRenderMode(EntityPlayer player) {
        this.renderModeBased = player;
    }

    @Override
    public void missingCoreMod() {
        throw new IllegalStateException("Unable to Load Core Mod, please verify that AE2 is properly install in the mods folder, with a .jar extension.");
    }

    protected CableRenderMode renderModeForPlayer(EntityPlayer player) {
        if (player != null) {
            for (int x = 0; x < InventoryPlayer.func_70451_h(); ++x) {
                NBTTagCompound c;
                ItemStack is = player.field_71071_by.func_70301_a(x);
                if (is.func_190926_b() || !(is.func_77973_b() instanceof ToolNetworkTool) || (c = is.func_77978_p()) == null || !c.func_74767_n("hideFacades")) continue;
                return CableRenderMode.CABLE_VIEW;
            }
        }
        return CableRenderMode.STANDARD;
    }
}

