/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.grindstone;

import appeng.api.AEApi;
import appeng.api.features.IGrinderRecipe;
import appeng.api.implementations.tiles.ICrankable;
import appeng.tile.AEBaseInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.WrapperInventoryRange;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileGrinder
extends AEBaseInvTile
implements ICrankable {
    private final int[] inputs = new int[]{0, 1, 2};
    private final int[] sides = new int[]{0, 1, 2, 3, 4, 5};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 7);
    private int points;

    @Override
    public void setOrientation(EnumFacing inForward, EnumFacing inUp) {
        super.setOrientation(inForward, inUp);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_145838_q().func_189540_a(state, this.field_145850_b, this.field_174879_c, state.func_177230_c(), this.field_174879_c);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public boolean func_180462_a(int slotIndex, ItemStack insertingItem, EnumFacing side) {
        if (AEApi.instance().registries().grinder().getRecipeForInput(insertingItem) == null) {
            return false;
        }
        return slotIndex >= 0 && slotIndex <= 2;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack extractedItem, EnumFacing side) {
        return slotIndex >= 3 && slotIndex <= 5;
    }

    @Override
    public int[] getAccessibleSlotsBySide(EnumFacing side) {
        return this.sides;
    }

    @Override
    public boolean canTurn() {
        if (Platform.isClient()) {
            return false;
        }
        if (this.func_70301_a(6).func_190926_b()) {
            WrapperInventoryRange src = new WrapperInventoryRange((IInventory)this, this.inputs, true);
            for (int x = 0; x < src.func_70302_i_(); ++x) {
                IGrinderRecipe r;
                ItemStack item = src.func_70301_a(x);
                if (item.func_190926_b() || (r = AEApi.instance().registries().grinder().getRecipeForInput(item)) == null || item.func_190916_E() < r.getInput().func_190916_E()) continue;
                ItemStack ais = item.func_77946_l();
                item.func_190917_f(-r.getInput().func_190916_E());
                ais.func_190920_e(r.getInput().func_190916_E());
                src.func_70299_a(x, item);
                this.func_70299_a(6, ais);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void applyTurn() {
        if (Platform.isClient()) {
            return;
        }
        ++this.points;
        ItemStack processing = this.func_70301_a(6);
        IGrinderRecipe r = AEApi.instance().registries().grinder().getRecipeForInput(processing);
        if (r != null) {
            if (r.getRequiredTurns() > this.points) {
                return;
            }
            this.points = 0;
            InventoryAdaptor sia = InventoryAdaptor.getAdaptor(new WrapperInventoryRange((IInventory)this, 3, 3, true), EnumFacing.EAST);
            this.addItem(sia, r.getOutput());
            r.getOptionalOutput().ifPresent(itemStack -> {
                float chance = (float)(Platform.getRandomInt() % 2000) / 2000.0f;
                if (chance <= r.getOptionalChance()) {
                    this.addItem(sia, (ItemStack)itemStack);
                }
            });
            r.getSecondOptionalOutput().ifPresent(itemStack -> {
                float chance = (float)(Platform.getRandomInt() % 2000) / 2000.0f;
                if (chance <= r.getSecondOptionalChance()) {
                    this.addItem(sia, (ItemStack)itemStack);
                }
            });
            this.func_70299_a(6, ItemStack.field_190927_a);
        }
    }

    private void addItem(InventoryAdaptor sia, ItemStack output) {
        if (output.func_190926_b()) {
            return;
        }
        ItemStack notAdded = sia.addItems(output);
        if (!notAdded.func_190926_b()) {
            ArrayList<ItemStack> out = new ArrayList<ItemStack>();
            out.add(notAdded);
            Platform.spawnDrops(this.field_145850_b, this.field_174879_c.func_177972_a(this.getForward()), out);
        }
    }

    @Override
    public boolean canCrankAttach(EnumFacing directionToCrank) {
        return this.getUp() == directionToCrank;
    }
}

