/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.tiles.ICrankable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class TileCharger
extends AENetworkPowerTile
implements ICrankable,
IGridTickable {
    private final int[] sides = new int[]{0};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    private int ticksWaited = 0;

    public TileCharger() {
        this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
        this.getProxy().setFlags(new GridFlags[0]);
        this.setInternalMaxPower(1500.0);
        this.getProxy().setIdlePowerUsage(0.0);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileCharger(ByteBuf data) {
        try {
            IAEItemStack item = AEItemStack.loadItemStackFromPacket(data);
            ItemStack is = item.getItemStack();
            this.inv.func_70299_a(0, is);
        }
        catch (Throwable t) {
            this.inv.func_70299_a(0, ItemStack.field_190927_a);
        }
        return false;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileCharger(ByteBuf data) throws IOException {
        AEItemStack is = AEItemStack.create(this.func_70301_a(0));
        if (is != null) {
            is.writeToPacket(data);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCharger(NBTTagCompound data) {
        data.func_74768_a("ticksWaited", this.ticksWaited);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCharger(NBTTagCompound data) {
        this.ticksWaited = data.func_74762_e("ticksWaited");
    }

    @Override
    public void setOrientation(EnumFacing inForward, EnumFacing inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.of(this.getUp(), this.getUp().func_176734_d()));
        this.setPowerSides(EnumSet.of(this.getUp(), this.getUp().func_176734_d()));
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    @Override
    public boolean canTurn() {
        return this.getInternalCurrentPower() < this.getInternalMaxPower();
    }

    @Override
    public void applyTurn() {
        IMaterials materials;
        this.injectExternalPower(PowerUnits.AE, 150.0);
        ItemStack myItem = this.func_70301_a(0);
        if (this.getInternalCurrentPower() > 1499.0 && (materials = AEApi.instance().definitions().materials()).certusQuartzCrystal().isSameAs(myItem)) {
            this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
            materials.certusQuartzCrystalCharged().maybeStack(myItem.func_190916_E()).ifPresent(charged -> this.func_70299_a(0, (ItemStack)charged));
        }
    }

    @Override
    public boolean canCrankAttach(EnumFacing directionToCrank) {
        return this.getUp() == directionToCrank || this.getUp().func_176734_d() == directionToCrank;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        IItemDefinition cert = AEApi.instance().definitions().materials().certusQuartzCrystal();
        return Platform.isChargeable(itemstack) || cert.isSameAs(itemstack);
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.ticksWaited = 0;
        try {
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack extractedItem, EnumFacing side) {
        IAEItemPowerStorage ips;
        if (Platform.isChargeable(extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.func_77973_b()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
            return true;
        }
        return AEApi.instance().definitions().materials().certusQuartzCrystalCharged().isSameAs(extractedItem);
    }

    @Override
    public int[] getAccessibleSlotsBySide(EnumFacing whichSide) {
        return this.sides;
    }

    public void activate(EntityPlayer player, EnumHand hand) {
        if (!Platform.hasPermissions(new DimensionalCoord(this), player)) {
            return;
        }
        ItemStack myItem = this.func_70301_a(0);
        if (myItem.func_190926_b()) {
            ItemStack held = player.func_184586_b(hand);
            if (AEApi.instance().definitions().materials().certusQuartzCrystal().isSameAs(held) || Platform.isChargeable(held)) {
                held = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                this.func_70299_a(0, held);
            }
        } else {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(myItem);
            this.func_70299_a(0, ItemStack.field_190927_a);
            Platform.spawnDrops(this.field_145850_b, this.field_174879_c.func_177972_a(this.getForward()), drops);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger.getMin(), TickRates.Charger.getMin(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doWork(ticksSinceLastCall) ? TickRateModulation.FASTER : TickRateModulation.SLEEP;
    }

    private boolean doWork(int ticksSinceLastCall) {
        ItemStack myItem = this.func_70301_a(0);
        if (this.getInternalCurrentPower() < 1499.0) {
            try {
                this.injectExternalPower(PowerUnits.AE, this.getProxy().getEnergy().extractAEPower(Math.min(150.0, 1500.0 - this.getInternalCurrentPower()), Actionable.MODULATE, PowerMultiplier.ONE));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return true;
        }
        if (myItem.func_190926_b()) {
            return false;
        }
        IMaterials materials = AEApi.instance().definitions().materials();
        if (this.getInternalCurrentPower() > 149.0 && Platform.isChargeable(myItem)) {
            IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.func_77973_b();
            if (ps.getAEMaxPower(myItem) > ps.getAECurrentPower(myItem)) {
                double oldPower = this.getInternalCurrentPower();
                double adjustment = ps.injectAEPower(myItem, this.extractAEPower(150.0 * (double)ticksSinceLastCall, Actionable.MODULATE, PowerMultiplier.CONFIG));
                this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                if (oldPower > this.getInternalCurrentPower()) {
                    this.markForUpdate();
                }
            }
        } else if (this.getInternalCurrentPower() > 1499.0 && materials.certusQuartzCrystal().isSameAs(myItem)) {
            this.ticksWaited += ticksSinceLastCall;
            if (this.ticksWaited >= 10) {
                this.ticksWaited = 0;
                this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                materials.certusQuartzCrystalCharged().maybeStack(myItem.func_190916_E()).ifPresent(charged -> this.func_70299_a(0, (ItemStack)charged));
            }
        }
        return true;
    }
}

