/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.capabilities.Capabilities;
import appeng.tile.AEBaseInvTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.tile.misc.CondenserFluidInventory;
import appeng.tile.misc.CondenserItemInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileCondenser
extends AEBaseInvTile
implements IConfigManagerHost,
IConfigurableObject {
    public static final int BYTE_MULTIPLIER = 8;
    private final int[] sides = new int[]{0, 1};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 3);
    private final ConfigManager cm = new ConfigManager(this);
    private final IItemHandler itemHandler = new ItemHandler();
    private final IFluidHandler fluidHandler = new FluidHandler();
    private final MEHandler meHandler = new MEHandler();
    private double storedPower = 0.0;
    private static final IFluidTankProperties[] EMPTY = new IFluidTankProperties[]{new FluidTankProperties(null, 10000, true, false)};

    public TileCondenser() {
        this.cm.registerSetting(Settings.CONDENSER_OUTPUT, (Enum)CondenserOutput.TRASH);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCondenser(NBTTagCompound data) {
        this.cm.writeToNBT(data);
        data.func_74780_a("storedPower", this.getStoredPower());
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCondenser(NBTTagCompound data) {
        this.cm.readFromNBT(data);
        this.setStoredPower(data.func_74769_h("storedPower"));
    }

    public double getStorage() {
        IStorageComponent sc;
        ItemStack is = this.inv.func_70301_a(2);
        if (!is.func_190926_b() && is.func_77973_b() instanceof IStorageComponent && (sc = (IStorageComponent)is.func_77973_b()).isStorageComponent(is)) {
            return sc.getBytes(is) * 8;
        }
        return 0.0;
    }

    public void addPower(double rawPower) {
        this.setStoredPower(this.getStoredPower() + rawPower);
        this.setStoredPower(Math.max(0.0, Math.min(this.getStorage(), this.getStoredPower())));
        double requiredPower = this.getRequiredPower();
        ItemStack output = this.getOutput();
        while (requiredPower <= this.getStoredPower() && !output.func_190926_b() && requiredPower > 0.0 && this.canAddOutput(output)) {
            this.setStoredPower(this.getStoredPower() - requiredPower);
            this.addOutput(output);
        }
    }

    private boolean canAddOutput(ItemStack output) {
        ItemStack outputStack = this.func_70301_a(1);
        return outputStack.func_190926_b() || Platform.itemComparisons().isEqualItem(outputStack, output) && outputStack.func_190916_E() < outputStack.func_77976_d();
    }

    private void addOutput(ItemStack output) {
        ItemStack outputStack = this.func_70301_a(1);
        if (outputStack.func_190926_b()) {
            this.func_70299_a(1, output.func_77946_l());
        } else {
            outputStack.func_190917_f(1);
            this.func_70299_a(1, outputStack);
        }
    }

    private ItemStack getOutput() {
        IMaterials materials = AEApi.instance().definitions().materials();
        switch ((CondenserOutput)this.cm.getSetting(Settings.CONDENSER_OUTPUT)) {
            case MATTER_BALLS: {
                return materials.matterBall().maybeStack(1).orElse(ItemStack.field_190927_a);
            }
            case SINGULARITY: {
                return materials.singularity().maybeStack(1).orElse(ItemStack.field_190927_a);
            }
        }
        return ItemStack.field_190927_a;
    }

    public double getRequiredPower() {
        return ((CondenserOutput)this.cm.getSetting((Settings)Settings.CONDENSER_OUTPUT)).requiredPower;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            if (!itemstack.func_190926_b()) {
                this.addPower(itemstack.func_190916_E());
            }
        } else {
            this.inv.func_70299_a(1, itemstack);
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        ItemStack is;
        if (slot == 0 && !(is = inv.func_70301_a(0)).func_190926_b()) {
            this.addPower(is.func_190916_E());
            inv.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public boolean func_180462_a(int slotIndex, ItemStack insertingItem, EnumFacing side) {
        return slotIndex == 0;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack extractedItem, EnumFacing side) {
        return slotIndex != 0;
    }

    @Override
    public int[] getAccessibleSlotsBySide(EnumFacing side) {
        return this.sides;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.addPower(0.0);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public double getStoredPower() {
        return this.storedPower;
    }

    private void setStoredPower(double storedPower) {
        this.storedPower = storedPower;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidHandler;
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return (T)this.meHandler;
        }
        return super.getCapability(capability, facing);
    }

    private class MEHandler
    implements IStorageMonitorableAccessor,
    IStorageMonitorable {
        private final CondenserFluidInventory fluidInventory;
        private final CondenserItemInventory itemInventory;

        private MEHandler() {
            this.fluidInventory = new CondenserFluidInventory(TileCondenser.this);
            this.itemInventory = new CondenserItemInventory(TileCondenser.this);
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(BaseActionSource src) {
            return this;
        }

        @Override
        public IMEMonitor<IAEItemStack> getItemInventory() {
            return this.itemInventory;
        }

        @Override
        public IMEMonitor<IAEFluidStack> getFluidInventory() {
            return this.fluidInventory;
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return EMPTY;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (doFill) {
                TileCondenser.this.addPower((resource == null ? 0.0 : (double)resource.amount) / 500.0);
            }
            return resource == null ? 0 : resource.amount;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }

    private class ItemHandler
    implements IItemHandler {
        private ItemHandler() {
        }

        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? ItemStack.field_190927_a : TileCondenser.this.inv.func_70301_a(1);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0) {
                return stack;
            }
            if (!simulate && !stack.func_190926_b()) {
                TileCondenser.this.addPower(stack.func_190916_E());
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 1) {
                return ItemStack.field_190927_a;
            }
            ItemStack available = TileCondenser.this.inv.func_70301_a(1);
            ItemStack output = available.func_77946_l();
            output.func_190920_e(Math.min(amount, available.func_190916_E()));
            if (!simulate) {
                available.func_190918_g(output.func_190916_E());
                TileCondenser.this.inv.func_70299_a(1, available);
            }
            return output;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? Integer.MAX_VALUE : TileCondenser.this.inv.func_70301_a(1).func_77976_d();
        }
    }
}

