/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;

public class TileVibrationChamber
extends AENetworkInvTile
implements IGridTickable {
    private static final int FUEL_SLOT_INDEX = 0;
    private static final double POWER_PER_TICK = 5.0;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0};
    private static final int MAX_BURN_SPEED = 200;
    private static final double DILATION_SCALING = 100.0;
    private static final int MIN_BURN_SPEED = 20;
    private final IInventory inv = new AppEngInternalInventory(this, 1);
    private int burnSpeed = 100;
    private double burnTime = 0.0;
    private double maxBurnTime = 0.0;
    public boolean isOn;

    public TileVibrationChamber() {
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(new GridFlags[0]);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean hasUpdate(ByteBuf data) {
        boolean wasOn = this.isOn;
        this.isOn = data.readBoolean();
        return wasOn != this.isOn;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToNetwork(ByteBuf data) {
        data.writeBoolean(this.getBurnTime() > 0.0);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileVibrationChamber(NBTTagCompound data) {
        data.func_74780_a("burnTime", this.getBurnTime());
        data.func_74780_a("maxBurnTime", this.getMaxBurnTime());
        data.func_74768_a("burnSpeed", this.getBurnSpeed());
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileVibrationChamber(NBTTagCompound data) {
        this.setBurnTime(data.func_74769_h("burnTime"));
        this.setMaxBurnTime(data.func_74769_h("maxBurnTime"));
        this.setBurnSpeed(data.func_74762_e("burnSpeed"));
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack) > 0;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.getBurnTime() <= 0.0 && this.canEatFuel()) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack extractedItem, EnumFacing side) {
        return extractedItem.func_77973_b() == Items.field_151133_ar;
    }

    @Override
    public int[] getAccessibleSlotsBySide(EnumFacing side) {
        return ACCESSIBLE_SLOTS;
    }

    private boolean canEatFuel() {
        int newBurnTime;
        ItemStack is = this.func_70301_a(0);
        return !is.func_190926_b() && (newBurnTime = TileEntityFurnace.func_145952_a((ItemStack)is)) > 0 && is.func_190916_E() > 0;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber.getMin(), TickRates.VibrationChamber.getMax(), this.getBurnTime() <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
            if (this.getBurnTime() > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.setBurnSpeed(100);
            return TickRateModulation.SLEEP;
        }
        this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
        double dilation = (double)this.getBurnSpeed() / 100.0;
        double timePassed = (double)ticksSinceLastCall * dilation;
        this.setBurnTime(this.getBurnTime() - timePassed);
        if (this.getBurnTime() < 0.0) {
            timePassed += this.getBurnTime();
            this.setBurnTime(0.0);
        }
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double newPower = timePassed * 5.0;
            double overFlow = grid.injectPower(newPower, Actionable.SIMULATE);
            grid.injectPower(Math.max(0.0, newPower - overFlow), Actionable.MODULATE);
            if (overFlow > 0.0) {
                this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
            } else {
                this.setBurnSpeed(this.getBurnSpeed() + ticksSinceLastCall);
            }
            this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
            return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
        }
        catch (GridAccessException e) {
            this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
            this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
            return TickRateModulation.SLOWER;
        }
    }

    private void eatFuel() {
        int newBurnTime;
        ItemStack is = this.func_70301_a(0);
        if (!is.func_190926_b() && (newBurnTime = TileEntityFurnace.func_145952_a((ItemStack)is)) > 0 && is.func_190916_E() > 0) {
            this.setBurnTime(this.getBurnTime() + (double)newBurnTime);
            this.setMaxBurnTime(this.getBurnTime());
            is.func_190917_f(-1);
            if (is.func_190916_E() <= 0) {
                ItemStack container = ItemStack.field_190927_a;
                if (is.func_77973_b() != null && is.func_77973_b().hasContainerItem(is)) {
                    container = is.func_77973_b().getContainerItem(is);
                }
                this.func_70299_a(0, container);
            } else {
                this.func_70299_a(0, is);
            }
            this.func_70296_d();
        }
        if (this.getBurnTime() > 0.0) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (!this.isOn && this.getBurnTime() > 0.0 || this.isOn && this.getBurnTime() <= 0.0) {
            this.isOn = this.getBurnTime() > 0.0;
            this.markForUpdate();
            if (this.func_145830_o()) {
                Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public int getBurnSpeed() {
        return this.burnSpeed;
    }

    private void setBurnSpeed(int burnSpeed) {
        this.burnSpeed = burnSpeed;
    }

    public double getMaxBurnTime() {
        return this.maxBurnTime;
    }

    private void setMaxBurnTime(double maxBurnTime) {
        this.maxBurnTime = maxBurnTime;
    }

    public double getBurnTime() {
        return this.burnTime;
    }

    private void setBurnTime(double burnTime) {
        this.burnTime = burnTime;
    }
}

