/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.PowerUnits;
import appeng.coremod.annotations.Integration;
import appeng.integration.IntegrationType;
import appeng.integration.Integrations;
import appeng.integration.abstraction.IC2PowerSink;
import appeng.tile.powersink.AERootPoweredTile;
import cofh.redstoneflux.api.IEnergyReceiver;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import java.util.EnumSet;
import net.minecraft.util.EnumFacing;

@Integration.InterfaceList(value={@Integration.Interface(iname=IntegrationType.RF, iface="cofh.redstoneflux.api.IEnergyReceiver"), @Integration.Interface(iname=IntegrationType.IC2, iface="ic2.api.energy.tile.IEnergySink")})
public abstract class AEBasePoweredTile
extends AERootPoweredTile
implements IEnergyReceiver,
IEnergySink {
    private IC2PowerSink ic2Sink = Integrations.ic2().createPowerSink(this, this);

    public AEBasePoweredTile() {
        this.ic2Sink.setValidFaces(EnumSet.allOf(EnumFacing.class));
    }

    public final int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int networkRFDemand = (int)Math.floor(this.getExternalPowerDemand(PowerUnits.RF, maxReceive));
        int usedRF = Math.min(maxReceive, networkRFDemand);
        if (!simulate) {
            this.injectExternalPower(PowerUnits.RF, usedRF);
        }
        return usedRF;
    }

    public final int getEnergyStored(EnumFacing from) {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower()));
    }

    public final int getMaxEnergyStored(EnumFacing from) {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower()));
    }

    public final boolean canConnectEnergy(EnumFacing from) {
        return this.getPowerSides().contains(from);
    }

    @Override
    protected void setPowerSides(EnumSet<EnumFacing> sides) {
        super.setPowerSides(sides);
        this.ic2Sink.setValidFaces(sides);
    }

    @Override
    public void onReady() {
        super.onReady();
        this.ic2Sink.onLoad();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.ic2Sink.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.ic2Sink.invalidate();
    }

    public double getDemandedEnergy() {
        return this.ic2Sink.getDemandedEnergy();
    }

    public int getSinkTier() {
        return this.ic2Sink.getSinkTier();
    }

    public double injectEnergy(EnumFacing var1, double var2, double var4) {
        return this.ic2Sink.injectEnergy(var1, var2, var4);
    }

    @Integration.Method(iname=IntegrationType.IC2)
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return this.ic2Sink.acceptsEnergyFrom(iEnergyEmitter, enumFacing);
    }
}

