/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.storage.DriveWatcher;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class TileDrive
extends AENetworkInvTile
implements IChestOrDrive,
IPriorityHost {
    private static final int BIT_POWER_MASK = Integer.MIN_VALUE;
    private static final int BIT_BLINK_MASK = 0x24924924;
    private static final int BIT_STATE_MASK = -613566757;
    private final int[] sides = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 10);
    private final ICellHandler[] handlersBySlot = new ICellHandler[10];
    private final DriveWatcher<IAEItemStack>[] invBySlot = new DriveWatcher[10];
    private final BaseActionSource mySrc;
    private boolean isCached = false;
    private List<MEInventoryHandler> items = new LinkedList<MEInventoryHandler>();
    private List<MEInventoryHandler> fluids = new LinkedList<MEInventoryHandler>();
    private int priority = 0;
    private boolean wasActive = false;
    private static byte NUMBER_CELLS = (byte)10;
    private static byte NUMBER_COLS = (byte)2;
    private static byte CELL_WIDTH = (byte)5;
    private static byte CELL_HEIGHT = (byte)2;
    private static byte CELL_GAP_X = (byte)2;
    private static byte CELL_GAP_Y = 1;
    private static byte[][] DRIVE_BOXES = new byte[NUMBER_CELLS][2];
    private int state = 0;

    public TileDrive() {
        this.mySrc = new MachineSource(this);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileDrive(ByteBuf data) {
        int newState = 0;
        if (this.getProxy().isActive()) {
            newState |= Integer.MIN_VALUE;
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x) << 3 * x;
        }
        data.writeInt(newState);
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.state >> slot * 3 & 3;
        }
        ItemStack cell = this.inv.func_70301_a(2);
        ICellHandler ch = this.handlersBySlot[slot];
        DriveWatcher<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return 0;
        }
        if (handler.getChannel() == StorageChannel.ITEMS && ch != null) {
            return ch.getStatusForCell(cell, handler.getInternal());
        }
        if (handler.getChannel() == StorageChannel.FLUIDS && ch != null) {
            return ch.getStatusForCell(cell, handler.getInternal());
        }
        return 0;
    }

    @Override
    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return (this.state >> slot * 3 + 2 & 1) == 1;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileDrive(ByteBuf data) {
        int oldState = this.state;
        this.state = data.readInt();
        return (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileDrive(NBTTagCompound data) {
        this.isCached = false;
        this.priority = data.func_74762_e("priority");
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileDrive(NBTTagCompound data) {
        data.func_74768_a("priority", this.priority);
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    private void recalculateDisplay() {
        boolean currentActive = this.getProxy().isActive();
        int newState = 0;
        if (currentActive) {
            newState |= Integer.MIN_VALUE;
        }
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x) << 3 * x;
        }
        if (newState != this.state) {
            this.state = newState;
            this.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return !itemstack.func_190926_b() && AEApi.instance().registries().cell().isCellHandled(itemstack);
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            IStorageGrid gs = this.getProxy().getStorage();
            Platform.postChanges(gs, removed, added, this.mySrc);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    @Override
    public int[] getAccessibleSlotsBySide(EnumFacing side) {
        return this.sides;
    }

    private void updateState() {
        if (!this.isCached) {
            this.items = new LinkedList<MEInventoryHandler>();
            this.fluids = new LinkedList<MEInventoryHandler>();
            double power = 2.0;
            for (int x = 0; x < this.inv.func_70302_i_(); ++x) {
                DriveWatcher ih;
                ItemStack is = this.inv.func_70301_a(x);
                this.invBySlot[x] = null;
                this.handlersBySlot[x] = null;
                if (is.func_190926_b()) continue;
                this.handlersBySlot[x] = AEApi.instance().registries().cell().getHandler(is);
                if (this.handlersBySlot[x] == null) continue;
                IMEInventoryHandler cell = this.handlersBySlot[x].getCellInventory(is, this, StorageChannel.ITEMS);
                if (cell != null) {
                    power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                    ih = new DriveWatcher(cell, is, this.handlersBySlot[x], this);
                    ih.setPriority(this.priority);
                    this.invBySlot[x] = ih;
                    this.items.add(ih);
                    continue;
                }
                cell = this.handlersBySlot[x].getCellInventory(is, this, StorageChannel.FLUIDS);
                if (cell == null) continue;
                power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                ih = new DriveWatcher(cell, is, this.handlersBySlot[x], this);
                ih.setPriority(this.priority);
                this.invBySlot[x] = ih;
                this.fluids.add(ih);
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive()) {
            this.updateState();
            return channel == StorageChannel.ITEMS ? this.items : this.fluids;
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.func_70296_d();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        this.state |= 1 << slot * 3 + 2;
        this.recalculateDisplay();
    }

    @Override
    public void saveChanges(IMEInventory cellInventory) {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    public int findSlotByXY(float x, float y) {
        int slot;
        int xPos = (int)((1.0 - (double)x) * 16.0);
        int yPos = (int)((1.0 - (double)y) * 16.0);
        for (slot = 0; slot < DRIVE_BOXES.length; ++slot) {
            byte[] box = DRIVE_BOXES[slot];
            if (box[1] > yPos) {
                slot = DRIVE_BOXES.length;
                break;
            }
            if (xPos >= box[0] && xPos < box[0] + CELL_WIDTH && yPos >= box[1] && yPos < box[1] + CELL_HEIGHT) break;
        }
        return slot < DRIVE_BOXES.length ? slot : -1;
    }

    public boolean tryAutoInsertDrive(float x, float y, ItemStack cell, EntityPlayer p, EnumHand hand) {
        int slot = this.findSlotByXY(x, y);
        if (slot > -1) {
            if (!this.func_70301_a(slot).func_190926_b()) {
                return false;
            }
            this.func_70299_a(slot, cell);
            p.func_184611_a(hand, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    public boolean tryAutoExtractDrive(float x, float y, EntityPlayer p, EnumHand hand) {
        int slot = this.findSlotByXY(x, y);
        if (slot > -1) {
            ItemStack cell = this.func_70301_a(slot);
            if (cell.func_190926_b()) {
                return false;
            }
            this.func_70299_a(slot, ItemStack.field_190927_a);
            p.func_184611_a(hand, cell);
            return true;
        }
        return false;
    }

    static {
        for (byte col = 0; col < NUMBER_COLS; col = (byte)(col + 1)) {
            for (int row = 0; row < NUMBER_CELLS / NUMBER_COLS; row = (int)((byte)(row + 1))) {
                byte[] cell = DRIVE_BOXES[row * 2 + col];
                cell[0] = (byte)((CELL_GAP_X + CELL_WIDTH) * col + CELL_GAP_X);
                cell[1] = (byte)((CELL_GAP_Y + CELL_HEIGHT) * row + CELL_GAP_Y);
            }
        }
    }
}

