/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.helpers;

import appeng.api.config.FuzzyMode;
import appeng.core.AELog;
import appeng.util.item.AESharedNBT;
import appeng.util.item.OreHelper;
import appeng.util.item.OreReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class ItemComparisonHelper {
    private static Field tagList;

    public boolean isEqualItemType(ItemStack that, ItemStack other) {
        if (!that.func_190926_b() && !other.func_190926_b() && that.func_77973_b() == other.func_77973_b()) {
            if (that.func_77984_f()) {
                return true;
            }
            return that.func_77952_i() == other.func_77952_i();
        }
        return false;
    }

    public boolean isEqualItem(@Nullable ItemStack left, @Nullable ItemStack right) {
        return !left.func_190926_b() && !right.func_190926_b() && left.func_77969_a(right);
    }

    public boolean isSameItem(@Nullable ItemStack is, @Nullable ItemStack filter) {
        return this.isEqualItem(is, filter) && this.hasSameNbtTag(is, filter);
    }

    public boolean isFuzzyEqualItem(ItemStack a, ItemStack b, FuzzyMode mode) {
        OreReference bOR;
        if (a.func_190926_b() && b.func_190926_b()) {
            return true;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (a.func_77973_b() != null && b.func_77973_b() != null && a.func_77973_b().func_77645_m() && a.func_77973_b() == b.func_77973_b()) {
            try {
                if (mode == FuzzyMode.IGNORE_ALL) {
                    return true;
                }
                if (mode == FuzzyMode.PERCENT_99) {
                    Item ai = a.func_77973_b();
                    Item bi = b.func_77973_b();
                    return ai.getDurabilityForDisplay(a) > 1.0 == bi.getDurabilityForDisplay(b) > 1.0;
                }
                Item ai = a.func_77973_b();
                Item bi = b.func_77973_b();
                float percentDamagedOfA = 1.0f - (float)ai.getDurabilityForDisplay(a);
                float percentDamagedOfB = 1.0f - (float)bi.getDurabilityForDisplay(b);
                return percentDamagedOfA > mode.breakPoint == percentDamagedOfB > mode.breakPoint;
            }
            catch (Throwable e) {
                if (mode == FuzzyMode.IGNORE_ALL) {
                    return true;
                }
                if (mode == FuzzyMode.PERCENT_99) {
                    return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                }
                float percentDamagedOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
                float percentDamagedOfB = (float)b.func_77952_i() / (float)b.func_77958_k();
                return percentDamagedOfA > mode.breakPoint == percentDamagedOfB > mode.breakPoint;
            }
        }
        OreReference aOR = OreHelper.INSTANCE.isOre(a);
        if (OreHelper.INSTANCE.sameOre(aOR, bOR = OreHelper.INSTANCE.isOre(b))) {
            return true;
        }
        return a.func_77969_a(b);
    }

    public boolean isNbtTagEqual(NBTBase left, NBTBase right) {
        byte id = left.func_74732_a();
        if (id == right.func_74732_a()) {
            switch (id) {
                case 10: {
                    NBTTagCompound ctA = (NBTTagCompound)left;
                    NBTTagCompound ctB = (NBTTagCompound)right;
                    Set cA = ctA.func_150296_c();
                    Set cB = ctB.func_150296_c();
                    if (cA.size() != cB.size()) {
                        return false;
                    }
                    for (String name : cA) {
                        NBTBase tag = ctA.func_74781_a(name);
                        NBTBase aTag = ctB.func_74781_a(name);
                        if (aTag == null) {
                            return false;
                        }
                        if (this.isNbtTagEqual(tag, aTag)) continue;
                        return false;
                    }
                    return true;
                }
                case 9: {
                    NBTTagList lA = (NBTTagList)left;
                    NBTTagList lB = (NBTTagList)right;
                    if (lA.func_74745_c() != lB.func_74745_c()) {
                        return false;
                    }
                    List<NBTBase> tag = this.tagList(lA);
                    List<NBTBase> aTag = this.tagList(lB);
                    if (tag.size() != aTag.size()) {
                        return false;
                    }
                    for (int x = 0; x < tag.size(); ++x) {
                        if (aTag.get(x) == null) {
                            return false;
                        }
                        if (this.isNbtTagEqual(tag.get(x), aTag.get(x))) continue;
                        return false;
                    }
                    return true;
                }
                case 1: {
                    return ((NBTPrimitive)left).func_150290_f() == ((NBTPrimitive)right).func_150290_f();
                }
                case 4: {
                    return ((NBTPrimitive)left).func_150291_c() == ((NBTPrimitive)right).func_150291_c();
                }
                case 8: {
                    return ((NBTTagString)left).func_150285_a_().equals(((NBTTagString)right).func_150285_a_());
                }
                case 6: {
                    return ((NBTPrimitive)left).func_150286_g() == ((NBTPrimitive)right).func_150286_g();
                }
                case 5: {
                    return ((NBTPrimitive)left).func_150288_h() == ((NBTPrimitive)right).func_150288_h();
                }
                case 3: {
                    return ((NBTPrimitive)left).func_150287_d() == ((NBTPrimitive)right).func_150287_d();
                }
            }
            return left.equals((Object)right);
        }
        return false;
    }

    public int createUnorderedNbtHash(NBTBase nbt) {
        int hash = 0;
        byte id = nbt.func_74732_a();
        hash += id;
        switch (id) {
            case 10: {
                NBTTagCompound ctA = (NBTTagCompound)nbt;
                Set cA = ctA.func_150296_c();
                for (String name : cA) {
                    hash += name.hashCode() ^ this.createUnorderedNbtHash(ctA.func_74781_a(name));
                }
                return hash;
            }
            case 9: {
                NBTTagList lA = (NBTTagList)nbt;
                hash += 9 * lA.func_74745_c();
                List<NBTBase> l = this.tagList(lA);
                for (int x = 0; x < l.size(); ++x) {
                    hash += Integer.valueOf(x).hashCode() ^ this.createUnorderedNbtHash(l.get(x));
                }
                return hash;
            }
            case 1: {
                return hash + ((NBTPrimitive)nbt).func_150290_f();
            }
            case 4: {
                return hash + (int)((NBTPrimitive)nbt).func_150291_c();
            }
            case 8: {
                return hash + ((NBTTagString)nbt).func_150285_a_().hashCode();
            }
            case 6: {
                return hash + (int)((NBTPrimitive)nbt).func_150286_g();
            }
            case 5: {
                return hash + (int)((NBTPrimitive)nbt).func_150288_h();
            }
            case 3: {
                return hash + ((NBTPrimitive)nbt).func_150287_d();
            }
        }
        return hash;
    }

    private boolean hasSameNbtTag(ItemStack a, ItemStack b) {
        NBTTagCompound tb;
        if (a.func_190926_b() && b.func_190926_b()) {
            return true;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (a == b) {
            return true;
        }
        NBTTagCompound ta = a.func_77978_p();
        if (ta == (tb = b.func_77978_p())) {
            return true;
        }
        if (ta == null && tb == null || ta != null && ta.func_82582_d() && tb == null || tb != null && tb.func_82582_d() && ta == null || ta != null && ta.func_82582_d() && tb != null && tb.func_82582_d()) {
            return true;
        }
        if (ta == null && tb != null || ta != null && tb == null) {
            return false;
        }
        if (AESharedNBT.isShared(ta) && AESharedNBT.isShared(tb)) {
            return ta == tb;
        }
        return this.isNbtTagEqual((NBTBase)ta, (NBTBase)tb);
    }

    private List<NBTBase> tagList(NBTTagList lB) {
        if (tagList == null) {
            try {
                tagList = lB.getClass().getDeclaredField("tagList");
            }
            catch (Throwable t) {
                try {
                    tagList = lB.getClass().getDeclaredField("field_74747_a");
                }
                catch (Throwable z) {
                    AELog.debug(t);
                    AELog.debug(z);
                }
            }
        }
        try {
            tagList.setAccessible(true);
            return (List)tagList.get(lB);
        }
        catch (Throwable t) {
            AELog.debug(t);
            return new ArrayList<NBTBase>();
        }
    }
}

