/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.IInventoryWrapper;
import appeng.util.inv.ItemSlot;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class AdaptorIInventory
extends InventoryAdaptor {
    private final IInventory i;
    private final boolean wrapperEnabled;

    public AdaptorIInventory(IInventory s) {
        this.i = s;
        this.wrapperEnabled = s instanceof IInventoryWrapper;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        ItemStack rv = ItemStack.field_190927_a;
        for (int x = 0; x < s && amount > 0; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is.func_190926_b() || !this.canRemoveStackFromSlot(x, is) || !filter.func_190926_b() && !Platform.itemComparisons().isSameItem(is, filter)) continue;
            int boundAmounts = amount;
            if (boundAmounts > is.func_190916_E()) {
                boundAmounts = is.func_190916_E();
            }
            if (destination != null && !destination.canInsert(is)) {
                boundAmounts = 0;
            }
            if (boundAmounts <= 0) continue;
            if (rv.func_190926_b()) {
                filter = rv = is.func_77946_l();
                rv.func_190920_e(boundAmounts);
                amount -= boundAmounts;
            } else {
                rv.func_190917_f(boundAmounts);
                amount -= boundAmounts;
            }
            if (is.func_190916_E() == boundAmounts) {
                this.i.func_70299_a(x, ItemStack.field_190927_a);
                this.i.func_70296_d();
                continue;
            }
            ItemStack po = is.func_77946_l();
            po.func_190917_f(-boundAmounts);
            this.i.func_70299_a(x, po);
            this.i.func_70296_d();
        }
        return rv;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        ItemStack rv = ItemStack.field_190927_a;
        for (int x = 0; x < s && amount > 0; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is.func_190926_b() || !this.canRemoveStackFromSlot(x, is) || !filter.func_190926_b() && !Platform.itemComparisons().isSameItem(is, filter)) continue;
            int boundAmount = amount;
            if (boundAmount > is.func_190916_E()) {
                boundAmount = is.func_190916_E();
            }
            if (destination != null && !destination.canInsert(is)) {
                boundAmount = 0;
            }
            if (boundAmount <= 0) continue;
            if (rv.func_190926_b()) {
                rv = is.func_77946_l();
                rv.func_190920_e(boundAmount);
                amount -= boundAmount;
                continue;
            }
            rv.func_190917_f(boundAmount);
            amount -= boundAmount;
        }
        return rv;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is.func_190926_b() || !this.canRemoveStackFromSlot(x, is) || !filter.func_190926_b() && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode)) continue;
            int newAmount = amount;
            if (newAmount > is.func_190916_E()) {
                newAmount = is.func_190916_E();
            }
            if (destination != null && !destination.canInsert(is)) {
                newAmount = 0;
            }
            ItemStack rv = ItemStack.field_190927_a;
            if (newAmount > 0) {
                rv = is.func_77946_l();
                rv.func_190920_e(newAmount);
                if (is.func_190916_E() == rv.func_190916_E()) {
                    this.i.func_70299_a(x, ItemStack.field_190927_a);
                    this.i.func_70296_d();
                } else {
                    ItemStack po = is.func_77946_l();
                    po.func_190917_f(-rv.func_190916_E());
                    this.i.func_70299_a(x, po);
                    this.i.func_70296_d();
                }
            }
            if (rv.func_190926_b()) continue;
            return rv;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is.func_190926_b() || !this.canRemoveStackFromSlot(x, is) || !filter.func_190926_b() && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode)) continue;
            int boundAmount = amount;
            if (boundAmount > is.func_190916_E()) {
                boundAmount = is.func_190916_E();
            }
            if (destination != null && !destination.canInsert(is)) {
                boundAmount = 0;
            }
            if (boundAmount <= 0) continue;
            ItemStack rv = is.func_77946_l();
            rv.func_190920_e(boundAmount);
            return rv;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, true);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.addItems(toBeSimulated, false);
    }

    @Override
    public boolean containsItems() {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            if (this.i.func_70301_a(x).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private ItemStack addItems(ItemStack itemsToAdd, boolean modulate) {
        if (itemsToAdd.func_190926_b() || itemsToAdd.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack left = itemsToAdd.func_77946_l();
        int stackLimit = itemsToAdd.func_77976_d();
        int perOperationLimit = Math.min(this.i.func_70297_j_(), stackLimit);
        int inventorySize = this.i.func_70302_i_();
        for (int slot = 0; slot < inventorySize; ++slot) {
            ItemStack next = left.func_77946_l();
            next.func_190920_e(Math.min(perOperationLimit, next.func_190916_E()));
            if (!this.i.func_94041_b(slot, next)) continue;
            ItemStack is = this.i.func_70301_a(slot);
            if (is.func_190926_b()) {
                left.func_190917_f(-next.func_190916_E());
                if (modulate) {
                    this.i.func_70299_a(slot, next);
                    this.i.func_70296_d();
                }
                if (left.func_190916_E() > 0) continue;
                return ItemStack.field_190927_a;
            }
            if (!Platform.itemComparisons().isSameItem(is, left) || is.func_190916_E() >= perOperationLimit) continue;
            int room = perOperationLimit - is.func_190916_E();
            int used = Math.min(left.func_190916_E(), room);
            if (modulate) {
                is.func_190917_f(used);
                this.i.func_70299_a(slot, is);
                this.i.func_70296_d();
            }
            left.func_190917_f(-used);
            if (left.func_190916_E() > 0) continue;
            return ItemStack.field_190927_a;
        }
        return left;
    }

    private boolean canRemoveStackFromSlot(int x, ItemStack is) {
        if (this.wrapperEnabled) {
            return ((IInventoryWrapper)this.i).canRemoveItemFromSlot(x, is);
        }
        return true;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new InvIterator();
    }

    private class InvIterator
    implements Iterator<ItemSlot> {
        private final ItemSlot is = new ItemSlot();
        private int x = 0;

        private InvIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.x < AdaptorIInventory.this.i.func_70302_i_();
        }

        @Override
        public ItemSlot next() {
            ItemStack iss = AdaptorIInventory.this.i.func_70301_a(this.x);
            this.is.setExtractable(AdaptorIInventory.this.canRemoveStackFromSlot(this.x, iss));
            this.is.setItemStack(iss);
            this.is.setSlot(this.x);
            ++this.x;
            return this.is;
        }

        @Override
        public void remove() {
        }
    }
}

