/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.iterators.StackToSlotIterator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AdaptorList
extends InventoryAdaptor {
    private final List<ItemStack> i;

    public AdaptorList(List<ItemStack> s) {
        this.i = s;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        int s = this.i.size();
        for (int x = 0; x < s; ++x) {
            ItemStack is = this.i.get(x);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isSameItem(is, filter)) continue;
            if (amount > is.func_190916_E()) {
                amount = is.func_190916_E();
            }
            if (destination != null && !destination.canInsert(is)) {
                amount = 0;
            }
            if (amount <= 0) continue;
            ItemStack rv = is.func_77946_l();
            rv.func_190920_e(amount);
            is.func_190917_f(-amount);
            if (is.func_190916_E() <= 0) {
                this.i.remove(x);
            }
            return rv;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        for (ItemStack is : this.i) {
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isSameItem(is, filter)) continue;
            if (amount > is.func_190916_E()) {
                amount = is.func_190916_E();
            }
            if (destination != null && !destination.canInsert(is)) {
                amount = 0;
            }
            if (amount <= 0) continue;
            ItemStack rv = is.func_77946_l();
            rv.func_190920_e(amount);
            return rv;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int s = this.i.size();
        for (int x = 0; x < s; ++x) {
            ItemStack is = this.i.get(x);
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode)) continue;
            if (amount > is.func_190916_E()) {
                amount = is.func_190916_E();
            }
            if (destination != null && !destination.canInsert(is)) {
                amount = 0;
            }
            if (amount <= 0) continue;
            ItemStack rv = is.func_77946_l();
            rv.func_190920_e(amount);
            is.func_190917_f(-amount);
            if (is.func_190916_E() <= 0) {
                this.i.remove(x);
            }
            return rv;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        for (ItemStack is : this.i) {
            if (is.func_190926_b() || !filter.func_190926_b() && !Platform.itemComparisons().isFuzzyEqualItem(is, filter, fuzzyMode)) continue;
            if (amount > is.func_190916_E()) {
                amount = is.func_190916_E();
            }
            if (destination != null && !destination.canInsert(is)) {
                amount = 0;
            }
            if (amount <= 0) continue;
            ItemStack rv = is.func_77946_l();
            rv.func_190920_e(amount);
            return rv;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        if (toBeAdded.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (toBeAdded.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack left = toBeAdded.func_77946_l();
        for (ItemStack is : this.i) {
            if (!Platform.itemComparisons().isEqualItem(is, left)) continue;
            is.func_190917_f(left.func_190916_E());
            return ItemStack.field_190927_a;
        }
        this.i.add(left);
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean containsItems() {
        for (ItemStack is : this.i) {
            if (is.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new StackToSlotIterator(this.i.iterator());
    }
}

