/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class WrapperChainedItemHandler
implements IItemHandler {
    private int fullSize = 0;
    private List<IItemHandler> l;
    private Map<Integer, InvOffset> offsets;

    public WrapperChainedItemHandler(IItemHandler ... inventories) {
        this.setInventory(inventories);
    }

    private void setInventory(IItemHandler ... a) {
        this.l = ImmutableList.copyOf((Object[])a);
        this.calculateSizes();
    }

    private void calculateSizes() {
        this.offsets = new HashMap<Integer, InvOffset>();
        int offset = 0;
        for (IItemHandler in : this.l) {
            InvOffset io = new InvOffset();
            io.offset = offset;
            io.size = in.getSlots();
            io.i = in;
            for (int y = 0; y < io.size; ++y) {
                this.offsets.put(y + io.offset, io);
            }
            offset += io.size;
        }
        this.fullSize = offset;
    }

    public WrapperChainedItemHandler(List<IItemHandler> inventories) {
        this.setInventory(inventories);
    }

    private void setInventory(List<IItemHandler> a) {
        this.l = a;
        this.calculateSizes();
    }

    public void cycleOrder() {
        if (this.l.size() > 1) {
            ArrayList<IItemHandler> newOrder = new ArrayList<IItemHandler>(this.l.size());
            newOrder.add(this.l.get(this.l.size() - 1));
            for (int x = 0; x < this.l.size() - 1; ++x) {
                newOrder.add(this.l.get(x));
            }
            this.setInventory(newOrder);
        }
    }

    public IItemHandler getInv(int idx) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return io.i;
        }
        return null;
    }

    public int getInvSlot(int idx) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return idx - io.offset;
        }
        return 0;
    }

    public int getSlots() {
        return this.fullSize;
    }

    public ItemStack getStackInSlot(int idx) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return io.i.getStackInSlot(idx - io.offset);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        InvOffset io = this.offsets.get(slot);
        if (io != null) {
            return io.i.insertItem(slot - io.offset, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        InvOffset io = this.offsets.get(slot);
        if (io != null) {
            return io.i.extractItem(slot - io.offset, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        InvOffset io = this.offsets.get(slot);
        if (io != null) {
            return io.i.getSlotLimit(slot - io.offset);
        }
        return 0;
    }

    private static class InvOffset {
        private int offset;
        private int size;
        private IItemHandler i;

        private InvOffset() {
        }
    }
}

