/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAETagCompound;
import appeng.core.AELog;
import appeng.util.Platform;
import appeng.util.item.AEItemDef;
import appeng.util.item.AESharedNBT;
import appeng.util.item.AEStack;
import appeng.util.item.OreHelper;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class AEItemStack
extends AEStack<IAEItemStack>
implements IAEItemStack,
Comparable<AEItemStack> {
    private AEItemDef def;
    private static Field capsField = null;

    private AEItemStack(AEItemStack is) {
        this.setDefinition(is.getDefinition());
        this.setStackSize(is.getStackSize());
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
    }

    private AEItemStack(ItemStack is) {
        if (is.func_190926_b()) {
            throw new InvalidParameterException("null is not a valid ItemStack for AEItemStack.");
        }
        Item item = is.func_77973_b();
        if (item == null) {
            throw new InvalidParameterException("Contained item is null, thus not a valid ItemStack for AEItemStack.");
        }
        this.setDefinition(new AEItemDef(item));
        if (this.getDefinition().getItem() == null) {
            throw new InvalidParameterException("This ItemStack is bad, it has a null item.");
        }
        this.getDefinition().setDamageValue(is.field_77991_e);
        if (!is.func_77973_b().func_77645_m()) {
            this.getDefinition().setDisplayDamage(Integer.MAX_VALUE);
        } else {
            this.getDefinition().setDisplayDamage((int)(is.func_77973_b().getDurabilityForDisplay(is) * 2.147483647E9));
        }
        this.getDefinition().setMaxDamage(is.func_77958_k());
        NBTTagCompound tagCompound = is.func_77978_p();
        if (tagCompound != null) {
            this.getDefinition().setTagCompound((AESharedNBT)AESharedNBT.getSharedTagCompound(tagCompound, is));
        }
        this.getDefinition().setCapsTag(AEItemStack.getCapsTag(is));
        this.setStackSize(is.func_190916_E());
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.getDefinition().reHash();
        this.getDefinition().setIsOre(OreHelper.INSTANCE.isOre(is));
    }

    private static AESharedNBT getCapsTag(ItemStack is) {
        if (capsField != null) {
            try {
                Object capsFieldO = capsField.get(is);
                if (capsFieldO != null && capsFieldO instanceof CapabilityDispatcher) {
                    CapabilityDispatcher capsField = (CapabilityDispatcher)capsFieldO;
                    return (AESharedNBT)AESharedNBT.getSharedTagCompound(capsField.serializeNBT(), is);
                }
                if (capsFieldO != null) {
                    AELog.debug("Caps filed has changed object type", new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                AELog.debug("Could not get caps field, access denied", new Object[0]);
            }
        }
        return null;
    }

    public static IAEItemStack loadItemStackFromNBT(NBTTagCompound i) {
        if (i == null) {
            return null;
        }
        ItemStack itemstack = new ItemStack(i);
        if (itemstack.func_190926_b()) {
            return null;
        }
        AEItemStack item = AEItemStack.create(itemstack);
        item.setStackSize(i.func_74763_f(AE2_NBT_KEYS.STACKSIZE.toString()));
        item.setCountRequestable(i.func_74763_f(AE2_NBT_KEYS.REQUESTABLE.toString()));
        item.setCraftable(i.func_74767_n(AE2_NBT_KEYS.CRAFTABLE.toString()));
        return item;
    }

    @Nullable
    public static AEItemStack create(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return new AEItemStack(stack);
    }

    public static IAEItemStack loadItemStackFromPacket(ByteBuf data) throws IOException {
        byte mask = data.readByte();
        byte stackType = (byte)((mask & 0xC) >> 2);
        byte countReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        short itemNumericId = data.readShort();
        d.func_74778_a(VANILLA_NBT_KEYS.ITEM_ID.toString(), String.valueOf(itemNumericId));
        d.func_74777_a(VANILLA_NBT_KEYS.DAMAGE.toString(), data.readShort());
        d.func_74774_a(VANILLA_NBT_KEYS.STACKSIZE.toString(), (byte)1);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readBytes(bd);
            ByteArrayInputStream di = new ByteArrayInputStream(bd);
            NBTTagCompound combinedTag = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(di));
            if (combinedTag.func_74764_b(AE2_NBT_KEYS.COMBINED_TAG.toString())) {
                d.func_74782_a(VANILLA_NBT_KEYS.COMPOUND.toString(), (NBTBase)combinedTag.func_74775_l(AE2_NBT_KEYS.COMBINED_TAG.toString()));
            }
            if (combinedTag.func_74764_b(AE2_NBT_KEYS.COMBINED_CAPS.toString())) {
                d.func_74782_a(VANILLA_NBT_KEYS.CAPS.toString(), (NBTBase)combinedTag.func_74775_l(AE2_NBT_KEYS.COMBINED_CAPS.toString()));
            }
        }
        long stackSize = AEItemStack.getPacketValue(stackType, data);
        long countRequestable = AEItemStack.getPacketValue(countReqType, data);
        ItemStack itemstack = new ItemStack(d);
        if (itemstack.func_190926_b()) {
            return null;
        }
        AEItemStack item = AEItemStack.create(itemstack);
        item.setStackSize(stackSize);
        item.setCountRequestable(countRequestable);
        item.setCraftable(isCraftable);
        return item;
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public void writeToNBT(NBTTagCompound i) {
        ResourceLocation resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.getItem());
        i.func_74778_a(VANILLA_NBT_KEYS.ITEM_ID.toString(), resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        i.func_74774_a(VANILLA_NBT_KEYS.STACKSIZE.toString(), (byte)1);
        i.func_74772_a(AE2_NBT_KEYS.STACKSIZE.toString(), this.getStackSize());
        i.func_74772_a(AE2_NBT_KEYS.REQUESTABLE.toString(), this.getCountRequestable());
        i.func_74757_a(AE2_NBT_KEYS.CRAFTABLE.toString(), this.isCraftable());
        i.func_74777_a(VANILLA_NBT_KEYS.DAMAGE.toString(), (short)this.getDefinition().getDamageValue());
        if (this.getDefinition().getTagCompound() != null) {
            i.func_74782_a(VANILLA_NBT_KEYS.COMPOUND.toString(), (NBTBase)this.getDefinition().getTagCompound());
        } else {
            i.func_82580_o(VANILLA_NBT_KEYS.COMPOUND.toString());
        }
        if (this.getDefinition().getCapsTag() != null) {
            i.func_74782_a(VANILLA_NBT_KEYS.CAPS.toString(), (NBTBase)this.getDefinition().getCapsTag());
        } else {
            i.func_82580_o(VANILLA_NBT_KEYS.CAPS.toString());
        }
    }

    @Override
    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        IAEItemStack o;
        if (st instanceof IAEItemStack) {
            o = (IAEItemStack)st;
            if (this.sameOre(o)) {
                return true;
            }
            if (o.getItem() == this.getItem()) {
                if (this.getDefinition().getItem().func_77645_m()) {
                    ItemStack a = this.getDisplayItemStack();
                    ItemStack b = o.getDisplayItemStack();
                    try {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            Item ai = a.func_77973_b();
                            Item bi = b.func_77973_b();
                            return ai.getDurabilityForDisplay(a) < (double)0.001f == bi.getDurabilityForDisplay(b) < (double)0.001f;
                        }
                        Item ai = a.func_77973_b();
                        Item bi = b.func_77973_b();
                        float percentDamageOfA = 1.0f - (float)ai.getDurabilityForDisplay(a);
                        float percentDamageOfB = 1.0f - (float)bi.getDurabilityForDisplay(b);
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                        }
                        float percentDamageOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
                        float percentDamageOfB = (float)b.func_77952_i() / (float)b.func_77958_k();
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.getItemDamage();
            }
        }
        if (st instanceof ItemStack) {
            o = (ItemStack)st;
            OreHelper.INSTANCE.sameOre(this, (ItemStack)o);
            if (o.func_77973_b() == this.getItem()) {
                if (this.getDefinition().getItem().func_77645_m()) {
                    ItemStack a = this.getDisplayItemStack();
                    try {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            Item ai = a.func_77973_b();
                            Item bi = o.func_77973_b();
                            return ai.getDurabilityForDisplay(a) < (double)0.001f == bi.getDurabilityForDisplay((ItemStack)o) < (double)0.001f;
                        }
                        Item ai = a.func_77973_b();
                        Item bi = o.func_77973_b();
                        float percentDamageOfA = 1.0f - (float)ai.getDurabilityForDisplay(a);
                        float percentDamageOfB = 1.0f - (float)bi.getDurabilityForDisplay((ItemStack)o);
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == o.func_77952_i() > 1;
                        }
                        float percentDamageOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
                        float percentDamageOfB = (float)o.func_77952_i() / (float)o.func_77958_k();
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.func_77952_i();
            }
        }
        return false;
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public IAEItemStack empty() {
        IAEItemStack dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public IAETagCompound getTagCompound() {
        return this.getDefinition().getTagCompound();
    }

    @Override
    public boolean isItem() {
        return true;
    }

    @Override
    public boolean isFluid() {
        return false;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack is = new ItemStack(this.getDefinition().getItem(), (int)Math.min(Integer.MAX_VALUE, this.getStackSize()), this.getDefinition().getDamageValue(), (NBTTagCompound)this.getDefinition().getCapsTag());
        if (this.getDefinition().getTagCompound() != null) {
            is.func_77982_d(this.getDefinition().getTagCompound().getNBTTagCompoundCopy());
        }
        return is;
    }

    @Override
    public ItemStack getDisplayItemStack() {
        ItemStack is = new ItemStack(this.getDefinition().getItem(), (int)Math.max(1L, Math.min(Integer.MAX_VALUE, this.getStackSize())), this.getDefinition().getDamageValue(), (NBTTagCompound)this.getDefinition().getCapsTag());
        if (this.getDefinition().getTagCompound() != null) {
            is.func_77982_d(this.getDefinition().getTagCompound().getNBTTagCompoundCopy());
        }
        return is;
    }

    @Override
    public Item getItem() {
        return this.getDefinition().getItem();
    }

    @Override
    public int getItemDamage() {
        return this.getDefinition().getDamageValue();
    }

    @Override
    public boolean sameOre(IAEItemStack is) {
        return OreHelper.INSTANCE.sameOre(this, is);
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.getDefinition().equals(((AEItemStack)otherStack).getDefinition());
    }

    @Override
    public boolean isSameType(ItemStack otherStack) {
        if (otherStack.func_190926_b()) {
            return false;
        }
        return this.getDefinition().isItem(otherStack);
    }

    public int hashCode() {
        return this.getDefinition().getMyHash();
    }

    @Override
    public boolean equals(Object ia) {
        ItemStack is;
        if (ia instanceof AEItemStack) {
            return ((AEItemStack)ia).getDefinition().equals(this.def);
        }
        if (ia instanceof ItemStack && (is = (ItemStack)ia).func_77973_b() == this.getDefinition().getItem() && is.func_77952_i() == this.getDefinition().getDamageValue()) {
            NBTTagCompound tb;
            AESharedNBT ta = this.getDefinition().getTagCompound();
            if (ta == (tb = is.func_77978_p())) {
                return true;
            }
            if (ta == null && tb == null || ta != null && ta.func_82582_d() && tb == null || tb != null && tb.func_82582_d() && ta == null || ta != null && ta.func_82582_d() && tb != null && tb.func_82582_d()) {
                return true;
            }
            if (ta == null && tb != null || ta != null && tb == null) {
                return false;
            }
            if (AESharedNBT.isShared(tb)) {
                return ta == tb;
            }
            return Platform.itemComparisons().isNbtTagEqual((NBTBase)ta, (NBTBase)tb) && this.getItemStack().areCapsCompatible((ItemStack)ia);
        }
        return false;
    }

    public String toString() {
        return this.getStackSize() + "x" + this.getItem().func_77658_a() + "@" + this.getItemDamage();
    }

    @Override
    public int compareTo(AEItemStack b) {
        int id = this.getDefinition().getItemID() - b.getDefinition().getItemID();
        if (id != 0) {
            return id;
        }
        int damageValue = this.getDefinition().getDamageValue() - b.getDefinition().getDamageValue();
        if (damageValue != 0) {
            return damageValue;
        }
        int displayDamage = this.getDefinition().getDisplayDamage() - b.getDefinition().getDisplayDamage();
        if (displayDamage != 0) {
            return displayDamage;
        }
        return this.getDefinition().getTagCompound() == b.getDefinition().getTagCompound() && this.getDefinition().getCapsTag() == b.getDefinition().getCapsTag() ? 0 : this.compareNBT(b.getDefinition());
    }

    private int compareNBT(AEItemDef b) {
        int nbt = this.compare(this.getDefinition().getTagCompound() == null ? 0 : this.getDefinition().getTagCompound().getHash(), b.getTagCompound() == null ? 0 : b.getTagCompound().getHash());
        if (nbt == 0) {
            return this.compare(System.identityHashCode(this.getDefinition().getTagCompound()), System.identityHashCode(b.getTagCompound()));
        }
        return nbt;
    }

    private int compare(int l, int m) {
        return l < m ? -1 : (l > m ? 1 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public List getToolTip() {
        if (this.getDefinition().getTooltip() != null) {
            return this.getDefinition().getTooltip();
        }
        return this.getDefinition().setTooltip(Platform.getTooltip(this.getDisplayItemStack()));
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.getDefinition().getDisplayName() == null) {
            this.getDefinition().setDisplayName(Platform.getItemDisplayName(this.getDisplayItemStack()));
        }
        return this.getDefinition().getDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    public String getModID() {
        if (this.getDefinition().getUniqueID() != null) {
            return this.getModName(this.getDefinition().getUniqueID());
        }
        return this.getModName(this.getDefinition().setUniqueID((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.getDefinition().getItem())));
    }

    private String getModName(ResourceLocation uniqueIdentifier) {
        if (uniqueIdentifier == null) {
            return "** Null";
        }
        return uniqueIdentifier.func_110624_b() == null ? "** Null" : uniqueIdentifier.func_110624_b();
    }

    IAEItemStack getLow(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack bottom = new AEItemStack(this);
        AEItemDef newDef = bottom.setDefinition(bottom.getDefinition().copy());
        if (ignoreMeta) {
            newDef.setDisplayDamage(newDef.setDamageValue(0));
            newDef.reHash();
            return bottom;
        }
        if (newDef.getItem().func_77645_m()) {
            if (fuzzy == FuzzyMode.IGNORE_ALL) {
                newDef.setDisplayDamage(0);
            } else if (fuzzy == FuzzyMode.PERCENT_99) {
                if (this.getDefinition().getDamageValue() == 0) {
                    newDef.setDisplayDamage(0);
                } else {
                    newDef.setDisplayDamage(1);
                }
            } else {
                int breakpoint = fuzzy.calculateBreakPoint(this.getDefinition().getMaxDamage());
                newDef.setDisplayDamage(breakpoint <= this.getDefinition().getDisplayDamage() ? breakpoint : 0);
            }
            newDef.setDamageValue(newDef.getDisplayDamage());
        }
        newDef.setTagCompound(AEItemDef.LOW_TAG);
        newDef.reHash();
        return bottom;
    }

    IAEItemStack getHigh(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack top = new AEItemStack(this);
        AEItemDef newDef = top.setDefinition(top.getDefinition().copy());
        if (ignoreMeta) {
            newDef.setDisplayDamage(newDef.setDamageValue(Integer.MAX_VALUE));
            newDef.reHash();
            return top;
        }
        if (newDef.getItem().func_77645_m()) {
            if (fuzzy == FuzzyMode.IGNORE_ALL) {
                newDef.setDisplayDamage(this.getDefinition().getMaxDamage() + 1);
            } else if (fuzzy == FuzzyMode.PERCENT_99) {
                if (this.getDefinition().getDamageValue() == 0) {
                    newDef.setDisplayDamage(0);
                } else {
                    newDef.setDisplayDamage(this.getDefinition().getMaxDamage() + 1);
                }
            } else {
                int breakpoint = fuzzy.calculateBreakPoint(this.getDefinition().getMaxDamage());
                newDef.setDisplayDamage(this.getDefinition().getDisplayDamage() < breakpoint ? breakpoint - 1 : this.getDefinition().getMaxDamage() + 1);
            }
            newDef.setDamageValue(newDef.getDisplayDamage());
        }
        newDef.setTagCompound(AEItemDef.HIGH_TAG);
        newDef.reHash();
        return top;
    }

    public boolean isOre() {
        return this.getDefinition().getIsOre() != null;
    }

    @Override
    void writeIdentity(ByteBuf i) throws IOException {
        i.writeShort(Item.field_150901_e.func_148757_b((Object)this.getDefinition().getItem()));
        i.writeShort(this.getItemDamage());
    }

    @Override
    void readNBT(ByteBuf i) throws IOException {
        if (this.hasTagCompound()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            NBTTagCompound combinedNBT = new NBTTagCompound();
            if (this.getTagCompound() != null) {
                combinedNBT.func_74782_a(AE2_NBT_KEYS.COMBINED_TAG.toString(), (NBTBase)this.getDefinition().getTagCompound());
            }
            if (this.getDefinition().getCapsTag() != null) {
                combinedNBT.func_74782_a(AE2_NBT_KEYS.COMBINED_CAPS.toString(), (NBTBase)this.getDefinition().getCapsTag());
            }
            CompressedStreamTools.func_74800_a((NBTTagCompound)combinedNBT, (DataOutput)data);
            byte[] tagBytes = bytes.toByteArray();
            int size = tagBytes.length;
            i.writeInt(size);
            i.writeBytes(tagBytes);
        }
    }

    @Override
    public boolean hasTagCompound() {
        return this.getDefinition().getTagCompound() != null || this.getDefinition().getCapsTag() != null;
    }

    AEItemDef getDefinition() {
        return this.def;
    }

    private AEItemDef setDefinition(AEItemDef def) {
        this.def = def;
        return def;
    }

    static {
        try {
            capsField = ItemStack.class.getDeclaredField("capabilities");
            capsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            AELog.warn("Caps field has changed in ItemStack, you may lose some data!", new Object[0]);
        }
    }

    private static enum AE2_NBT_KEYS {
        STACKSIZE("Cnt"),
        REQUESTABLE("Req"),
        CRAFTABLE("Craft"),
        COMBINED_TAG("compound"),
        COMBINED_CAPS("caps");

        private String val;

        private AE2_NBT_KEYS(String val) {
            this.val = val;
        }

        public String toString() {
            return this.val;
        }
    }

    private static enum VANILLA_NBT_KEYS {
        ITEM_ID("id"),
        DAMAGE("Damage"),
        STACKSIZE("Count"),
        COMPOUND("tag"),
        CAPS("ForgeCaps");

        private String val;

        private VANILLA_NBT_KEYS(String val) {
            this.val = val;
        }

        public String toString() {
            return this.val;
        }
    }
}

