/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.DoggyTalents;
import doggytalents.api.inferface.ITalent;
import doggytalents.lib.Constants;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;

public class TalentRegistry {
    public static List<ITalent> talents = new ArrayList<ITalent>();
    public static Map<String, ITalent> idtalent = new LinkedHashMap<String, ITalent>();
    public static Map<ITalent, String> talentid = new LinkedHashMap<ITalent, String>();

    public static void registerTalent(ITalent talent) {
        if (Constants.DISABLED_TALENTS.contains(talent.getKey())) {
            DoggyTalents.LOGGER.warn("The talent id {} has been disabled in the config file", (Object)talent.getKey());
        } else if (talents.contains(talent)) {
            DoggyTalents.LOGGER.warn("The talent id {} has already been registered", (Object)talent.getKey());
        } else if (talent.getKey().contains(":")) {
            DoggyTalents.LOGGER.warn("A talent id can't have the character ':' in it ({})", (Object)talent.getKey());
        } else {
            talents.add(talent);
            idtalent.put(talent.getKey(), talent);
            talentid.put(talent, talent.getKey());
            MinecraftForge.EVENT_BUS.register((Object)talent);
            DoggyTalents.LOGGER.info("Register the talent with the id {}", (Object)talent.getKey());
        }
    }

    public static List<ITalent> getTalents() {
        return talents;
    }

    public static ITalent getTalent(int index) {
        return talents.get(index);
    }

    public static ITalent getTalent(String id) {
        return idtalent.get(id);
    }
}

