/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.network.packet.client;

import doggytalents.api.inferface.ITalent;
import doggytalents.api.registry.TalentRegistry;
import doggytalents.entity.EntityDog;
import doggytalents.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class DogTalentMessage
extends AbstractMessage.AbstractServerMessage {
    public int entityId;
    public String talentId;

    public DogTalentMessage() {
    }

    public DogTalentMessage(int entityId, String talentId) {
        this.entityId = entityId;
        this.talentId = talentId;
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.entityId = buffer.readInt();
        this.talentId = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.talentId);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        ITalent talent;
        Entity target = player.field_70170_p.func_73045_a(this.entityId);
        if (!(target instanceof EntityDog)) {
            return;
        }
        EntityDog dog = (EntityDog)target;
        int level = dog.talents.getLevel(this.talentId);
        if (level < (talent = TalentRegistry.getTalent(this.talentId)).getHighestLevel(dog) && dog.spendablePoints() >= talent.getCost(dog, level + 1)) {
            dog.talents.setLevel(this.talentId, dog.talents.getLevel(this.talentId) + 1);
        }
    }
}

