/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.corporea;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaRequestEvent;
import vazkii.botania.api.corporea.ICorporeaAutoCompleteController;
import vazkii.botania.api.corporea.ICorporeaInterceptor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.IWrappedInventory;
import vazkii.botania.api.corporea.InvWithLocation;

public final class CorporeaHelper {
    private static final List<InvWithLocation> empty = ImmutableList.of();
    private static final WeakHashMap<List<ICorporeaSpark>, List<InvWithLocation>> cachedNetworks = new WeakHashMap();
    private static final List<ICorporeaAutoCompleteController> autoCompleteControllers = new ArrayList<ICorporeaAutoCompleteController>();
    private static final Pattern patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    public static final String[] WILDCARD_STRINGS = new String[]{"...", "~", "+", "?", "*"};
    public static int lastRequestMatches = 0;
    public static int lastRequestExtractions = 0;

    public static List<InvWithLocation> getInventoriesOnNetwork(ICorporeaSpark spark) {
        List<InvWithLocation> cache;
        ICorporeaSpark master = spark.getMaster();
        if (master == null) {
            return empty;
        }
        List<ICorporeaSpark> network = master.getConnections();
        if (cachedNetworks.containsKey(network) && (cache = cachedNetworks.get(network)) != null) {
            return cache;
        }
        ArrayList<InvWithLocation> inventories = new ArrayList<InvWithLocation>();
        if (network != null) {
            for (ICorporeaSpark otherSpark : network) {
                InvWithLocation inv;
                if (otherSpark == null || (inv = otherSpark.getSparkInventory()) == null) continue;
                inventories.add(inv);
            }
        }
        cachedNetworks.put(network, inventories);
        return inventories;
    }

    public static int getCountInNetwork(ItemStack stack, ICorporeaSpark spark, boolean checkNBT) {
        List<InvWithLocation> inventories = CorporeaHelper.getInventoriesOnNetwork(spark);
        return CorporeaHelper.getCountInNetwork(stack, inventories, checkNBT);
    }

    public static int getCountInNetwork(ItemStack stack, List<InvWithLocation> inventories, boolean checkNBT) {
        Map<InvWithLocation, Integer> map = CorporeaHelper.getInventoriesWithItemInNetwork(stack, inventories, checkNBT);
        return CorporeaHelper.getCountInNetwork(stack, map, checkNBT);
    }

    public static int getCountInNetwork(ItemStack stack, Map<InvWithLocation, Integer> inventories, boolean checkNBT) {
        int count = 0;
        for (InvWithLocation inv : inventories.keySet()) {
            count += inventories.get(inv).intValue();
        }
        return count;
    }

    public static Map<InvWithLocation, Integer> getInventoriesWithItemInNetwork(ItemStack stack, ICorporeaSpark spark, boolean checkNBT) {
        List<InvWithLocation> inventories = CorporeaHelper.getInventoriesOnNetwork(spark);
        return CorporeaHelper.getInventoriesWithItemInNetwork(stack, inventories, checkNBT);
    }

    public static Map<InvWithLocation, Integer> getInventoriesWithItemInNetwork(ItemStack stack, List<InvWithLocation> inventories, boolean checkNBT) {
        HashMap<InvWithLocation, Integer> countMap = new HashMap<InvWithLocation, Integer>();
        List<IWrappedInventory> wrappedInventories = BotaniaAPI.internalHandler.wrapInventory(inventories);
        for (IWrappedInventory inv : wrappedInventories) {
            CorporeaRequest request = new CorporeaRequest(stack, checkNBT, -1);
            inv.countItems(request);
            if (request.foundItems <= 0) continue;
            countMap.put(inv.getWrappedObject(), request.foundItems);
        }
        return countMap;
    }

    public static List<ItemStack> requestItem(ItemStack stack, ICorporeaSpark spark, boolean checkNBT, boolean doit) {
        return CorporeaHelper.requestItem(stack, stack.func_190916_E(), spark, checkNBT, doit);
    }

    public static List<ItemStack> requestItem(String name, int count, ICorporeaSpark spark, boolean doit) {
        return CorporeaHelper.requestItem(name, count, spark, false, doit);
    }

    public static List<ItemStack> requestItem(Object matcher, int itemCount, ICorporeaSpark spark, boolean checkNBT, boolean doit) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        CorporeaRequestEvent event = new CorporeaRequestEvent(matcher, itemCount, spark, checkNBT, doit);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return stacks;
        }
        List<InvWithLocation> inventories = CorporeaHelper.getInventoriesOnNetwork(spark);
        List<IWrappedInventory> inventoriesW = BotaniaAPI.internalHandler.wrapInventory(inventories);
        HashMap<ICorporeaInterceptor, ICorporeaSpark> interceptors = new HashMap<ICorporeaInterceptor, ICorporeaSpark>();
        CorporeaRequest request = new CorporeaRequest(matcher, checkNBT, itemCount);
        for (IWrappedInventory inv : inventoriesW) {
            ICorporeaSpark invSpark = inv.getSpark();
            InvWithLocation originalInventory = inv.getWrappedObject();
            if (originalInventory.world.func_175625_s(originalInventory.pos) instanceof ICorporeaInterceptor) {
                ICorporeaInterceptor interceptor = (ICorporeaInterceptor)originalInventory.world.func_175625_s(originalInventory.pos);
                interceptor.interceptRequest(matcher, itemCount, invSpark, spark, stacks, inventories, doit);
                interceptors.put(interceptor, invSpark);
            }
            if (doit) {
                stacks.addAll(inv.extractItems(request));
                continue;
            }
            stacks.addAll(inv.countItems(request));
        }
        lastRequestMatches = request.foundItems;
        lastRequestExtractions = request.extractedItems;
        for (ICorporeaInterceptor interceptor : interceptors.keySet()) {
            interceptor.interceptRequestLast(matcher, itemCount, (ICorporeaSpark)interceptors.get(interceptor), spark, stacks, inventories, doit);
        }
        return stacks;
    }

    public static ICorporeaSpark getSparkForInventory(InvWithLocation inv) {
        TileEntity tile = inv.world.func_175625_s(inv.pos);
        return CorporeaHelper.getSparkForBlock(tile.func_145831_w(), tile.func_174877_v());
    }

    public static ICorporeaSpark getSparkForBlock(World world, BlockPos pos) {
        List sparks = world.func_175647_a(Entity.class, new AxisAlignedBB(pos.func_177984_a(), pos.func_177982_a(1, 2, 1)), Predicates.instanceOf(ICorporeaSpark.class));
        return sparks.isEmpty() ? null : (ICorporeaSpark)sparks.get(0);
    }

    public static boolean doesBlockHaveSpark(World world, BlockPos pos) {
        return CorporeaHelper.getSparkForBlock(world, pos) != null;
    }

    public static boolean stacksMatch(ItemStack stack1, ItemStack stack2, boolean checkNBT) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77969_a(stack2) && (!checkNBT || ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2));
    }

    public static boolean stacksMatch(ItemStack stack, String s) {
        String name;
        if (stack.func_190926_b()) {
            return false;
        }
        boolean contains = false;
        for (String wc : WILDCARD_STRINGS) {
            if (s.endsWith(wc)) {
                contains = true;
                s = s.substring(0, s.length() - wc.length());
            } else if (s.startsWith(wc)) {
                contains = true;
                s = s.substring(wc.length());
            }
            if (contains) break;
        }
        return CorporeaHelper.equalOrContain(name = CorporeaHelper.stripControlCodes(stack.func_82833_r().toLowerCase().trim()), s, contains) || CorporeaHelper.equalOrContain(name + "s", s, contains) || CorporeaHelper.equalOrContain(name + "es", s, contains) || name.endsWith("y") && CorporeaHelper.equalOrContain(name.substring(0, name.length() - 1) + "ies", s, contains);
    }

    public static void clearCache() {
        cachedNetworks.clear();
    }

    public static boolean equalOrContain(String s1, String s2, boolean contain) {
        return contain ? s1.contains(s2) : s1.equals(s2);
    }

    public static void registerAutoCompleteController(ICorporeaAutoCompleteController controller) {
        autoCompleteControllers.add(controller);
    }

    public static boolean shouldAutoComplete() {
        for (ICorporeaAutoCompleteController controller : autoCompleteControllers) {
            if (!controller.shouldAutoComplete()) continue;
            return true;
        }
        return false;
    }

    public static String stripControlCodes(String str) {
        return patternControlCode.matcher(str).replaceAll("");
    }
}

