/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeElvenTrade {
    private final ImmutableList<ItemStack> outputs;
    private final ImmutableList<Object> inputs;

    public RecipeElvenTrade(ItemStack[] outputs, Object ... inputs) {
        this.outputs = ImmutableList.copyOf((Object[])outputs);
        ImmutableList.Builder inputsToSet = ImmutableList.builder();
        for (Object obj : inputs) {
            if (!(obj instanceof String) && !(obj instanceof ItemStack)) {
                throw new IllegalArgumentException("Invalid input");
            }
            inputsToSet.add(obj);
        }
        this.inputs = inputsToSet.build();
    }

    public boolean matches(List<ItemStack> stacks, boolean remove) {
        ArrayList<Object> inputsMissing = new ArrayList<Object>((Collection<Object>)this.inputs);
        ArrayList<ItemStack> stacksToRemove = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            if (inputsMissing.isEmpty()) break;
            int stackIndex = -1;
            int oredictIndex = -1;
            for (int j = 0; j < inputsMissing.size(); ++j) {
                Object input = inputsMissing.get(j);
                if (input instanceof String) {
                    NonNullList validStacks = OreDictionary.getOres((String)((String)input));
                    boolean found = false;
                    for (ItemStack ostack : validStacks) {
                        ItemStack cstack = ostack.func_77946_l();
                        if (cstack.func_77952_i() == Short.MAX_VALUE) {
                            cstack.func_77964_b(stack.func_77952_i());
                        }
                        if (!stack.func_77969_a(cstack)) continue;
                        if (!stacksToRemove.contains(stack)) {
                            stacksToRemove.add(stack);
                        }
                        oredictIndex = j;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!(input instanceof ItemStack) || !this.simpleAreStacksEqual((ItemStack)input, stack)) continue;
                if (!stacksToRemove.contains(stack)) {
                    stacksToRemove.add(stack);
                }
                stackIndex = j;
                break;
            }
            if (stackIndex != -1) {
                inputsMissing.remove(stackIndex);
                continue;
            }
            if (oredictIndex == -1) continue;
            inputsMissing.remove(oredictIndex);
        }
        if (remove) {
            for (ItemStack r : stacksToRemove) {
                stacks.remove(r);
            }
        }
        return inputsMissing.isEmpty();
    }

    private boolean simpleAreStacksEqual(ItemStack stack, ItemStack stack2) {
        return stack.func_77973_b() == stack2.func_77973_b() && stack.func_77952_i() == stack2.func_77952_i();
    }

    public List<Object> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }
}

