/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.subtile.ISubTileContainer;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityMagicLandmine;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class BlockHighlightRenderHandler {
    private BlockHighlightRenderHandler() {
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult pos = mc.field_71476_x;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GL11.glPushAttrib((int)64);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Botania.proxy.isClientPlayerWearingMonocle() && pos != null && pos.field_72308_g == null) {
            RadiusDescriptor descriptor;
            ISubTileContainer container;
            SubTileEntity subtile;
            TileEntity tile;
            BlockPos coords;
            BlockPos bPos = pos.func_178782_a();
            ItemStack stackHeld = PlayerHelper.getFirstHeldItem((EntityPlayer)mc.field_71439_g, ModItems.twigWand);
            if (!stackHeld.func_190926_b() && ItemTwigWand.getBindMode(stackHeld) && (coords = ItemTwigWand.getBoundTile(stackHeld)).func_177956_o() != -1) {
                bPos = coords;
            }
            if ((tile = mc.field_71441_e.func_175625_s(bPos)) != null && tile instanceof ISubTileContainer && (subtile = (container = (ISubTileContainer)tile).getSubTile()) != null && (descriptor = subtile.getRadius()) != null) {
                if (descriptor.isCircle()) {
                    BlockHighlightRenderHandler.renderCircle(descriptor.getSubtileCoords(), descriptor.getCircleRadius());
                } else {
                    BlockHighlightRenderHandler.renderRectangle(descriptor.getAABB(), true, null, (byte)32);
                }
            }
        }
        double offY = -0.0575;
        for (Entity e : mc.field_71441_e.field_72996_f) {
            if (!(e instanceof EntityMagicLandmine)) continue;
            BlockPos bpos = e.func_180425_c();
            AxisAlignedBB aabb = new AxisAlignedBB(bpos).func_72317_d(0.0, offY, 0.0).func_72314_b(2.5, 0.0, 2.5);
            float gs = (float)(Math.sin(ClientTickHandler.total / 20.0f) + 1.0) * 0.2f + 0.6f;
            int r = (int)(105.0f * gs);
            int g = (int)(25.0f * gs);
            int b = (int)(145.0f * gs);
            Color color = new Color(r, g, b);
            int alpha = 32;
            if (e.field_70173_aa < 8) {
                alpha = (int)((float)alpha * Math.min(((float)e.field_70173_aa + event.getPartialTicks()) / 8.0f, 1.0f));
            } else if (e.field_70173_aa > 47) {
                alpha = (int)((float)alpha * Math.min(1.0f - ((float)(e.field_70173_aa - 47) + event.getPartialTicks()) / 8.0f, 1.0f));
            }
            BlockHighlightRenderHandler.renderRectangle(aabb, false, color, (byte)alpha);
            offY += 0.001;
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    private static void renderRectangle(AxisAlignedBB aabb, boolean inner, Color color, byte alpha) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(aabb.field_72340_a - renderPosX), (double)(aabb.field_72338_b - renderPosY), (double)(aabb.field_72339_c - renderPosZ));
        if (color == null) {
            color = Color.getHSBColor((float)(ClientTickHandler.ticksInGame % 200) / 200.0f, 0.6f, 1.0f);
        }
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)alpha);
        double f = 0.0625;
        double x = aabb.field_72336_d - aabb.field_72340_a - f;
        double z = aabb.field_72334_f - aabb.field_72339_c - f;
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tessellator.func_178180_c().func_181662_b(x, f, f).func_181675_d();
        tessellator.func_178180_c().func_181662_b(f, f, f).func_181675_d();
        tessellator.func_178180_c().func_181662_b(f, f, z).func_181675_d();
        tessellator.func_178180_c().func_181662_b(x, f, z).func_181675_d();
        tessellator.func_78381_a();
        if (inner) {
            z += f;
            double f1 = f + f / 4.0;
            GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)(alpha * 2)));
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181705_e);
            tessellator.func_178180_c().func_181662_b(x += f, f1, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(0.0, f1, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(0.0, f1, z).func_181675_d();
            tessellator.func_178180_c().func_181662_b(x, f1, z).func_181675_d();
            tessellator.func_78381_a();
        }
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)-1);
        GlStateManager.func_179121_F();
    }

    private static void renderCircle(BlockPos center, double radius) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        GlStateManager.func_179094_E();
        double x = (double)center.func_177958_n() + 0.5;
        double y = center.func_177956_o();
        double z = (double)center.func_177952_p() + 0.5;
        GlStateManager.func_179137_b((double)(x - renderPosX), (double)(y - renderPosY), (double)(z - renderPosZ));
        int color = Color.HSBtoRGB((float)(ClientTickHandler.ticksInGame % 200) / 200.0f, 0.6f, 1.0f);
        Color colorRGB = new Color(color);
        GL11.glColor4ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()), (byte)32);
        double f = 0.0625;
        int totalAngles = 360;
        int drawAngles = 360;
        int step = totalAngles / drawAngles;
        radius -= f;
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(6, DefaultVertexFormats.field_181705_e);
        tessellator.func_178180_c().func_181662_b(0.0, f, 0.0).func_181675_d();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            double xp = Math.cos(rad) * radius;
            double zp = Math.sin(rad) * radius;
            tessellator.func_178180_c().func_181662_b(xp, f, zp).func_181675_d();
        }
        tessellator.func_178180_c().func_181662_b(0.0, f, 0.0).func_181675_d();
        tessellator.func_78381_a();
        radius += f;
        double f1 = f + f / 4.0;
        GL11.glColor4ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()), (byte)64);
        tessellator.func_178180_c().func_181668_a(6, DefaultVertexFormats.field_181705_e);
        tessellator.func_178180_c().func_181662_b(0.0, f1, 0.0).func_181675_d();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            double xp = Math.cos(rad) * radius;
            double zp = Math.sin(rad) * radius;
            tessellator.func_178180_c().func_181662_b(xp, f1, zp).func_181675_d();
        }
        tessellator.func_178180_c().func_181662_b(0.0, f1, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)-1);
        GlStateManager.func_179121_F();
    }
}

