/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class SpecialFlowerModel
implements IModel {
    public static final SpecialFlowerModel INSTANCE = new SpecialFlowerModel((ImmutableMap<Optional<String>, ModelResourceLocation>)ImmutableMap.of(), (ImmutableMap<Optional<String>, ModelResourceLocation>)ImmutableMap.of());
    private final ImmutableMap<Optional<String>, ModelResourceLocation> blockModels;
    private final ImmutableMap<Optional<String>, ModelResourceLocation> itemModels;

    public SpecialFlowerModel(ImmutableMap<Optional<String>, ModelResourceLocation> blockModels, ImmutableMap<Optional<String>, ModelResourceLocation> itemModels) {
        this.blockModels = blockModels;
        this.itemModels = itemModels;
    }

    public Collection<ResourceLocation> getDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)this.blockModels.values());
        builder.addAll((Iterable)this.itemModels.values());
        builder.addAll(BotaniaAPIClient.getRegisteredIslandTypeModels().values());
        return builder.build();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new SpecialFlowerBakedModel(this.blockModels, this.itemModels, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((IModelState)state));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder blockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (String string : customData.keySet()) {
            if (!"base".equals(string)) continue;
            blockBuilder.put(Optional.empty(), (Object)this.getLocation((String)customData.get((Object)string)));
        }
        for (Map.Entry entry : BotaniaAPIClient.getRegisteredSubtileBlockModels().entrySet()) {
            blockBuilder.put(Optional.of(entry.getKey()), entry.getValue());
        }
        for (Map.Entry entry : BotaniaAPIClient.getRegisteredSubtileItemModels().entrySet()) {
            itemBuilder.put(Optional.of(entry.getKey()), entry.getValue());
        }
        ImmutableMap blockModels = blockBuilder.build();
        ImmutableMap immutableMap = itemBuilder.build();
        if (blockModels.isEmpty() && immutableMap.isEmpty()) {
            return INSTANCE;
        }
        return new SpecialFlowerModel((ImmutableMap<Optional<String>, ModelResourceLocation>)blockModels, (ImmutableMap<Optional<String>, ModelResourceLocation>)immutableMap);
    }

    private ModelResourceLocation getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new ModelResourceLocation(e.getAsString());
        }
        Botania.LOGGER.error("Expect ModelResourceLocation, got: ", (Object)json);
        return new ModelResourceLocation("builtin/missing", "missing");
    }

    private static class SpecialFlowerBakedModel
    implements IBakedModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableMap<Optional<String>, ModelResourceLocation> blockModels;
        private final ImmutableMap<Optional<String>, ModelResourceLocation> itemModels;
        private final IBakedModel baseModel;
        private final LoadingCache<String, Optional<IBakedModel>> bakedBlockModels;
        private final LoadingCache<String, Optional<IBakedModel>> bakedItemModels;
        private final ItemStack roseFallback = new ItemStack((Block)Blocks.field_150328_O);
        private final ItemOverrideList itemHandler = new ItemOverrideList((List)ImmutableList.of()){

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel original, ItemStack stack, World world, EntityLivingBase living) {
                Optional item = (Optional)bakedItemModels.getUnchecked((Object)ItemBlockSpecialFlower.getType(stack));
                if (!item.isPresent()) {
                    item = (Optional)bakedBlockModels.getUnchecked((Object)ItemBlockSpecialFlower.getType(stack));
                }
                return item.isPresent() ? (IBakedModel)item.get() : Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(roseFallback);
            }
        };

        SpecialFlowerBakedModel(ImmutableMap<Optional<String>, ModelResourceLocation> blockModels, ImmutableMap<Optional<String>, ModelResourceLocation> itemModels, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            this.blockModels = blockModels;
            this.itemModels = itemModels;
            this.transforms = cameraTransforms;
            ModelResourceLocation baseModelPath = (ModelResourceLocation)blockModels.getOrDefault(Optional.empty(), (Object)new ModelResourceLocation("builtin/missing", "missing"));
            this.baseModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)baseModelPath).bake((IModelState)new SimpleModelState(this.transforms), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
            this.bakedBlockModels = CacheBuilder.newBuilder().build((CacheLoader)new Loader(true));
            this.bakedItemModels = CacheBuilder.newBuilder().build((CacheLoader)new Loader(false));
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long rand) {
            if (state.func_177230_c() != ModBlocks.specialFlower) {
                Botania.LOGGER.fatal("FOREIGN BLOCK: " + state);
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_188616_a(state, face, rand);
            }
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            String subtileId = (String)extendedState.getValue(BotaniaStateProps.SUBTILE_ID);
            IBakedModel ret = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            Optional specialModel = (Optional)this.bakedBlockModels.getUnchecked((Object)(subtileId == null ? "" : subtileId));
            if (specialModel.isPresent()) {
                ret = (IBakedModel)specialModel.get();
            }
            return ret.func_188616_a(state, face, rand);
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return this.itemHandler;
        }

        public boolean func_177555_b() {
            return this.baseModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.baseModel.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.baseModel.func_188618_c();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.baseModel.func_177554_e();
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return this.baseModel.func_177552_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        private class Loader
        extends CacheLoader<String, Optional<IBakedModel>> {
            private final boolean loadBlocks;

            Loader(boolean blocks) {
                this.loadBlocks = blocks;
            }

            public Optional<IBakedModel> load(@Nonnull String key) {
                ImmutableMap loadFrom = this.loadBlocks ? SpecialFlowerBakedModel.this.blockModels : SpecialFlowerBakedModel.this.itemModels;
                ModelResourceLocation loc = (ModelResourceLocation)loadFrom.get(Optional.of(key));
                if (loc == null) {
                    return Optional.empty();
                }
                IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)loc);
                if (model == ModelLoaderRegistry.getMissingModel()) {
                    return Optional.empty();
                }
                return Optional.of(model.bake((IModelState)new SimpleModelState(SpecialFlowerBakedModel.this.transforms), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
            }
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE{

            public void func_110549_a(@Nonnull IResourceManager resourceManager) {
            }

            public boolean accepts(ResourceLocation modelLocation) {
                return modelLocation.func_110624_b().equals("botania_special") && (modelLocation.func_110623_a().equals("specialflower") || modelLocation.func_110623_a().equals("models/block/specialflower") || modelLocation.func_110623_a().equals("models/item/specialflower"));
            }

            public IModel loadModel(ResourceLocation modelLocation) throws IOException {
                return SpecialFlowerModel.INSTANCE;
            }
        };

    }
}

