/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.lexicon.LexiconData;

@Mod.EventBusSubscriber
public class BlockFelPumpkin
extends BlockMod
implements ILexiconable {
    private static final String TAG_FEL_SPAWNED = "Botania-FelSpawned";

    public BlockFelPumpkin() {
        super(Material.field_151572_C, "felPumpkin");
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.SOUTH));
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150411_aY && world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == Blocks.field_150411_aY) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(pos.func_177979_c(2), Blocks.field_150350_a.func_176223_P(), 2);
            EntityBlaze blaze = new EntityBlaze(world);
            blaze.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 1.95, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            blaze.getEntityData().func_74757_a(TAG_FEL_SPAWNED, true);
            blaze.func_180482_a(world.func_175649_E(pos), null);
            world.func_72838_d((Entity)blaze);
            world.func_175685_c(pos, Blocks.field_150350_a, false);
            world.func_175685_c(pos.func_177977_b(), Blocks.field_150350_a, false);
            world.func_175685_c(pos.func_177979_c(2), Blocks.field_150350_a, false);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    @SubscribeEvent
    public static void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityBlaze && event.getEntityLiving().getEntityData().func_74767_n(TAG_FEL_SPAWNED)) {
            if (event.getDrops().isEmpty()) {
                event.getDrops().add(new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(Items.field_151065_br, 6)));
            } else {
                for (EntityItem item : event.getDrops()) {
                    ItemStack stack = item.func_92059_d();
                    if (stack.func_77973_b() != Items.field_151072_bj) continue;
                    item.func_92058_a(new ItemStack(Items.field_151065_br, stack.func_190916_E() * 10));
                }
            }
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.gardenOfGlass;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerBlockToState(this, 0, this.func_176223_P().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.NORTH));
    }
}

