/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.crafting.IInfusionStabiliser;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileFloatingFlower;
import vazkii.botania.common.block.tile.TileFloatingSpecialFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.IFloatingFlowerVariant;
import vazkii.botania.common.lexicon.LexiconData;

@Optional.Interface(modid="Thaumcraft", iface="thaumcraft.api.crafting.IInfusionStabiliser", striprefs=true)
public class BlockFloatingFlower
extends BlockMod
implements ILexiconable,
IInfusionStabiliser {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1, 0.1, 0.1, 0.9, 0.9, 0.9);

    public BlockFloatingFlower() {
        this("miniIsland");
    }

    public BlockFloatingFlower(String name) {
        super(Material.field_151578_c, name);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return ConfigHandler.staticFloaters ? EnumBlockRenderType.MODEL : EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BotaniaStateProps.COLOR}, new IUnlistedProperty[]{BotaniaStateProps.ISLAND_TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumDyeColor.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        state = this.func_176221_a(state, world, pos);
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof TileFloatingFlower) {
            state = ((IExtendedBlockState)state).withProperty(BotaniaStateProps.ISLAND_TYPE, (Object)((TileFloatingFlower)te).getIslandType());
        } else if (te instanceof TileFloatingSpecialFlower) {
            state = ((IExtendedBlockState)state).withProperty(BotaniaStateProps.ISLAND_TYPE, (Object)((TileFloatingSpecialFlower)te).getIslandType());
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int hex = ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_193350_e();
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (rand.nextDouble() < ConfigHandler.flowerParticleFrequency) {
            Botania.proxy.sparkleFX((double)pos.func_177958_n() + 0.3 + (double)rand.nextFloat() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)rand.nextFloat() * 0.5, (double)pos.func_177952_p() + 0.3 + (double)rand.nextFloat() * 0.5, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, rand.nextFloat(), 5);
        }
    }

    public void func_149666_a(CreativeTabs par2, NonNullList<ItemStack> par3) {
        for (int i = 0; i < 16; ++i) {
            par3.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            IFloatingFlower.IslandType newType;
            IFloatingFlower flower = (IFloatingFlower)world.func_175625_s(pos);
            IFloatingFlower.IslandType type = null;
            if (stack.func_77973_b() == Items.field_151126_ay) {
                type = IFloatingFlower.IslandType.SNOW;
            } else if (stack.func_77973_b() instanceof IFloatingFlowerVariant && (newType = ((IFloatingFlowerVariant)stack.func_77973_b()).getIslandType(stack)) != null) {
                type = newType;
            }
            if (type != null && type != flower.getIslandType()) {
                if (!world.field_72995_K) {
                    flower.setIslandType(type);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(world, pos);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileFloatingFlower();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.shinyFlowers;
    }

    public boolean canStabaliseInfusion(World world, BlockPos pos) {
        return ConfigHandler.enableThaumcraftStablizers;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelHandler.registerItemAllMeta(Item.func_150898_a((Block)this), EnumDyeColor.values().length);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }
}

