/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileGourmaryllis
extends SubTileGenerating {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_DIGESTING_MANA = "digestingMana";
    private static final String TAG_LAST_FOOD = "lastFood";
    private static final String TAG_LAST_FOOD_COUNT = "lastFoodCount";
    private static final int RANGE = 1;
    private int cooldown = 0;
    private int digestingMana = 0;
    private ItemStack lastFood = ItemStack.field_190927_a;
    private int lastFoodCount = 0;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.cooldown > -1) {
            --this.cooldown;
        }
        if (this.cooldown == 0 && this.digestingMana != 0) {
            this.mana = Math.min(this.getMaxMana(), this.mana + this.digestingMana);
            this.digestingMana = 0;
            this.getWorld().func_184133_a(null, this.supertile.func_174877_v(), SoundEvents.field_187739_dZ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.sync();
        }
        int slowdown = this.getSlowdownFactor();
        List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-1, -1, -1), this.supertile.func_174877_v().func_177982_a(2, 2, 2)));
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFood) || item.field_70128_L || item.field_70292_b < slowdown) continue;
            if (this.cooldown <= 0) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.lastFood, (ItemStack)stack)) {
                    ++this.lastFoodCount;
                } else {
                    this.lastFood = stack.func_77946_l();
                    this.lastFood.func_190920_e(1);
                    this.lastFoodCount = 1;
                }
                int val = Math.min(12, ((ItemFood)stack.func_77973_b()).func_150905_g(stack));
                this.digestingMana = val * val * 70;
                this.digestingMana = (int)((float)this.digestingMana * (1.0f / (float)this.lastFoodCount));
                this.cooldown = val * 10;
                item.func_184185_a(SoundEvents.field_187537_bA, 0.2f, 0.5f + (float)Math.random() * 0.5f);
                this.sync();
                ((WorldServer)this.supertile.func_145831_w()).func_180505_a(EnumParticleTypes.ITEM_CRACK, false, item.field_70165_t, item.field_70163_u, item.field_70161_v, 20, 0.1, 0.1, 0.1, 0.05, new int[]{Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77952_i()});
            }
            item.func_70106_y();
        }
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
        cmp.func_74768_a(TAG_DIGESTING_MANA, this.digestingMana);
        cmp.func_74782_a(TAG_LAST_FOOD, (NBTBase)this.lastFood.func_77955_b(new NBTTagCompound()));
        cmp.func_74768_a(TAG_LAST_FOOD_COUNT, this.lastFoodCount);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
        this.digestingMana = cmp.func_74762_e(TAG_DIGESTING_MANA);
        this.lastFood = new ItemStack(cmp.func_74775_l(TAG_LAST_FOOD));
        this.lastFoodCount = cmp.func_74762_e(TAG_LAST_FOOD_COUNT);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 9000;
    }

    @Override
    public int getColor() {
        return 13882884;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.gourmaryllis;
    }
}

