/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.ISubTileSlowableContainer;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.string.TileRedStringRelay;

public class TileSpecialFlower
extends TileMod
implements IWandBindable,
ISubTileSlowableContainer {
    private static final String TAG_SUBTILE_NAME = "subTileName";
    private static final String TAG_SUBTILE_CMP = "subTileCmp";
    public String subTileName = "";
    private SubTileEntity subTile;

    @Override
    public SubTileEntity getSubTile() {
        return this.subTile;
    }

    @Override
    public void setSubTile(String name) {
        this.subTileName = name;
        this.provideSubTile(this.subTileName);
    }

    public void setSubTile(SubTileEntity tile) {
        this.subTile = tile;
        this.subTile.setSupertile(this);
    }

    private void provideSubTile(String name) {
        this.subTileName = name;
        Class<? extends SubTileEntity> tileClass = BotaniaAPI.getSubTileMapping(name);
        try {
            SubTileEntity tile = tileClass.newInstance();
            this.setSubTile(tile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void func_73660_a() {
        if (this.subTile != null) {
            BlockPos coords;
            TileEntity tileBelow = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (tileBelow instanceof TileRedStringRelay && (coords = ((TileRedStringRelay)tileBelow).getBinding()) != null) {
                BlockPos currPos = this.field_174879_c;
                this.func_174878_a(coords);
                this.subTile.onUpdate();
                this.func_174878_a(currPos);
                return;
            }
            boolean special = this.isOnSpecialSoil();
            if (special) {
                this.subTile.overgrowth = true;
                if (this.subTile.isOvergrowthAffected()) {
                    this.subTile.onUpdate();
                    this.subTile.overgrowthBoost = true;
                }
            }
            this.subTile.onUpdate();
            this.subTile.overgrowth = false;
            this.subTile.overgrowthBoost = false;
        }
    }

    public boolean isOnSpecialSoil() {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == ModBlocks.enchantedSoil;
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        super.writePacketNBT(cmp);
        cmp.func_74778_a(TAG_SUBTILE_NAME, this.subTileName);
        NBTTagCompound subCmp = new NBTTagCompound();
        cmp.func_74782_a(TAG_SUBTILE_CMP, (NBTBase)subCmp);
        if (this.subTile != null) {
            this.subTile.writeToPacketNBTInternal(subCmp);
        }
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        super.readPacketNBT(cmp);
        this.subTileName = cmp.func_74779_i(TAG_SUBTILE_NAME);
        NBTTagCompound subCmp = cmp.func_74775_l(TAG_SUBTILE_CMP);
        if (this.subTile == null || !BotaniaAPI.getSubTileStringMapping(this.subTile.getClass()).equals(this.subTileName)) {
            this.provideSubTile(this.subTileName);
        }
        if (this.subTile != null) {
            this.subTile.readFromPacketNBTInternal(subCmp);
        }
    }

    public LexiconEntry getEntry() {
        return this.subTile == null ? null : this.subTile.getEntry();
    }

    public boolean onWanded(ItemStack wand, EntityPlayer player) {
        return this.subTile == null ? false : this.subTile.onWanded(player, wand);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (this.subTile != null) {
            this.subTile.onBlockPlacedBy(world, pos, state, entity, stack);
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.subTile == null ? false : this.subTile.onBlockActivated(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (this.subTile != null) {
            this.subTile.onBlockAdded(world, pos, state);
        }
    }

    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this.subTile != null) {
            this.subTile.onBlockHarvested(world, pos, state, player);
        }
    }

    public List<ItemStack> getDrops(List<ItemStack> list) {
        if (this.subTile != null) {
            this.subTile.getDrops(list);
        }
        return list;
    }

    public boolean func_145842_c(int id, int param) {
        if (this.subTile != null) {
            return this.subTile.receiveClientEvent(id, param);
        }
        return super.func_145842_c(id, param);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        if (this.subTile != null) {
            this.subTile.renderHUD(mc, res);
        }
    }

    @Override
    public BlockPos getBinding() {
        if (this.subTile == null) {
            return null;
        }
        return this.subTile.getBinding();
    }

    @Override
    public boolean canSelect(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        if (this.subTile == null) {
            return false;
        }
        return this.subTile.canSelect(player, wand, pos, side);
    }

    @Override
    public boolean bindTo(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        if (this.subTile == null) {
            return false;
        }
        return this.subTile.bindTo(player, wand, pos, side);
    }

    public int getLightValue() {
        if (this.subTile == null) {
            return 0;
        }
        return this.subTile.getLightValue();
    }

    public int getComparatorInputOverride() {
        if (this.subTile == null) {
            return 0;
        }
        return this.subTile.getComparatorInputOverride();
    }

    public int getPowerLevel(EnumFacing side) {
        if (this.subTile == null) {
            return 0;
        }
        return this.subTile.getPowerLevel(side);
    }

    @Override
    public int getSlowdownFactor() {
        BlockDirt.DirtType type;
        Block below = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c();
        if (below == Blocks.field_150391_bh) {
            return 10;
        }
        if (below == Blocks.field_150346_d && (type = (BlockDirt.DirtType)this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177229_b((IProperty)BlockDirt.field_176386_a)) == BlockDirt.DirtType.PODZOL) {
            return 5;
        }
        return 0;
    }
}

