/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class TileTerraPlate
extends TileMod
implements ISparkAttachable {
    public static final int MAX_MANA = 500000;
    private static final BlockPos[] LAPIS_BLOCKS = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1)};
    private static final BlockPos[] LIVINGROCK_BLOCKS = new BlockPos[]{new BlockPos(0, 0, 0), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1)};
    private static final String TAG_MANA = "mana";
    int mana;

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos relativePos : LAPIS_BLOCKS) {
            mb.addComponent(relativePos, Blocks.field_150368_y.func_176223_P());
        }
        for (BlockPos relativePos : LIVINGROCK_BLOCKS) {
            mb.addComponent(relativePos, ModBlocks.livingrock.func_176223_P());
        }
        mb.addComponent(new BlockPos(0, 1, 0), ModBlocks.terraPlate.func_176223_P());
        mb.setRenderOffset(new BlockPos(0, 1, 0));
        return mb.makeSet();
    }

    @Override
    public void func_73660_a() {
        List<EntityItem> items;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean removeMana = true;
        if (this.hasValidPlatform() && this.areItemsValid(items = this.getItems())) {
            removeMana = false;
            ISparkEntity spark = this.getAttachedSpark();
            if (spark != null) {
                List<ISparkEntity> sparkEntities = SparkHelper.getSparksAround(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                for (ISparkEntity otherSpark : sparkEntities) {
                    if (spark == otherSpark || otherSpark.getAttachedTile() == null || !(otherSpark.getAttachedTile() instanceof IManaPool)) continue;
                    otherSpark.registerTransfer(spark);
                }
            }
            if (this.mana > 0) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
                PacketHandler.sendToNearby(this.field_145850_b, this.func_174877_v(), (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.TERRA_PLATE, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), new int[0]));
            }
            if (this.mana >= 500000) {
                EntityItem item = items.get(0);
                for (EntityItem otherItem : items) {
                    if (otherItem != item) {
                        otherItem.func_70106_y();
                        continue;
                    }
                    item.func_92058_a(new ItemStack(ModItems.manaResource, 1, 4));
                }
                this.field_145850_b.func_184148_a(null, item.field_70165_t, item.field_70163_u, item.field_70161_v, ModSounds.terrasteelCraft, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.mana = 0;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
            }
        }
        if (removeMana) {
            this.recieveMana(-1000);
        }
    }

    List<EntityItem> getItems() {
        return this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
    }

    boolean areItemsValid(List<EntityItem> items) {
        if (items.size() != 3) {
            return false;
        }
        ItemStack ingot = ItemStack.field_190927_a;
        ItemStack pearl = ItemStack.field_190927_a;
        ItemStack diamond = ItemStack.field_190927_a;
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            if (stack.func_77973_b() != ModItems.manaResource || stack.func_190916_E() != 1) {
                return false;
            }
            int meta = stack.func_77952_i();
            if (meta == 0) {
                ingot = stack;
                continue;
            }
            if (meta == 1) {
                pearl = stack;
                continue;
            }
            if (meta == 2) {
                diamond = stack;
                continue;
            }
            return false;
        }
        return !ingot.func_190926_b() && !pearl.func_190926_b() && !diamond.func_190926_b();
    }

    boolean hasValidPlatform() {
        return this.checkAll(LAPIS_BLOCKS, Blocks.field_150368_y) && this.checkAll(LIVINGROCK_BLOCKS, ModBlocks.livingrock);
    }

    boolean checkAll(BlockPos[] relPositions, Block block) {
        for (BlockPos position : relPositions) {
            if (this.checkPlatform(position.func_177958_n(), position.func_177952_p(), block)) continue;
            return false;
        }
        return true;
    }

    boolean checkPlatform(int xOff, int zOff, Block block) {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(xOff, -1, zOff)).func_177230_c() == block;
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= 500000;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.max(0, Math.min(500000, this.mana + mana));
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return this.areItemsValid(this.getItems());
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public void attachSpark(ISparkEntity entity) {
    }

    @Override
    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return !this.areItemsValid(this.getItems());
    }

    @Override
    public int getAvailableSpaceForMana() {
        return Math.max(0, 500000 - this.getCurrentMana());
    }
}

