/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaAutoCompleteController;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.PlayerHelper;

public class TileCorporeaIndex
extends TileCorporeaBase
implements ICorporeaRequestor {
    public static final double RADIUS = 2.5;
    private static InputHandler input;
    public static final Set<TileCorporeaIndex> indexes;
    private static final Map<Pattern, IRegexStacker> patterns;
    public int ticks = 0;
    public int ticksWithCloseby = 0;
    public float closeby = 0.0f;
    public boolean hasCloseby;

    @Override
    public void func_73660_a() {
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(x - 2.5, y - 2.5, z - 2.5, x + 2.5, y + 2.5, z + 2.5));
        this.hasCloseby = false;
        for (EntityPlayer player : players) {
            if (!TileCorporeaIndex.isInRangeOfIndex(player, this)) continue;
            this.hasCloseby = true;
            break;
        }
        float step = 0.2f;
        ++this.ticks;
        if (this.hasCloseby) {
            ++this.ticksWithCloseby;
            if (this.closeby < 1.0f) {
                this.closeby += step;
            }
        } else if (this.closeby > 0.0f) {
            this.closeby -= step;
        }
        if (!this.func_145837_r() && !indexes.contains(this)) {
            indexes.add(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        indexes.remove(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        indexes.remove(this);
    }

    @Override
    public int getSizeInventory() {
        return 0;
    }

    @Override
    public void doCorporeaRequest(Object request, int count, ICorporeaSpark spark) {
        if (!(request instanceof String)) {
            return;
        }
        List<ItemStack> stacks = CorporeaHelper.requestItem((String)request, count, spark, true);
        spark.onItemsRequested(stacks);
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInRangeOfIndex(EntityPlayer player, TileCorporeaIndex index) {
        if (player.field_70170_p.field_73011_w.getDimension() != index.field_145850_b.field_73011_w.getDimension()) return false;
        if (!((double)MathHelper.pointDistancePlane((double)index.func_174877_v().func_177958_n() + 0.5, (double)index.func_174877_v().func_177952_p() + 0.5, player.field_70165_t, player.field_70161_v) < 2.5)) return false;
        double d = (double)index.func_174877_v().func_177956_o() + 0.5 - player.field_70163_u;
        double d2 = player.field_70170_p.field_72995_K ? 0.0 : 1.6;
        if (!(Math.abs(d + d2) < 5.0)) return false;
        return true;
    }

    public static void addPattern(String pattern, IRegexStacker stacker) {
        patterns.put(Pattern.compile(pattern), stacker);
    }

    public static int i(Matcher m, int g) {
        try {
            int i = Math.abs(Integer.parseInt(m.group(g)));
            return i;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static InputHandler getInputHandler() {
        if (input == null) {
            input = new InputHandler();
        }
        return input;
    }

    static {
        indexes = Collections.newSetFromMap(new WeakHashMap());
        patterns = new LinkedHashMap<Pattern, IRegexStacker>();
        TileCorporeaIndex.addPattern("(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("a??n?? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? stacks?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?stack (?:(?:and)|(?:\\+)) (\\d+)(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 + TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? stacks? (?:(?:and)|(?:\\+)) (\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * TileCorporeaIndex.i(m, 1) + TileCorporeaIndex.i(m, 2);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(3);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?half (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 32;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?quarter (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 16;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?dozen(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? dozens?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:all|every) (?:(?:of|the) )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return Integer.MAX_VALUE;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:the )?answer to life,? the universe and everything (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 42;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:count|show|display|tell) (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 0;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
    }

    public static interface IRegexStacker {
        public int getCount(Matcher var1);

        public String getName(Matcher var1);
    }

    public static final class InputHandler
    implements ICorporeaAutoCompleteController {
        public InputHandler() {
            CorporeaHelper.registerAutoCompleteController(this);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onChatMessage(ServerChatEvent event) {
            List<TileCorporeaIndex> nearbyIndexes = InputHandler.getNearbyIndexes((EntityPlayer)event.getPlayer());
            if (!nearbyIndexes.isEmpty()) {
                String msg = event.getMessage().toLowerCase().trim();
                for (TileCorporeaIndex index : nearbyIndexes) {
                    ItemStack stack;
                    ICorporeaSpark spark;
                    if (((TileCorporeaIndex)index).field_145850_b.field_72995_K || (spark = index.getSpark()) == null) continue;
                    String name = "";
                    int count = 0;
                    for (Pattern pattern : patterns.keySet()) {
                        Matcher matcher = pattern.matcher(msg);
                        if (!matcher.matches()) continue;
                        IRegexStacker stacker = (IRegexStacker)patterns.get(pattern);
                        count = stacker.getCount(matcher);
                        name = stacker.getName(matcher).toLowerCase().trim();
                        pattern.toString();
                    }
                    if (name.equals("this") && !(stack = event.getPlayer().func_184614_ca()).func_190926_b()) {
                        name = stack.func_82833_r().toLowerCase().trim();
                    }
                    index.doCorporeaRequest(name, count, spark);
                    event.getPlayer().func_145747_a(new TextComponentTranslation("botaniamisc.requestMsg", new Object[]{count, WordUtils.capitalizeFully((String)name), CorporeaHelper.lastRequestMatches, CorporeaHelper.lastRequestExtractions}).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)));
                    if (CorporeaHelper.lastRequestExtractions < 50000) continue;
                    PlayerHelper.grantCriterion(event.getPlayer(), new ResourceLocation("botania", "challenge/super_corporea_request"), "code_triggered");
                }
                event.setCanceled(true);
            }
        }

        public static List<TileCorporeaIndex> getNearbyIndexes(EntityPlayer player) {
            ArrayList<TileCorporeaIndex> indexList = new ArrayList<TileCorporeaIndex>();
            for (TileCorporeaIndex index : indexes) {
                if (!TileCorporeaIndex.isInRangeOfIndex(player, index) || ((TileCorporeaIndex)index).field_145850_b.field_72995_K != player.field_70170_p.field_72995_K) continue;
                indexList.add(index);
            }
            return indexList;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean shouldAutoComplete() {
            return !InputHandler.getNearbyIndexes((EntityPlayer)Minecraft.func_71410_x().field_71439_g).isEmpty();
        }
    }
}

