/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class EntitySpark
extends Entity
implements ISparkEntity {
    private static final int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    private static final String TAG_INVIS = "invis";
    private static final DataParameter<Integer> UPGRADE = EntityDataManager.func_187226_a(EntitySpark.class, (DataSerializer)DataSerializers.field_187192_b);
    private final Set<ISparkEntity> transfers = Collections.newSetFromMap(new WeakHashMap());
    private int removeTransferants = 2;

    public EntitySpark(World world) {
        super(world);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        this.func_70105_a(0.1f, 0.5f);
        this.field_70180_af.func_187214_a(UPGRADE, (Object)0);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ModItems.spark);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ISparkAttachable tile = this.getAttachedTile();
        if (tile == null) {
            this.dropAndKill();
            return;
        }
        SparkUpgradeType upgrade = this.getUpgrade();
        List<ISparkEntity> allSparks = null;
        if (upgrade == SparkUpgradeType.DOMINANT || upgrade == SparkUpgradeType.RECESSIVE) {
            allSparks = SparkHelper.getSparksAround(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        Collection<ISparkEntity> transfers = this.getTransfers();
        switch (upgrade) {
            case DISPERSIVE: {
                EntityPlayer player2;
                List<EntityPlayer> players = SparkHelper.getEntitiesAround(EntityPlayer.class, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                HashMap receivingPlayers = new HashMap();
                ItemStack input = new ItemStack(ModItems.spark);
                for (EntityPlayer player2 : players) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    stacks.addAll((Collection<ItemStack>)player2.field_71071_by.field_70462_a);
                    stacks.addAll((Collection<ItemStack>)player2.field_71071_by.field_70460_b);
                    IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player2);
                    for (int i = 0; i < baubles.getSlots(); ++i) {
                        stacks.add(baubles.getStackInSlot(i));
                    }
                    for (ItemStack stack : stacks) {
                        int recv;
                        TObjectIntHashMap receivingStacks;
                        IManaItem manaItem;
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem) || !(manaItem = (IManaItem)stack.func_77973_b()).canReceiveManaFromItem(stack, input)) continue;
                        boolean add = false;
                        if (!receivingPlayers.containsKey(player2)) {
                            add = true;
                            receivingStacks = new TObjectIntHashMap();
                        } else {
                            receivingStacks = (TObjectIntHashMap)receivingPlayers.get(player2);
                        }
                        if ((recv = Math.min(this.getAttachedTile().getCurrentMana(), Math.min(1000, manaItem.getMaxMana(stack) - manaItem.getMana(stack)))) <= 0) continue;
                        receivingStacks.put((Object)stack, recv);
                        if (!add) continue;
                        receivingPlayers.put(player2, receivingStacks);
                    }
                }
                if (receivingPlayers.isEmpty()) break;
                ArrayList keys = new ArrayList(receivingPlayers.keySet());
                Collections.shuffle(keys);
                player2 = (EntityPlayer)keys.iterator().next();
                TObjectIntHashMap items = (TObjectIntHashMap)receivingPlayers.get(player2);
                ItemStack stack = (ItemStack)items.keySet().iterator().next();
                int cost = items.get((Object)stack);
                int manaToPut = Math.min(this.getAttachedTile().getCurrentMana(), cost);
                ((IManaItem)stack.func_77973_b()).addMana(stack, manaToPut);
                this.getAttachedTile().recieveMana(-manaToPut);
                this.particlesTowards((Entity)player2);
                break;
            }
            case DOMINANT: {
                ArrayList validSparks = new ArrayList();
                for (ISparkEntity spark : allSparks) {
                    SparkUpgradeType upgrade_;
                    if (spark == this || (upgrade_ = spark.getUpgrade()) != SparkUpgradeType.NONE || !(spark.getAttachedTile() instanceof IManaPool)) continue;
                    validSparks.add(spark);
                }
                if (validSparks.size() <= 0) break;
                ((ISparkEntity)validSparks.get(this.field_70170_p.field_73012_v.nextInt(validSparks.size()))).registerTransfer(this);
                break;
            }
            case RECESSIVE: {
                for (ISparkEntity spark : allSparks) {
                    SparkUpgradeType upgrade_;
                    if (spark == this || (upgrade_ = spark.getUpgrade()) == SparkUpgradeType.DOMINANT || upgrade_ == SparkUpgradeType.RECESSIVE || upgrade_ == SparkUpgradeType.ISOLATED) continue;
                    transfers.add(spark);
                }
                break;
            }
        }
        if (!transfers.isEmpty()) {
            int manaTotal = Math.min(1000 * transfers.size(), tile.getCurrentMana());
            int manaForEach = manaTotal / transfers.size();
            int manaSpent = 0;
            if (manaForEach > transfers.size()) {
                for (ISparkEntity spark : transfers) {
                    if (spark.getAttachedTile() == null || spark.getAttachedTile().isFull() || spark.areIncomingTransfersDone()) {
                        manaTotal -= manaForEach;
                        continue;
                    }
                    ISparkAttachable attached = spark.getAttachedTile();
                    int spend = Math.min(attached.getAvailableSpaceForMana(), manaForEach);
                    attached.recieveMana(spend);
                    manaSpent += spend;
                    this.particlesTowards((Entity)spark);
                }
                tile.recieveMana(-manaSpent);
            }
        }
        if (this.removeTransferants > 0) {
            --this.removeTransferants;
        }
        this.filterTransfers();
    }

    private void particlesTowards(Entity e) {
        PacketHandler.sendToNearby(this.field_70170_p, this, (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.SPARK_MANA_FLOW, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_145782_y(), e.func_145782_y()));
    }

    public static void particleBeam(EntityPlayer player, Entity e1, Entity e2) {
        if (e1 != null && e2 != null && !e1.field_70170_p.field_72995_K) {
            PacketHandler.sendTo((EntityPlayerMP)player, new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.SPARK_NET_INDICATOR, e1.field_70165_t, e1.field_70163_u, e1.field_70161_v, e1.func_145782_y(), e2.func_145782_y()));
        }
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.func_70099_a(new ItemStack(ModItems.spark), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.func_70099_a(new ItemStack(ModItems.sparkUpgrade, 1, upgrade.ordinal() - 1), 0.0f);
        }
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.field_70128_L && !stack.func_190926_b()) {
            if (this.field_70170_p.field_72995_K) {
                boolean valid;
                boolean bl = valid = stack.func_77973_b() == ModItems.twigWand || stack.func_77973_b() == ModItems.sparkUpgrade || stack.func_77973_b() == ModItems.phantomInk;
                if (valid) {
                    player.func_184609_a(hand);
                }
                return valid;
            }
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.func_77973_b() == ModItems.twigWand) {
                if (player.func_70093_af()) {
                    if (upgrade != SparkUpgradeType.NONE) {
                        this.func_70099_a(new ItemStack(ModItems.sparkUpgrade, 1, upgrade.ordinal() - 1), 0.0f);
                        this.setUpgrade(SparkUpgradeType.NONE);
                        this.transfers.clear();
                        this.removeTransferants = 2;
                    } else {
                        this.dropAndKill();
                    }
                    return true;
                }
                for (ISparkEntity spark : SparkHelper.getSparksAround(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v)) {
                    EntitySpark.particleBeam(player, this, (Entity)spark);
                }
                return true;
            }
            if (stack.func_77973_b() == ModItems.sparkUpgrade && upgrade == SparkUpgradeType.NONE) {
                int newUpgrade = stack.func_77952_i() + 1;
                this.setUpgrade(SparkUpgradeType.values()[newUpgrade]);
                stack.func_190918_g(1);
                return true;
            }
            if (stack.func_77973_b() == ModItems.phantomInk) {
                this.func_82142_c(true);
                return true;
            }
        }
        return false;
    }

    protected void func_70037_a(@Nonnull NBTTagCompound cmp) {
        this.setUpgrade(SparkUpgradeType.values()[cmp.func_74762_e(TAG_UPGRADE)]);
        this.func_82142_c(cmp.func_74762_e(TAG_INVIS) == 1);
    }

    protected void func_70014_b(@Nonnull NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_UPGRADE, this.getUpgrade().ordinal());
        cmp.func_74768_a(TAG_INVIS, this.func_82150_aj() ? 1 : 0);
    }

    @Override
    public ISparkAttachable getAttachedTile() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(x, y = MathHelper.func_76128_c((double)this.field_70163_u) - 1, z = MathHelper.func_76128_c((double)this.field_70161_v)));
        if (tile != null && tile instanceof ISparkAttachable) {
            return (ISparkAttachable)tile;
        }
        return null;
    }

    private void filterTransfers() {
        Iterator<ISparkEntity> iter = this.transfers.iterator();
        while (iter.hasNext()) {
            ISparkEntity spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            ISparkAttachable atile = spark.getAttachedTile();
            if (spark != this && !spark.areIncomingTransfersDone() && atile != null && !atile.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(atile instanceof IManaPool))) continue;
            iter.remove();
        }
    }

    @Override
    public Collection<ISparkEntity> getTransfers() {
        this.filterTransfers();
        return this.transfers;
    }

    private boolean hasTransfer(ISparkEntity entity) {
        return this.transfers.contains(entity);
    }

    @Override
    public void registerTransfer(ISparkEntity entity) {
        if (this.hasTransfer(entity)) {
            return;
        }
        this.transfers.add(entity);
    }

    @Override
    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.field_70180_af.func_187225_a(UPGRADE)];
    }

    @Override
    public void setUpgrade(SparkUpgradeType upgrade) {
        this.field_70180_af.func_187227_b(UPGRADE, (Object)upgrade.ordinal());
    }

    @Override
    public boolean areIncomingTransfersDone() {
        ISparkAttachable tile = this.getAttachedTile();
        if (tile instanceof IManaPool) {
            return this.removeTransferants > 0;
        }
        return tile != null && tile.areIncomingTranfersDone();
    }
}

