/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.rod.ItemExchangeRod;

public class ItemAstrolabe
extends ItemMod {
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_META = "blockMeta";
    private static final String TAG_SIZE = "size";

    public ItemAstrolabe() {
        super("astrolabe");
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        if (playerIn.func_70093_af()) {
            if (this.setBlock(stack, block, meta)) {
                this.displayRemainderCounter(playerIn, stack);
                return EnumActionResult.SUCCESS;
            }
        } else {
            boolean did = this.placeAllBlocks(stack, playerIn);
            if (did) {
                this.displayRemainderCounter(playerIn, stack);
                if (!worldIn.field_72995_K) {
                    playerIn.func_184609_a(hand);
                }
            }
            return did ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af()) {
            int size = ItemAstrolabe.getSize(stack);
            int newSize = size == 11 ? 3 : size + 2;
            ItemAstrolabe.setSize(stack, newSize);
            ItemsRemainingRenderHandler.set(stack, newSize + "x" + newSize);
            worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.5f, 1.0f);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public boolean placeAllBlocks(ItemStack stack, EntityPlayer player) {
        BlockPos[] blocksToPlace = ItemAstrolabe.getBlocksToPlace(stack, player);
        if (!ItemAstrolabe.hasBlocks(stack, player, blocksToPlace)) {
            return false;
        }
        int size = ItemAstrolabe.getSize(stack);
        int cost = size * 320;
        if (!ManaItemHandler.requestManaExact(stack, player, cost, false)) {
            return false;
        }
        ItemStack stackToPlace = new ItemStack(ItemAstrolabe.getBlock(stack), 1, ItemAstrolabe.getBlockMeta(stack));
        for (BlockPos coords : blocksToPlace) {
            this.placeBlockAndConsume(player, stack, stackToPlace, coords);
        }
        ManaItemHandler.requestManaExact(stack, player, cost, true);
        return true;
    }

    private void placeBlockAndConsume(EntityPlayer player, ItemStack requestor, ItemStack blockToPlace, BlockPos coords) {
        if (blockToPlace.func_77973_b() == null) {
            return;
        }
        Block block = Block.func_149634_a((Item)blockToPlace.func_77973_b());
        int meta = blockToPlace.func_77952_i();
        IBlockState state = block.func_176203_a(meta);
        player.field_70170_p.func_180501_a(coords, state, 3);
        player.field_70170_p.func_175718_b(2001, coords, Block.func_176210_f((IBlockState)state));
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        ArrayList<ItemStack> stacksToCheck = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_77973_b() == blockToPlace.func_77973_b() && stackInSlot.func_77952_i() == blockToPlace.func_77952_i()) {
                stackInSlot.func_190918_g(1);
                return;
            }
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IBlockProvider)) continue;
            stacksToCheck.add(stackInSlot);
        }
        for (ItemStack providerStack : stacksToCheck) {
            IBlockProvider prov = (IBlockProvider)providerStack.func_77973_b();
            if (!prov.provideBlock(player, requestor, providerStack, block, meta, false)) continue;
            prov.provideBlock(player, requestor, providerStack, block, meta, true);
            return;
        }
    }

    public static boolean hasBlocks(ItemStack stack, EntityPlayer player, BlockPos[] blocks) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        Block block = ItemAstrolabe.getBlock(stack);
        int meta = ItemAstrolabe.getBlockMeta(stack);
        ItemStack reqStack = new ItemStack(block, 1, meta);
        int required = blocks.length;
        int current = 0;
        ArrayList<ItemStack> stacksToCheck = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_77973_b() == reqStack.func_77973_b() && stackInSlot.func_77952_i() == reqStack.func_77952_i() && (current += stackInSlot.func_190916_E()) >= required) {
                return true;
            }
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IBlockProvider)) continue;
            stacksToCheck.add(stackInSlot);
        }
        for (ItemStack providerStack : stacksToCheck) {
            IBlockProvider prov = (IBlockProvider)providerStack.func_77973_b();
            int count = prov.getBlockCount(player, stack, providerStack, block, meta);
            if (count == -1) {
                return true;
            }
            if ((current += count) < required) continue;
            return true;
        }
        return false;
    }

    public static BlockPos[] getBlocksToPlace(ItemStack stack, EntityPlayer player) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        RayTraceResult pos = ToolCommons.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 5.0);
        if (pos != null) {
            BlockPos bpos = pos.func_178782_a();
            IBlockState state = player.field_70170_p.func_180495_p(bpos);
            Block block = state.func_177230_c();
            if (block != null && block.func_176200_f((IBlockAccess)player.field_70170_p, bpos)) {
                bpos = bpos.func_177977_b();
            }
            int rotation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int range = (ItemAstrolabe.getSize(stack) ^ 1) / 2;
            EnumFacing dir = pos.field_178784_b;
            EnumFacing rotationDir = EnumFacing.func_176733_a((double)player.field_70177_z);
            boolean pitchedVertically = player.field_70125_A > 70.0f || player.field_70125_A < -70.0f;
            boolean axisX = rotationDir.func_176740_k() == EnumFacing.Axis.X;
            boolean axisZ = rotationDir.func_176740_k() == EnumFacing.Axis.Z;
            int xOff = axisZ || pitchedVertically ? range : 0;
            int yOff = pitchedVertically ? 0 : range;
            int zOff = axisX || pitchedVertically ? range : 0;
            for (int x = -xOff; x < xOff + 1; ++x) {
                for (int y = 0; y < yOff * 2 + 1; ++y) {
                    for (int z = -zOff; z < zOff + 1; ++z) {
                        int zp;
                        int yp;
                        int xp = bpos.func_177958_n() + x + dir.func_82601_c();
                        BlockPos newPos = new BlockPos(xp, yp = bpos.func_177956_o() + y + dir.func_96559_d(), zp = bpos.func_177952_p() + z + dir.func_82599_e());
                        IBlockState state1 = player.field_70170_p.func_180495_p(newPos);
                        Block block1 = state1.func_177230_c();
                        if (block1 != null && !block1.isAir(state1, (IBlockAccess)player.field_70170_p, newPos) && !block1.func_176200_f((IBlockAccess)player.field_70170_p, newPos)) continue;
                        coords.add(new BlockPos(xp, yp, zp));
                    }
                }
            }
        }
        return coords.toArray(new BlockPos[coords.size()]);
    }

    public void displayRemainderCounter(EntityPlayer player, ItemStack stack) {
        Block block = ItemAstrolabe.getBlock(stack);
        int meta = ItemAstrolabe.getBlockMeta(stack);
        int count = ItemExchangeRod.getInventoryItemCount(player, stack, block, meta);
        if (!player.field_70170_p.field_72995_K) {
            ItemsRemainingRenderHandler.set(new ItemStack(block, 1, meta), count);
        }
    }

    private boolean setBlock(ItemStack stack, Block block, int meta) {
        if (Item.func_150898_a((Block)block) != Items.field_190931_a) {
            ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
            ItemNBTHelper.setInt(stack, TAG_BLOCK_META, meta);
            return true;
        }
        return false;
    }

    private static void setSize(ItemStack stack, int size) {
        ItemNBTHelper.setInt(stack, TAG_SIZE, size | 1);
    }

    public static int getSize(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SIZE, 3) | 1;
    }

    public static Block getBlock(ItemStack stack) {
        Block block = Block.func_149684_b((String)ItemAstrolabe.getBlockName(stack));
        if (block == null) {
            return Blocks.field_150350_a;
        }
        return block;
    }

    public static String getBlockName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
    }

    public static int getBlockMeta(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_META, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List par3List, ITooltipFlag flags) {
        Block block = ItemAstrolabe.getBlock(par1ItemStack);
        int size = ItemAstrolabe.getSize(par1ItemStack);
        par3List.add(size + " x " + size);
        if (block != null && block != Blocks.field_150350_a) {
            par3List.add(new ItemStack(block, 1, ItemAstrolabe.getBlockMeta(par1ItemStack)).func_82833_r());
        }
    }
}

