/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.KnowledgeType;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemDice;

public class ItemLexicon
extends ItemMod
implements ILexicon,
IElvenItem {
    private static final String TAG_KNOWLEDGE_PREFIX = "knowledge.";
    private static final String TAG_FORCED_MESSAGE = "forcedMessage";
    private static final String TAG_QUEUE_TICKS = "queueTicks";
    private boolean skipSound = false;

    public ItemLexicon() {
        super("lexicon");
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        Block block;
        if (player.func_70093_af() && (block = world.func_180495_p(pos).func_177230_c()) != null) {
            if (block instanceof ILexiconable) {
                ItemStack stack = player.func_184586_b(hand);
                LexiconEntry entry = ((ILexiconable)block).getEntry(world, pos, player, stack);
                if (entry != null && this.isKnowledgeUnlocked(stack, entry.getKnowledgeType())) {
                    Botania.proxy.setEntryToOpen(entry);
                    Botania.proxy.setLexiconStack(stack);
                    ItemLexicon.openBook(player, stack, world, false);
                    return EnumActionResult.SUCCESS;
                }
            } else if (world.field_72995_K) {
                RayTraceResult mop = new RayTraceResult(new Vec3d((double)par8, (double)par9, (double)par10), side, pos);
                return Botania.proxy.openWikiPage(world, block, mop) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.PASS;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
            ItemStack creative = new ItemStack((Item)this);
            for (String s : BotaniaAPI.knowledgeTypes.keySet()) {
                KnowledgeType type = BotaniaAPI.knowledgeTypes.get(s);
                this.unlockKnowledge(creative, type);
            }
            list.add((Object)creative);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        if (GuiScreen.func_146272_n()) {
            String edition = TextFormatting.GOLD + I18n.func_135052_a((String)"botaniamisc.edition", (Object[])new Object[]{ItemLexicon.getEdition()});
            if (!edition.isEmpty()) {
                stacks.add(edition);
            }
            ArrayList<KnowledgeType> typesKnown = new ArrayList<KnowledgeType>();
            for (String s : BotaniaAPI.knowledgeTypes.keySet()) {
                KnowledgeType type = BotaniaAPI.knowledgeTypes.get(s);
                if (!this.isKnowledgeUnlocked(par1ItemStack, type)) continue;
                typesKnown.add(type);
            }
            String format = typesKnown.size() == 1 ? "botaniamisc.knowledgeTypesSingular" : "botaniamisc.knowledgeTypesPlural";
            this.addStringToTooltip(I18n.func_135052_a((String)format, (Object[])new Object[]{typesKnown.size()}), stacks);
            for (KnowledgeType type : typesKnown) {
                this.addStringToTooltip(" \u2022 " + I18n.func_135052_a((String)type.getUnlocalizedName(), (Object[])new Object[0]), stacks);
            }
        } else {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), stacks);
        }
    }

    private void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    @SideOnly(value=Side.CLIENT)
    public static String getEdition() {
        String version = "349";
        int build = version.contains("GRADLE") ? 0 : Integer.parseInt(version);
        return build == 0 ? I18n.func_135052_a((String)"botaniamisc.devEdition", (Object[])new Object[0]) : MathHelper.numberToOrdinal(build);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        String force = ItemLexicon.getForcedPage(stack);
        if (force != null && !force.isEmpty()) {
            LexiconEntry entry = ItemLexicon.getEntryFromForce(stack);
            if (entry != null) {
                Botania.proxy.setEntryToOpen(entry);
            } else {
                player.func_145747_a(new TextComponentTranslation("botaniamisc.cantOpen", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            ItemLexicon.setForcedPage(stack, "");
        }
        ItemLexicon.openBook(player, stack, world, this.skipSound);
        this.skipSound = false;
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void openBook(EntityPlayer player, ItemStack stack, World world, boolean skipSound) {
        ILexicon l = (ILexicon)stack.func_77973_b();
        Botania.proxy.setToTutorialIfFirstLaunch();
        if (!l.isKnowledgeUnlocked(stack, BotaniaAPI.relicKnowledge) && l.isKnowledgeUnlocked(stack, BotaniaAPI.elvenKnowledge)) {
            for (ItemStack rstack : ItemDice.relicStacks) {
                Item item = rstack.func_77973_b();
                if (!PlayerHelper.hasItem(player, s -> s != null && s.func_77973_b() == item)) continue;
                l.unlockKnowledge(stack, BotaniaAPI.relicKnowledge);
                break;
            }
        }
        Botania.proxy.setLexiconStack(stack);
        player.openGui((Object)Botania.instance, 0, world, 0, 0, 0);
        if (!world.field_72995_K) {
            if (!skipSound) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.lexiconOpen, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            PlayerHelper.grantCriterion((EntityPlayerMP)player, new ResourceLocation("botania", "main/lexicon_use"), "code_triggered");
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int idk, boolean something) {
        int ticks = ItemLexicon.getQueueTicks(stack);
        if (ticks > 0 && entity instanceof EntityPlayer) {
            boolean bl = this.skipSound = ticks < 5;
            if (ticks == 1) {
                this.func_77659_a(world, (EntityPlayer)entity, EnumHand.MAIN_HAND);
            }
            ItemLexicon.setQueueTicks(stack, ticks - 1);
        }
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.UNCOMMON;
    }

    @Override
    public boolean isKnowledgeUnlocked(ItemStack stack, KnowledgeType knowledge) {
        return knowledge.autoUnlock || ItemNBTHelper.getBoolean(stack, TAG_KNOWLEDGE_PREFIX + knowledge.id, false);
    }

    @Override
    public void unlockKnowledge(ItemStack stack, KnowledgeType knowledge) {
        ItemNBTHelper.setBoolean(stack, TAG_KNOWLEDGE_PREFIX + knowledge.id, true);
    }

    public static void setForcedPage(ItemStack stack, String forced) {
        ItemNBTHelper.setString(stack, TAG_FORCED_MESSAGE, forced);
    }

    public static String getForcedPage(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_FORCED_MESSAGE, "");
    }

    private static LexiconEntry getEntryFromForce(ItemStack stack) {
        String force = ItemLexicon.getForcedPage(stack);
        for (LexiconEntry entry : BotaniaAPI.getAllEntries()) {
            if (!entry.getUnlocalizedName().equals(force) || entry == null || !((ItemLexicon)stack.func_77973_b()).isKnowledgeUnlocked(stack, entry.getKnowledgeType())) continue;
            return entry;
        }
        return null;
    }

    public static int getQueueTicks(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_QUEUE_TICKS, 0);
    }

    public static void setQueueTicks(ItemStack stack, int ticks) {
        ItemNBTHelper.setInt(stack, TAG_QUEUE_TICKS, ticks);
    }

    public static String getTitle(ItemStack stack) {
        String title = ModItems.lexicon.func_77653_i(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            title = stack.func_82833_r();
        }
        String akashicTomeNBT = "akashictome:displayName";
        title = ItemNBTHelper.getString(stack, akashicTomeNBT, title);
        return title;
    }

    @Override
    public boolean isElvenItem(ItemStack stack) {
        return this.isKnowledgeUnlocked(stack, BotaniaAPI.elvenKnowledge);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:lexicon_default", "inventory"), new ModelResourceLocation("botania:lexicon_elven", "inventory")});
        ModelResourceLocation default3dPath = new ModelResourceLocation("botania:lexicon_3d_default", "inventory");
        ModelResourceLocation elven3dPath = new ModelResourceLocation("botania:lexicon_3d_elven", "inventory");
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> this.isElvenItem(stack) ? elven3dPath : default3dPath);
    }
}

