/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lexicon.page;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.lexicon.page.PageRecipe;

public class PageCraftingRecipe
extends PageRecipe {
    private static final ResourceLocation craftingOverlay = new ResourceLocation("botania:textures/gui/craftingOverlay.png");
    final List<ResourceLocation> recipes;
    int ticksElapsed = 0;
    int recipeAt = 0;
    boolean oreDictRecipe;
    boolean shapelessRecipe;

    public PageCraftingRecipe(String unlocalizedName, List<ResourceLocation> recipes) {
        super(unlocalizedName);
        this.recipes = recipes;
        for (ResourceLocation res : recipes) {
            if (res != null) continue;
            throw new IllegalArgumentException("Null recipes arent allowed");
        }
    }

    public PageCraftingRecipe(String unlocalizedName, ResourceLocation recipe) {
        this(unlocalizedName, Collections.singletonList(recipe));
    }

    @Override
    public void onPageAdded(LexiconEntry entry, int index) {
        for (ResourceLocation name : this.recipes) {
            IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(name);
            if (recipe == null || recipe.func_77571_b().func_190926_b()) continue;
            LexiconRecipeMappings.map(recipe.func_77571_b(), entry, index);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        this.shapelessRecipe = false;
        this.oreDictRecipe = false;
        IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(this.recipes.get(this.recipeAt));
        this.renderCraftingRecipe(gui, recipe);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(craftingOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        int iconX = gui.getLeft() + 115;
        int iconY = gui.getTop() + 12;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (this.shapelessRecipe) {
            ((GuiScreen)gui).func_73729_b(iconX, iconY, 240, 0, 16, 16);
            if (mx >= iconX && my >= iconY && mx < iconX + 16 && my < iconY + 16) {
                RenderHelper.renderTooltip(mx, my, Collections.singletonList(I18n.func_135052_a((String)"botaniamisc.shapeless", (Object[])new Object[0])));
            }
            iconY += 20;
        }
        render.func_110577_a(craftingOverlay);
        GlStateManager.func_179147_l();
        if (this.oreDictRecipe) {
            ((GuiScreen)gui).func_73729_b(iconX, iconY, 240, 16, 16, 16);
            if (mx >= iconX && my >= iconY && mx < iconX + 16 && my < iconY + 16) {
                RenderHelper.renderTooltip(mx, my, Collections.singletonList(I18n.func_135052_a((String)"botaniamisc.oredict", (Object[])new Object[0])));
            }
        }
        GlStateManager.func_179084_k();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (GuiScreen.func_146272_n()) {
            return;
        }
        if (this.ticksElapsed % 20 == 0) {
            ++this.recipeAt;
            if (this.recipeAt == this.recipes.size()) {
                this.recipeAt = 0;
            }
        }
        ++this.ticksElapsed;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCraftingRecipe(IGuiLexiconEntry gui, IRecipe recipe) {
        block9: {
            if (recipe == null) {
                return;
            }
            if (recipe instanceof ShapedRecipes || recipe instanceof ShapedOreRecipe) {
                this.oreDictRecipe = recipe instanceof ShapedOreRecipe;
                int width = this.oreDictRecipe ? ((Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"width"})).intValue() : ((ShapedRecipes)recipe).func_192403_f();
                int height = this.oreDictRecipe ? ((Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"height"})).intValue() : ((ShapedRecipes)recipe).func_192404_g();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Ingredient input = (Ingredient)recipe.func_192400_c().get(y * width + x);
                        if (input == Ingredient.field_193370_a) continue;
                        ItemStack[] stacks = input.func_193365_a();
                        this.renderItemAtGridPos(gui, 1 + x, 1 + y, stacks[this.ticksElapsed / 40 % stacks.length], true);
                    }
                }
            } else if (recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe) {
                this.shapelessRecipe = true;
                this.oreDictRecipe = recipe instanceof ShapelessOreRecipe;
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        int index = y * 3 + x;
                        if (index < recipe.func_192400_c().size()) {
                            Ingredient input = (Ingredient)recipe.func_192400_c().get(index);
                            if (input == Ingredient.field_193370_a) continue;
                            ItemStack[] stacks = input.func_193365_a();
                            this.renderItemAtGridPos(gui, 1 + x, 1 + y, stacks[this.ticksElapsed / 40 % stacks.length], true);
                            continue;
                        }
                        break block9;
                    }
                }
            }
        }
        this.renderItemAtGridPos(gui, 2, 0, recipe.func_77571_b(), false);
    }

    @Override
    public List<ItemStack> getDisplayedRecipes() {
        return this.recipes.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.RECIPES).getValue(arg_0)).filter(Objects::nonNull).map(IRecipe::func_77571_b).filter(s -> !s.func_190926_b()).collect(Collectors.toList());
    }
}

