/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.zenscript.GlobalRegistry;
import crafttweaker.zenscript.IBracketHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolPackage;
import stanhebben.zenscript.symbols.SymbolType;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeNative;

public class DumpZsCommand
extends CraftTweakerCommand {
    public DumpZsCommand() {
        super("dumpzs");
    }

    @Override
    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        CraftTweakerAPI.logCommand("\nBracket Handlers:");
        for (IBracketHandler iBracketHandler : GlobalRegistry.getBracketHandlers()) {
            CraftTweakerAPI.logCommand(iBracketHandler.getClass().getName());
        }
        CraftTweakerAPI.logCommand("\nTypes:");
        GlobalRegistry.getTypes().getTypeMap().forEach((aClass, zenType) -> CraftTweakerAPI.logCommand(aClass.getName() + ": " + zenType.getName()));
        CraftTweakerAPI.logCommand("\nGlobals:");
        GlobalRegistry.getGlobals().forEach((s, iZenSymbol) -> CraftTweakerAPI.logCommand(s + ": " + iZenSymbol.toString()));
        CraftTweakerAPI.logCommand("\nExpansions:");
        GlobalRegistry.getExpansions().forEach((s, typeExpansion) -> CraftTweakerAPI.logCommand(s + ": " + typeExpansion.toString()));
        CraftTweakerAPI.logCommand("\nRoot (Symbol Package):");
        GlobalRegistry.getRoot().getPackages().forEach(this::printZenSymbol);
        sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("Dumped content of the GlobalRegistry", sender));
    }

    @Override
    protected void init() {
        this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct dumpzs", "/ct dumpzs", true), SpecialMessagesChat.getNormalMessage(" \u00a73Dumps the whole ZenScript Registry to the crafttweaker log"));
    }

    private void printZenSymbol(String s, IZenSymbol zenSymbol) {
        if (zenSymbol instanceof SymbolPackage) {
            this.printZenSymbolHelper(zenSymbol, 0);
        } else {
            CraftTweakerAPI.logCommand(s + ": " + zenSymbol.toString());
        }
    }

    private void printZenSymbolHelper(IZenSymbol zenSymbol, int depth) {
        int finalDepth = depth + 1;
        if (zenSymbol instanceof SymbolPackage) {
            SymbolPackage symbolPackage = (SymbolPackage)zenSymbol;
            symbolPackage.getPackages().forEach((s1, symbol) -> {
                CraftTweakerAPI.logCommand(StringUtils.repeat((String)"\t", (int)finalDepth) + s1 + ": " + symbol.toString());
                this.printZenSymbolHelper((IZenSymbol)symbol, finalDepth);
            });
        } else if (zenSymbol instanceof SymbolType || zenSymbol instanceof ZenTypeNative) {
            ZenTypeNative typeNative = null;
            if (zenSymbol instanceof SymbolType) {
                ZenType type = ((SymbolType)zenSymbol).getType();
                if (type instanceof ZenTypeNative) {
                    typeNative = (ZenTypeNative)type;
                }
            } else {
                typeNative = (ZenTypeNative)((Object)zenSymbol);
            }
            if (typeNative != null) {
                for (String s : typeNative.dumpTypeInfo()) {
                    CraftTweakerAPI.logCommand(StringUtils.repeat((String)"\t", (int)finalDepth) + s);
                }
            }
        }
    }
}

