/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.event.PlayerCraftedEvent;
import crafttweaker.api.event.PlayerLoggedInEvent;
import crafttweaker.api.event.PlayerLoggedOutEvent;
import crafttweaker.api.event.PlayerSmeltedEvent;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.CraftingInfo;
import crafttweaker.api.recipes.IMTRecipe;
import crafttweaker.api.recipes.ShapedRecipe;
import crafttweaker.api.recipes.ShapelessRecipe;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.brackets.BracketHandlerEntity;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.brackets.BracketHandlerLiquid;
import crafttweaker.mc1120.brackets.BracketHandlerPotion;
import crafttweaker.mc1120.events.ScriptRunEvent;
import crafttweaker.mc1120.furnace.MCFurnaceManager;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.player.MCPlayer;
import crafttweaker.mc1120.recipes.MCCraftingInventory;
import crafttweaker.mc1120.world.MCDimension;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CommonEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerRecipes(RegistryEvent.Register<IRecipe> ev) throws NoSuchFieldException, IllegalAccessException {
        CraftTweakerAPI.logInfo("CraftTweaker: Building registry");
        BracketHandlerItem.rebuildItemRegistry();
        BracketHandlerLiquid.rebuildLiquidRegistry();
        BracketHandlerEntity.rebuildEntityRegistry();
        BracketHandlerPotion.rebuildRegistry();
        CraftTweakerAPI.logInfo("CraftTweaker: Successfully built item registry");
        MinecraftForge.EVENT_BUS.post((Event)new ScriptRunEvent.Pre());
        CrafttweakerImplementationAPI.load();
        MinecraftForge.EVENT_BUS.post((Event)new ScriptRunEvent.Post());
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (!MCFurnaceManager.fuelMap.isEmpty() && !event.getItemStack().func_190926_b()) {
            for (Map.Entry<IItemStack, Integer> entry : MCFurnaceManager.fuelMap.entrySet()) {
                if (!entry.getKey().matches(CraftTweakerMC.getIItemStack(event.getItemStack()))) continue;
                event.setBurnTime(entry.getValue().intValue());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent ev) {
        CrafttweakerImplementationAPI.events.publishPlayerLoggedIn(new PlayerLoggedInEvent(CraftTweakerMC.getIPlayer(ev.player)));
    }

    @SubscribeEvent
    public void onPlayerItemCrafted(PlayerEvent.ItemCraftedEvent ev) {
        IPlayer iPlayer = CraftTweakerMC.getIPlayer(ev.player);
        if (CraftTweaker.INSTANCE.recipes.hasTransformerRecipes()) {
            CraftTweaker.INSTANCE.recipes.applyTransformations(MCCraftingInventory.get(ev.craftMatrix, ev.player), iPlayer);
        }
        if (ev.craftMatrix instanceof InventoryCrafting) {
            CraftingManager.field_193380_a.func_148742_b().stream().filter(key -> CraftingManager.field_193380_a.func_82594_a(key) instanceof IMTRecipe && ((IRecipe)CraftingManager.field_193380_a.func_82594_a(key)).func_77571_b().func_77969_a(ev.crafting)).forEach(i -> {
                ShapelessRecipe r;
                IRecipe recipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a(i);
                IMTRecipe rec = (IMTRecipe)recipe;
                if (rec.getRecipe() instanceof ShapedRecipe) {
                    ShapedRecipe r2 = (ShapedRecipe)rec.getRecipe();
                    if (r2.getAction() != null) {
                        r2.getAction().process(new MCItemStack(ev.crafting), new CraftingInfo(new MCCraftingInventory(ev.craftMatrix, ev.player), new MCDimension(ev.player.field_70170_p)), new MCPlayer(ev.player));
                    }
                } else if (rec.getRecipe() instanceof ShapelessRecipe && (r = (ShapelessRecipe)rec.getRecipe()).getAction() != null) {
                    r.getAction().process(new MCItemStack(ev.crafting), new CraftingInfo(new MCCraftingInventory(ev.craftMatrix, ev.player), new MCDimension(ev.player.field_70170_p)), new MCPlayer(ev.player));
                }
            });
        }
        if (CrafttweakerImplementationAPI.events.hasPlayerCrafted()) {
            CrafttweakerImplementationAPI.events.publishPlayerCrafted(new PlayerCraftedEvent(iPlayer, CraftTweakerMC.getIItemStack(ev.crafting), MCCraftingInventory.get(ev.craftMatrix, ev.player)));
        }
    }

    @SubscribeEvent
    public void onPlayerItemSmelted(PlayerEvent.ItemSmeltedEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerSmelted()) {
            CrafttweakerImplementationAPI.events.publishPlayerSmelted(new PlayerSmeltedEvent(CraftTweakerMC.getIPlayer(ev.player), CraftTweakerMC.getIItemStack(ev.smelting)));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent ev) {
        CrafttweakerImplementationAPI.events.publishPlayerLoggedOut(new PlayerLoggedOutEvent(CraftTweakerMC.getIPlayer(ev.player)));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent ev) {
        if (!ev.getWorld().field_72995_K) {
            crafttweaker.api.event.PlayerInteractEvent event = new crafttweaker.api.event.PlayerInteractEvent(CraftTweakerMC.getIPlayer(ev.getEntityPlayer()), CraftTweakerMC.getDimension(ev.getWorld()), ev.getPos().func_177958_n(), ev.getPos().func_177956_o(), ev.getPos().func_177952_p());
            CrafttweakerImplementationAPI.events.publishPlayerInteract(event);
        }
    }

    @SubscribeEvent
    public void mobDrop(LivingDropsEvent ev) {
        Entity entity = ev.getEntity();
        IEntityDefinition entityDefinition = CraftTweakerAPI.game.getEntity(EntityList.func_75621_b((Entity)ev.getEntity()));
        if (entityDefinition != null) {
            if (entityDefinition.shouldClearDrops()) {
                ev.getDrops().clear();
            } else if (!entityDefinition.getDropsToRemove().isEmpty()) {
                ArrayList removedDrops = new ArrayList();
                entityDefinition.getDropsToRemove().forEach(drop -> ev.getDrops().forEach(drops -> {
                    if (drop.matches(new MCItemStack(drops.func_92059_d()))) {
                        removedDrops.add(drops);
                    }
                }));
                ev.getDrops().removeAll(removedDrops);
            }
            if (!entityDefinition.getDrops().isEmpty()) {
                Random rand = entity.field_70170_p.field_73012_v;
                entityDefinition.getDrops().forEach(drop -> {
                    if (drop.isPlayerOnly() && !(ev.getSource().func_76346_g() instanceof EntityPlayer)) {
                        return;
                    }
                    if (drop.getChance() > 0.0f && drop.getChance() < 1.0f && rand.nextFloat() > drop.getChance()) {
                        return;
                    }
                    EntityItem item = drop.getMin() == 0 && drop.getMax() == 0 ? new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, ((ItemStack)drop.getItemStack().getInternal()).func_77946_l()) : new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, ((ItemStack)drop.getItemStack().withAmount(drop.getRange().getRandom(rand)).getInternal()).func_77946_l());
                    ev.getDrops().add(item);
                });
            }
        }
    }
}

