/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.preprocessors;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.preprocessor.PreprocessorActionBase;
import crafttweaker.runtime.ScriptFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.common.Loader;

public class ModLoadedPreprocessor
extends PreprocessorActionBase {
    public static final String PREPROCESSOR_NAME = "modloaded";
    private List<String> modNames = new ArrayList<String>();

    public ModLoadedPreprocessor(String fileName, String preprocessorLine, int lineIndex) {
        super(fileName, preprocessorLine, lineIndex);
        String[] names;
        String s = preprocessorLine.substring(10);
        for (String name : names = s.split(" ")) {
            String n = name.trim();
            if (n.length() <= 0) continue;
            this.modNames.add(name.trim());
        }
    }

    @Override
    public void executeActionOnFind(ScriptFile scriptFile) {
        if (!this.checkAreLoaded(this.modNames)) {
            CraftTweakerAPI.logInfo("Ignoring script " + scriptFile + " as the following mods weren't loaded " + Arrays.toString(this.modNames.toArray()));
            scriptFile.setParsingBlocked(true);
            scriptFile.setCompileBlocked(true);
            scriptFile.setExecutionBlocked(true);
        }
    }

    @Override
    public String getPreprocessorName() {
        return PREPROCESSOR_NAME;
    }

    private boolean checkAreLoaded(List<String> modNames) {
        for (String modName : modNames) {
            if (Loader.isModLoaded((String)modName)) continue;
            return false;
        }
        return true;
    }
}

