/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.ICraftingInventory;
import crafttweaker.api.recipes.ICraftingRecipe;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import crafttweaker.api.recipes.IRecipeManager;
import crafttweaker.api.recipes.ShapedRecipe;
import crafttweaker.api.recipes.ShapelessRecipe;
import crafttweaker.mc1120.recipes.RecipeConverter;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import stanhebben.zenscript.annotations.Optional;

public final class MCRecipeManager
implements IRecipeManager {
    public static Set<Map.Entry<ResourceLocation, IRecipe>> recipes;
    public static final List<ActionBaseAddRecipe> recipesToAdd;
    public static final List<ActionBaseRemoveRecipes> recipesToRemove;
    private static TIntSet usedHashes;
    private static HashSet<String> usedRecipeNames;
    private static List<ICraftingRecipe> transformerRecipes;

    public MCRecipeManager() {
        transformerRecipes = new ArrayList<ICraftingRecipe>();
    }

    private static boolean matches(Object input, IIngredient ingredient) {
        if (input == null != (ingredient == null)) {
            return false;
        }
        if (ingredient != null) {
            if (input instanceof ItemStack) {
                if (((ItemStack)input).func_190926_b()) {
                    return false;
                }
                if (!ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)input))) {
                    return false;
                }
            } else if (input instanceof String && !ingredient.contains(CraftTweakerMC.getOreDict((String)input))) {
                return false;
            }
        }
        return true;
    }

    public boolean hasTransformerRecipes() {
        return transformerRecipes.size() > 0;
    }

    public void applyTransformations(ICraftingInventory inventory, IPlayer byPlayer) {
        for (ICraftingRecipe recipe : transformerRecipes) {
            if (!recipe.matches(inventory)) continue;
            recipe.applyTransformers(inventory, byPlayer);
            return;
        }
    }

    @Override
    public List<ICraftingRecipe> getRecipesFor(IIngredient ingredient) {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        recipes.stream().filter(recipe -> ingredient.matches(CraftTweakerMC.getIItemStack(((IRecipe)recipe.getValue()).func_77571_b()))).forEach(recipe -> {
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe((IRecipe)recipe.getValue());
            results.add(converted);
        });
        return results;
    }

    @Override
    public List<ICraftingRecipe> getAll() {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe(recipe.getValue());
            results.add(converted);
        }
        return results;
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, false));
    }

    @Override
    public void addShaped(String name, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(name, output, ingredients, function, action, false));
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, true));
    }

    @Override
    public void addShapedMirrored(String name, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(name, output, ingredients, function, action, true));
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        boolean valid = output != null;
        for (IIngredient ing : ingredients) {
            if (ing != null) continue;
            valid = false;
        }
        if (!valid) {
            CraftTweakerAPI.logError("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!");
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(output, ingredients, function, action));
    }

    @Override
    public void addShapeless(String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        boolean valid = output != null;
        for (IIngredient ing : ingredients) {
            if (ing != null) continue;
            valid = false;
        }
        if (!valid) {
            CraftTweakerAPI.logError("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!");
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(name, output, ingredients, function, action));
    }

    @Override
    public void removeAll() {
        recipesToRemove.add(new ActionRemoveAllRecipes());
    }

    @Override
    public void remove(IIngredient output, @Optional boolean nbtMatch) {
        recipesToRemove.add(new ActionRemoveRecipesNoIngredients(output, nbtMatch));
    }

    @Override
    public void removeByRecipeName(String recipeName) {
        recipesToRemove.add(new ActionRemoveRecipeByRecipeName(recipeName));
    }

    @Override
    public void removeByRegex(String regexString) {
        recipesToRemove.add(new ActionRemoveRecipeByRegex(regexString));
    }

    @Override
    public void removeShaped(IIngredient output, IIngredient[][] ingredients) {
        recipesToRemove.add(new ActionRemoveShapedRecipes(output, ingredients));
    }

    @Override
    public void removeShapeless(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
        recipesToRemove.add(new ActionRemoveShapelessRecipes(output, ingredients, wildcard));
    }

    @Override
    public IItemStack craft(IItemStack[][] contents) {
        ContainerVirtual container = new ContainerVirtual();
        int width = 0;
        int height = contents.length;
        for (IItemStack[] row : contents) {
            width = Math.max(width, row.length);
        }
        ItemStack[] iContents = new ItemStack[width * height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < contents[i].length; ++j) {
                if (contents[i][j] == null) continue;
                iContents[i * width + j] = CraftTweakerMC.getItemStack(contents[i][j]);
            }
        }
        InventoryCrafting inventory = new InventoryCrafting((Container)container, width, height);
        for (int i = 0; i < iContents.length; ++i) {
            inventory.func_70299_a(i, iContents[i]);
        }
        ItemStack result = CraftingManager.func_82787_a((InventoryCrafting)inventory, null);
        if (result.func_190926_b()) {
            return null;
        }
        return CraftTweakerMC.getIItemStack(result);
    }

    public static String saveToString(IIngredient ingredient) {
        if (ingredient == null) {
            return "_";
        }
        return ingredient.toString();
    }

    public static String cleanRecipeName(String s) {
        if (s.contains(":")) {
            CraftTweakerAPI.logWarning("Recipe name [" + s + "] may not contain a ':', replacing with '_'!");
        }
        return s.replace(":", "_");
    }

    static {
        recipesToAdd = new ArrayList<ActionBaseAddRecipe>();
        recipesToRemove = new ArrayList<ActionBaseRemoveRecipes>();
        usedHashes = new TIntHashSet();
        usedRecipeNames = new HashSet();
    }

    private static class ContainerVirtual
    extends Container {
        private ContainerVirtual() {
        }

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }

    public static class ActionAddShapelessRecipe
    extends ActionBaseAddRecipe {
        IItemStack output;
        IIngredient[] ingredients;
        IRecipeFunction function;
        IRecipeAction action;

        public ActionAddShapelessRecipe(IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
            this.output = output;
            this.ingredients = ingredients;
            this.function = function;
            this.action = action;
            this.setName(null);
        }

        public ActionAddShapelessRecipe(String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
            this.output = output;
            this.ingredients = ingredients;
            this.function = function;
            this.action = action;
            this.setName(name);
        }

        @Override
        public void apply() {
            ShapelessRecipe recipe = new ShapelessRecipe(this.name, this.output, this.ingredients, this.function, this.action);
            IRecipe irecipe = RecipeConverter.convert(recipe, new ResourceLocation("crafttweaker", this.name));
            super.registerRecipe(irecipe, recipe);
        }

        @Override
        public String calculateName() {
            StringBuilder sb = new StringBuilder();
            sb.append(MCRecipeManager.saveToString(this.output));
            for (IIngredient ingredient : this.ingredients) {
                sb.append(MCRecipeManager.saveToString(ingredient));
            }
            int hash = sb.toString().hashCode();
            while (usedHashes.contains(hash)) {
                ++hash;
            }
            usedHashes.add(hash);
            return "ct_shapeless" + hash;
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Adding shapeless recipe for " + this.output.getDisplayName() + " with name " + this.name;
            }
            return "Trying to add shapeless recipe without correct output";
        }
    }

    public static class ActionAddShapedRecipe
    extends ActionBaseAddRecipe {
        IItemStack output;
        IIngredient[][] ingredients;
        IRecipeFunction function;
        IRecipeAction action;
        boolean mirrored;

        public ActionAddShapedRecipe(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored) {
            this.output = output;
            this.ingredients = ingredients;
            this.function = function;
            this.action = action;
            this.mirrored = mirrored;
            this.setName(null);
        }

        public ActionAddShapedRecipe(String name, IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored) {
            this.output = output;
            this.ingredients = ingredients;
            this.function = function;
            this.action = action;
            this.mirrored = mirrored;
            this.setName(name);
        }

        @Override
        public void apply() {
            ShapedRecipe recipe = new ShapedRecipe(this.name, this.output, this.ingredients, this.function, this.action, this.mirrored);
            IRecipe irecipe = RecipeConverter.convert(recipe, new ResourceLocation("crafttweaker", this.name));
            super.registerRecipe(irecipe, recipe);
        }

        @Override
        protected String calculateName() {
            StringBuilder sb = new StringBuilder();
            sb.append(MCRecipeManager.saveToString(this.output));
            IIngredient[][] iIngredientArray = this.ingredients;
            int n = iIngredientArray.length;
            for (int i = 0; i < n; ++i) {
                IIngredient[] ingredient;
                for (IIngredient iIngredient : ingredient = iIngredientArray[i]) {
                    sb.append(MCRecipeManager.saveToString(iIngredient));
                }
            }
            int hash = sb.toString().hashCode();
            while (usedHashes.contains(hash)) {
                ++hash;
            }
            usedHashes.add(hash);
            return "ct_shaped" + hash;
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Adding shaped recipe for " + this.output.getDisplayName() + " with name " + this.name;
            }
            return "Trying to add shaped recipe without correct output";
        }
    }

    public static abstract class ActionBaseAddRecipe
    implements IAction {
        protected IRecipe recipe;
        protected String name;

        protected void setName(String name) {
            if (name != null) {
                String proposedName = MCRecipeManager.cleanRecipeName(name);
                if (usedRecipeNames.contains(proposedName)) {
                    this.name = this.calculateName();
                    CraftTweakerAPI.logWarning("Recipe name [" + name + "] has duplicate uses, defaulting to calculated hash!");
                } else {
                    this.name = proposedName;
                }
            } else {
                this.name = this.calculateName();
            }
            usedRecipeNames.add(this.name);
        }

        public void registerRecipe(IRecipe recipe, ICraftingRecipe craftingRecipe) {
            recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name));
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
            this.recipe = recipe;
            if (craftingRecipe.hasTransformers()) {
                transformerRecipes.add(craftingRecipe);
            }
        }

        protected abstract String calculateName();

        public IRecipe getRecipe() {
            return this.recipe;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ActionRemoveAllRecipes
    extends ActionBaseRemoveRecipes {
        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            return "Removing all crafting recipes";
        }
    }

    public static class ActionRemoveRecipeByRegex
    extends ActionBaseRemoveRecipes {
        String regexCheck;

        public ActionRemoveRecipeByRegex(String regexCheck) {
            this.regexCheck = regexCheck;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            Pattern p = Pattern.compile(this.regexCheck);
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                ResourceLocation resourceLocation = recipe.getKey();
                Matcher m = p.matcher(resourceLocation.toString());
                if (!m.matches()) continue;
                toRemove.add(resourceLocation);
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.regexCheck != null) {
                return "Removing all recipes matching this regex: \"" + this.regexCheck + "\"";
            }
            return "No regex String for the recipe to remove was given.";
        }
    }

    public static class ActionRemoveRecipeByRecipeName
    extends ActionBaseRemoveRecipes {
        String recipeName;

        public ActionRemoveRecipeByRecipeName(String recipeName) {
            this.recipeName = recipeName;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                if (!recipe.getKey().toString().equals(this.recipeName)) continue;
                toRemove.add(recipe.getKey());
                super.removeRecipes(toRemove);
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.recipeName != null) {
                return "Removing recipe with name \"" + this.recipeName + "\"";
            }
            return "No name for the recipe to remove was given.";
        }
    }

    public static class ActionRemoveRecipesNoIngredients
    extends ActionBaseRemoveRecipes {
        IIngredient output;
        boolean nbtMatch;

        public ActionRemoveRecipesNoIngredients(IIngredient output, @Optional boolean nbtMatch) {
            this.output = output;
            this.nbtMatch = nbtMatch;
        }

        @Override
        public void apply() {
            if (this.output == null) {
                return;
            }
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                if (recipe.getValue().func_77571_b().func_190926_b() || !(this.nbtMatch ? this.output.matchesExact(CraftTweakerMC.getIItemStack(recipe.getValue().func_77571_b())) : this.output.matches(CraftTweakerMC.getIItemStack(recipe.getValue().func_77571_b())))) continue;
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing all recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }
    }

    public static class ActionRemoveShapelessRecipes
    extends ActionBaseRemoveRecipes {
        IIngredient output;
        IIngredient[] ingredients;
        boolean wildcard;

        public ActionRemoveShapelessRecipes(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
            this.output = output;
            this.ingredients = ingredients;
            this.wildcard = wildcard;
        }

        @Override
        public void apply() {
            if (this.output == null) {
                return;
            }
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            block0: for (Map.Entry<ResourceLocation, IRecipe> entry : recipes) {
                IRecipe recipe = entry.getValue();
                if (entry.getValue().func_77571_b().func_190926_b() || !this.output.matches(CraftTweakerMC.getIItemStack(entry.getValue().func_77571_b()))) continue;
                if (this.ingredients != null) {
                    ShapelessRecipes srecipe;
                    if (recipe instanceof ShapelessRecipes) {
                        srecipe = (ShapelessRecipes)recipe;
                        if (this.ingredients.length > srecipe.func_192400_c().size() || !this.wildcard && this.ingredients.length < srecipe.func_192400_c().size()) continue;
                        block1: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.func_192400_c().size(); ++k) {
                                if (MCRecipeManager.matches(srecipe.field_77579_b.get(k), ingredient)) continue block1;
                            }
                            continue block0;
                        }
                    } else if (recipe instanceof ShapelessOreRecipe) {
                        srecipe = (ShapelessOreRecipe)recipe;
                        NonNullList inputs = srecipe.func_192400_c();
                        if (inputs.size() < this.ingredients.length || !this.wildcard && inputs.size() > this.ingredients.length) continue;
                        block3: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.func_192400_c().size(); ++k) {
                                if (MCRecipeManager.matches(inputs.get(k), ingredient)) continue block3;
                            }
                            continue block0;
                        }
                    }
                    if (recipe instanceof ShapedRecipes || recipe instanceof ShapedOreRecipe) {
                        continue;
                    }
                } else if (recipe instanceof ShapedRecipes || recipe instanceof ShapedOreRecipe) continue;
                toRemove.add(entry.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shapeless recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }
    }

    public static class ActionRemoveShapedRecipes
    extends ActionBaseRemoveRecipes {
        IIngredient output;
        IIngredient[][] ingredients;

        public ActionRemoveShapedRecipes(IIngredient output, IIngredient[][] ingredients) {
            this.output = output;
            this.ingredients = ingredients;
        }

        @Override
        public void apply() {
            int ingredientsWidth = 0;
            int ingredientsHeight = 0;
            if (this.ingredients != null) {
                ingredientsHeight = this.ingredients.length;
                for (IIngredient[] ingredient : this.ingredients) {
                    ingredientsWidth = Math.max(ingredientsWidth, ingredient.length);
                }
            }
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            block1: for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                if (recipe.getValue().func_77571_b().func_190926_b() || !this.output.matches(CraftTweakerMC.getIItemStack(recipe.getValue().func_77571_b()))) continue;
                if (this.ingredients != null) {
                    ShapedRecipes srecipe;
                    if (recipe.getValue() instanceof ShapedRecipes) {
                        srecipe = (ShapedRecipes)recipe.getValue();
                        if (ingredientsWidth != srecipe.field_77576_b || ingredientsHeight != srecipe.field_77577_c) continue;
                        for (int j = 0; j < ingredientsHeight; ++j) {
                            IIngredient[] row = this.ingredients[j];
                            for (int k = 0; k < ingredientsWidth; ++k) {
                                IIngredient ingredient = k > row.length ? null : row[k];
                                ItemStack recipeIngredient = ((Ingredient)srecipe.func_192400_c().get(j * srecipe.field_77576_b + k)).func_193365_a()[0];
                                if (!MCRecipeManager.matches(recipeIngredient, ingredient)) continue block1;
                            }
                        }
                    } else if (recipe.getValue() instanceof ShapedOreRecipe) {
                        srecipe = (ShapedOreRecipe)recipe.getValue();
                        int recipeWidth = srecipe.getWidth();
                        int recipeHeight = srecipe.getHeight();
                        if (ingredientsWidth != recipeWidth || ingredientsHeight != recipeHeight) continue;
                        for (int j = 0; j < ingredientsHeight; ++j) {
                            IIngredient[] row = this.ingredients[j];
                            for (int k = 0; k < ingredientsWidth; ++k) {
                                IIngredient ingredient = k > row.length ? null : row[k];
                                ItemStack input = ((Ingredient)srecipe.func_192400_c().get(j * recipeWidth + k)).func_193365_a()[0];
                                if (!MCRecipeManager.matches(input, ingredient)) continue block1;
                            }
                        }
                    } else if (recipe.getValue() instanceof ShapelessRecipes || recipe.getValue() instanceof ShapelessOreRecipe) {
                        continue;
                    }
                } else if (recipe.getValue() instanceof ShapelessRecipes || recipe.getValue() instanceof ShapelessOreRecipe) continue;
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shaped recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }
    }

    public static abstract class ActionBaseRemoveRecipes
    implements IAction {
        public void removeRecipes(List<ResourceLocation> removingRecipes) {
            removingRecipes.forEach(recipe -> RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(recipe));
        }
    }
}

