/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.runtime;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.network.NetworkSide;
import crafttweaker.preprocessor.CrTScriptLoadEvent;
import crafttweaker.preprocessor.PreprocessorManager;
import crafttweaker.runtime.CrTLoadingStartedEvent;
import crafttweaker.runtime.IScriptIterator;
import crafttweaker.runtime.IScriptProvider;
import crafttweaker.runtime.ITweaker;
import crafttweaker.runtime.ScriptFile;
import crafttweaker.util.EventList;
import crafttweaker.util.IEventHandler;
import crafttweaker.zenscript.GlobalRegistry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import stanhebben.zenscript.ZenModule;
import stanhebben.zenscript.ZenParsedFile;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.parser.ParseException;

public class CrTTweaker
implements ITweaker {
    public static String defaultLoaderName = "crafttweaker";
    private NetworkSide networkSide = NetworkSide.INVALID_SIDE;
    private static boolean DEBUG = false;
    private final List<IAction> actions = new ArrayList<IAction>();
    private PreprocessorManager preprocessorManager = new PreprocessorManager();
    private IScriptProvider scriptProvider;
    private final EventList<CrTLoadingStartedEvent> CRT_LOADING_STARTED_EVENT_EVENT_LIST = new EventList();

    public CrTTweaker() {
        PreprocessorManager.registerOwnPreprocessors(this.preprocessorManager);
    }

    @Override
    public void apply(IAction action) {
        CraftTweakerAPI.logInfo(action.describe());
        action.apply();
        this.actions.add(action);
    }

    @Override
    public void setScriptProvider(IScriptProvider provider) {
        this.scriptProvider = provider;
    }

    @Override
    public void load() {
        this.loadScript(false, defaultLoaderName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadScript(boolean isSyntaxCommand, String loaderName) {
        CraftTweakerAPI.logInfo("Loading scripts");
        this.CRT_LOADING_STARTED_EVENT_EVENT_LIST.publish(new CrTLoadingStartedEvent(loaderName, isSyntaxCommand, this.networkSide));
        this.preprocessorManager.clean();
        HashSet<String> executed = new HashSet<String>();
        boolean loadSuccessful = true;
        List<ScriptFile> scriptFiles = this.collectScriptFiles(isSyntaxCommand);
        for (ScriptFile scriptFile : scriptFiles) {
            scriptFile.addAll(this.preprocessorManager.checkFileForPreprocessors(scriptFile));
        }
        scriptFiles.sort(PreprocessorManager.SCRIPT_FILE_COMPARATOR);
        for (ScriptFile scriptFile : scriptFiles) {
            if (!scriptFile.getLoaderName().equals(loaderName) && !isSyntaxCommand) {
                CraftTweakerAPI.logInfo(this.getTweakerDescriptor(loaderName) + ": Skipping file " + scriptFile + " as we are currently loading with a different loader");
                continue;
            }
            if (!scriptFile.shouldBeLoadedOn(this.networkSide)) {
                CraftTweakerAPI.logInfo(this.getTweakerDescriptor(loaderName) + ": Skipping file " + scriptFile + " as we are on the wrong side of the Network");
                continue;
            }
            if (executed.contains(scriptFile.getEffectiveName())) continue;
            executed.add(scriptFile.getEffectiveName());
            CraftTweakerAPI.logInfo(this.getTweakerDescriptor(loaderName) + ": Loading Script: " + scriptFile);
            HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
            IEnvironmentGlobal environmentGlobal = GlobalRegistry.makeGlobalEnvironment(classes);
            ZenParsedFile zenParsedFile = null;
            String filename = scriptFile.getEffectiveName();
            String className = ZenModule.extractClassName(filename);
            Reader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new BufferedInputStream(scriptFile.open()), "UTF-8");
                CrTScriptLoadEvent loadEvent = new CrTScriptLoadEvent(scriptFile);
                this.preprocessorManager.postLoadEvent(loadEvent);
                if (scriptFile.isParsingBlocked()) continue;
                ZenTokener parser = new ZenTokener(reader, environmentGlobal.getEnvironment(), filename, scriptFile.areBracketErrorsIgnored());
                zenParsedFile = new ZenParsedFile(filename, className, parser, environmentGlobal);
            }
            catch (IOException ex) {
                CraftTweakerAPI.logError(this.getTweakerDescriptor(loaderName) + ": Could not load script " + scriptFile + ": " + ex.getMessage());
                loadSuccessful = false;
            }
            catch (ParseException ex) {
                CraftTweakerAPI.logError(this.getTweakerDescriptor(loaderName) + ": Error parsing " + ex.getFile().getFileName() + ":" + ex.getLine() + " -- " + ex.getExplanation());
                loadSuccessful = false;
            }
            catch (Exception ex) {
                CraftTweakerAPI.logError(this.getTweakerDescriptor(loaderName) + ": Error loading " + scriptFile + ": " + ex.toString(), ex);
                loadSuccessful = false;
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException ex) {}
                continue;
            }
            try {
                ZenModule module;
                Runnable runnable;
                if (zenParsedFile == null || scriptFile.isCompileBlocked()) continue;
                ZenModule.compileScripts(className, Collections.singletonList(zenParsedFile), environmentGlobal, scriptFile.isDebugEnabled() || DEBUG);
                if (scriptFile.isExecutionBlocked() || isSyntaxCommand || (runnable = (module = new ZenModule(classes, CraftTweakerAPI.class.getClassLoader())).getMain()) == null) continue;
                runnable.run();
            }
            catch (Throwable ex) {
                CraftTweakerAPI.logError("[" + loaderName + "]: Error executing " + scriptFile + ": " + ex.getMessage(), ex);
            }
        }
        return loadSuccessful;
    }

    protected List<ScriptFile> collectScriptFiles(boolean isSyntaxCommand) {
        ArrayList<ScriptFile> fileList = new ArrayList<ScriptFile>();
        HashSet<String> collected = new HashSet<String>();
        Iterator<IScriptIterator> scripts = this.scriptProvider.getScripts();
        while (scripts.hasNext()) {
            IScriptIterator script = scripts.next();
            if (collected.contains(script.getGroupName())) continue;
            collected.add(script.getGroupName());
            while (script.next()) {
                fileList.add(new ScriptFile(this, script.copyCurrent(), isSyntaxCommand));
            }
        }
        return fileList;
    }

    private String getTweakerDescriptor(String loaderName) {
        return "[" + loaderName + " | " + (Object)((Object)this.networkSide) + "]";
    }

    @Override
    public List<IAction> getActions() {
        return this.actions;
    }

    @Override
    public void enableDebug() {
        DEBUG = true;
    }

    @Override
    public PreprocessorManager getPreprocessorManager() {
        return this.preprocessorManager;
    }

    @Override
    public NetworkSide getNetworkSide() {
        return this.networkSide;
    }

    @Override
    public void setNetworkSide(NetworkSide networkSide) {
        this.networkSide = networkSide;
    }

    @Override
    public void registerLoadStartedEvent(IEventHandler<CrTLoadingStartedEvent> eventHandler) {
        this.CRT_LOADING_STARTED_EVENT_EVENT_LIST.add(eventHandler);
    }
}

