/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class CloseablePriorityList<T>
implements Iterable<T> {
    private CloseableEntry first;

    public Closeable add(T value) {
        if (this.first == null) {
            this.first = new CloseableEntry(value);
        } else {
            CloseableEntry entry = new CloseableEntry(value);
            entry.next = this.first;
            this.first.prev = entry;
            this.first = entry;
        }
        return this.first;
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    private class CloseableEntry
    implements Closeable {
        private final T value;
        private CloseableEntry next;
        private CloseableEntry prev;

        public CloseableEntry(T value) {
            this.value = value;
        }

        @Override
        public void close() throws IOException {
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev == null) {
                CloseablePriorityList.this.first = this.next;
            } else {
                this.prev.next = this.next;
            }
        }
    }

    private class MyIterator
    implements Iterator<T> {
        private CloseableEntry current = null;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current == null || this.current.next != null;
        }

        @Override
        public T next() {
            this.current = this.current == null ? CloseablePriorityList.this.first : this.current.next;
            return this.current.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

