/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.network.grid;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IGrid {
    public static final int TABS_PER_PAGE = 6;
    public static final int SORTING_DIRECTION_ASCENDING = 0;
    public static final int SORTING_DIRECTION_DESCENDING = 1;
    public static final int SORTING_TYPE_QUANTITY = 0;
    public static final int SORTING_TYPE_NAME = 1;
    public static final int SORTING_TYPE_ID = 2;
    public static final int SORTING_TYPE_INVENTORYTWEAKS = 3;
    public static final int SEARCH_BOX_MODE_NORMAL = 0;
    public static final int SEARCH_BOX_MODE_NORMAL_AUTOSELECTED = 1;
    public static final int SEARCH_BOX_MODE_JEI_SYNCHRONIZED = 2;
    public static final int SEARCH_BOX_MODE_JEI_SYNCHRONIZED_AUTOSELECTED = 3;
    public static final int VIEW_TYPE_NORMAL = 0;
    public static final int VIEW_TYPE_NON_CRAFTABLES = 1;
    public static final int VIEW_TYPE_CRAFTABLES = 2;
    public static final int SIZE_STRETCH = 0;
    public static final int SIZE_SMALL = 1;
    public static final int SIZE_MEDIUM = 2;
    public static final int SIZE_LARGE = 3;

    public GridType getType();

    @Nullable
    public INetwork getNetwork();

    @Nullable
    default public IItemGridHandler getItemHandler() {
        return this.getNetwork() != null ? this.getNetwork().getItemGridHandler() : null;
    }

    @Nullable
    default public IFluidGridHandler getFluidHandler() {
        return this.getNetwork() != null ? this.getNetwork().getFluidGridHandler() : null;
    }

    public String getGuiTitle();

    public int getViewType();

    public int getSortingType();

    public int getSortingDirection();

    public int getSearchBoxMode();

    public int getTabSelected();

    public int getTabPage();

    public int getTotalTabPages();

    public int getSize();

    public void onViewTypeChanged(int var1);

    public void onSortingTypeChanged(int var1);

    public void onSortingDirectionChanged(int var1);

    public void onSearchBoxModeChanged(int var1);

    public void onSizeChanged(int var1);

    public void onTabSelectionChanged(int var1);

    public void onTabPageChanged(int var1);

    public List<IFilter> getFilters();

    public List<IGridTab> getTabs();

    public IItemHandlerModifiable getFilter();

    @Nullable
    public InventoryCrafting getCraftingMatrix();

    @Nullable
    public InventoryCraftResult getCraftingResult();

    public void onCraftingMatrixChanged();

    public void onCrafted(EntityPlayer var1);

    public void onCraftedShift(EntityPlayer var1);

    public void onRecipeTransfer(EntityPlayer var1, ItemStack[][] var2);

    public void onClosed(EntityPlayer var1);

    public boolean isActive();

    public static boolean isValidViewType(int type) {
        return type == 0 || type == 2 || type == 1;
    }

    public static boolean isValidSearchBoxMode(int mode) {
        return mode == 0 || mode == 1 || mode == 2 || mode == 3;
    }

    public static boolean isSearchBoxModeWithAutoselection(int mode) {
        return mode == 1 || mode == 3;
    }

    public static boolean isValidSortingType(int type) {
        return type == 0 || type == 1 || type == 2 || type == 3;
    }

    public static boolean isValidSortingDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    public static boolean isValidSize(int size) {
        return size == 0 || size == 1 || size == 2 || size == 3;
    }
}

