/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.storage;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import java.util.Collection;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IStorage<T> {
    public static final Comparator<IStorage> COMPARATOR = (left, right) -> {
        int compare = Integer.compare(right.getPriority(), left.getPriority());
        return compare != 0 ? compare : Integer.compare(right.getStored(), left.getStored());
    };

    public Collection<T> getStacks();

    @Nullable
    public T insert(@Nonnull T var1, int var2, boolean var3);

    @Nullable
    public T extract(@Nonnull T var1, int var2, int var3, boolean var4);

    public int getStored();

    public int getPriority();

    public AccessType getAccessType();

    public int getCacheDelta(int var1, int var2, @Nullable T var3);
}

