/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChain;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementInfo;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementItemRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementText;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementFluidStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementItemStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStepCraft;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStepProcess;
import com.raoulvdberge.refinedstorage.apiimpl.util.StackListItem;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingTask
implements ICraftingTask {
    protected static final int DEFAULT_COMPARE = 19;
    public static final String NBT_STEPS = "Steps";
    public static final String NBT_TO_TAKE_FLUIDS = "ToTakeFluids";
    public static final String NBT_TO_INSERT_ITEMS = "ToInsertItems";
    public static final String NBT_TO_INSERT_FLUIDS = "ToInsertFluids";
    private INetwork network;
    @Nullable
    private ItemStack requested;
    private ICraftingPattern pattern;
    private ICraftingPatternChain chain;
    private int quantity;
    private boolean automated;
    private List<ICraftingStep> mainSteps = new LinkedList<ICraftingStep>();
    private IStackList<ItemStack> toTake = API.instance().createItemStackList();
    private IStackList<ItemStack> toCraft = API.instance().createItemStackList();
    private IStackList<ItemStack> missing = API.instance().createItemStackList();
    private Set<ICraftingPattern> usedPatterns = new HashSet<ICraftingPattern>();
    private boolean recurseFound = false;
    private Deque<ItemStack> toInsertItems = new ArrayDeque<ItemStack>();
    private Deque<FluidStack> toInsertFluids = new ArrayDeque<FluidStack>();
    private IStackList<FluidStack> toTakeFluids = API.instance().createFluidStackList();

    public CraftingTask(INetwork network, @Nullable ItemStack requested, ICraftingPattern pattern, int quantity, boolean automated) {
        this.network = network;
        this.requested = requested;
        this.pattern = pattern;
        this.quantity = quantity;
        this.automated = automated;
    }

    public CraftingTask(INetwork network, @Nullable ItemStack requested, ICraftingPatternChain chain, int quantity, boolean automated) {
        this(network, requested, chain.getPrototype(), quantity, automated);
        this.chain = chain;
    }

    public CraftingTask(INetwork network, @Nullable ItemStack requested, ICraftingPattern pattern, int quantity, List<ICraftingStep> mainSteps, Deque<ItemStack> toInsertItems, IStackList<FluidStack> toTakeFluids, Deque<FluidStack> toInsertFluids, boolean automated) {
        this(network, requested, pattern, quantity, automated);
        this.mainSteps = mainSteps;
        this.toInsertItems = toInsertItems;
        this.toTakeFluids = toTakeFluids;
        this.toInsertFluids = toInsertFluids;
    }

    @Override
    public void calculate() {
        ICraftingPattern currentPattern;
        IStackList<ItemStack> networkList = this.network.getItemStorageCache().getList().copy();
        networkList.clean();
        networkList = networkList.getOredicted();
        IStackList<FluidStack> networkFluidList = this.network.getFluidStorageCache().getList().copy();
        IStackList<ItemStack> toInsert = API.instance().createItemStackList();
        ItemStack requested = this.requested != null ? this.requested : this.pattern.getOutputs().get(0);
        this.toCraft.add(ItemHandlerHelper.copyStackWithSize((ItemStack)requested, (int)this.quantity));
        for (int quantity = this.quantity; quantity > 0 && !this.recurseFound; quantity -= currentPattern.getQuantityPerRequest(requested)) {
            currentPattern = this.chain == null ? this.pattern : this.chain.cycle();
            this.mainSteps.add(this.calculate(networkList, networkFluidList, currentPattern, toInsert));
        }
        this.usedPatterns.clear();
    }

    private ICraftingStep calculate(IStackList<ItemStack> networkList, IStackList<FluidStack> networkFluidList, ICraftingPattern pattern, IStackList<ItemStack> toInsert) {
        List<ItemStack> outputs;
        this.recurseFound |= !this.usedPatterns.add(pattern);
        if (this.recurseFound) {
            return null;
        }
        int compare = 19;
        IStackList<ItemStack> actualInputs = API.instance().createItemStackList();
        LinkedList<ItemStack> usedStacks = new LinkedList<ItemStack>();
        LinkedList<ICraftingStep> previousSteps = new LinkedList<ICraftingStep>();
        IStackList<ItemStack> byproductList = API.instance().createItemStackList();
        pattern.getByproducts().stream().filter(Objects::nonNull).forEach(byproductList::add);
        for (List<ItemStack> inputs : pattern.getOreInputs()) {
            ItemStack input;
            ItemStack networkStack;
            ItemStack extraStack;
            if (inputs == null || inputs.isEmpty()) {
                usedStacks.add(null);
                continue;
            }
            int i = 0;
            do {
                compare = (input = inputs.get(i).func_77946_l()).func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
                extraStack = toInsert.get(input, compare);
                networkStack = networkList.get(input, compare);
            } while (extraStack == null && networkStack == null && ++i < inputs.size() && !this.network.getCraftingManager().hasPattern(input, compare));
            if (i == inputs.size()) {
                input = inputs.get(0).func_77946_l();
            }
            usedStacks.add(input.func_77946_l());
            compare = input.func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
            int lambdaCompare = compare;
            ItemStack lambdaInput = input;
            ICraftingPattern inputPattern = null;
            int available = (extraStack == null ? 0 : extraStack.func_190916_E()) + (networkStack == null ? 0 : networkStack.func_190916_E());
            if (available < input.func_190916_E() && (inputPattern = this.network.getCraftingManager().getPattern(input, compare, networkList)) != null && inputPattern.getInputs().stream().anyMatch(s -> API.instance().getComparer().isEqual((ItemStack)s, lambdaInput, lambdaCompare))) {
                int craftQuantity = inputPattern.getQuantityPerRequest(input, compare);
                long needed = (long)((networkStack == null ? 0 : -networkStack.func_190916_E()) + input.func_190916_E()) + inputPattern.getInputs().stream().filter(s -> API.instance().getComparer().isEqual((ItemStack)s, lambdaInput, lambdaCompare)).count() * 2L;
                do {
                    previousSteps.add(this.calculate(networkList, networkFluidList, inputPattern, toInsert));
                    this.toCraft.add(ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)craftQuantity));
                } while ((extraStack = toInsert.get(input, compare)) != null && (long)extraStack.func_190916_E() < needed);
            }
            while (input.func_190916_E() > 0) {
                int takeQuantity;
                if (extraStack != null && extraStack.func_190916_E() > 0) {
                    takeQuantity = Math.min(extraStack.func_190916_E(), input.func_190916_E());
                    ItemStack inputStack = ItemHandlerHelper.copyStackWithSize((ItemStack)extraStack, (int)takeQuantity);
                    actualInputs.add(inputStack.func_77946_l());
                    input.func_190918_g(takeQuantity);
                    if (byproductList.get(inputStack, compare) == null) {
                        this.toCraft.add(inputStack);
                    }
                    toInsert.remove(inputStack);
                    if (input.func_190916_E() <= 0) continue;
                    i = 0;
                    while (((extraStack = toInsert.get(inputs.get(i), compare)) == null || extraStack.func_190916_E() == 0) && ++i < inputs.size()) {
                    }
                    continue;
                }
                if (networkStack != null && networkStack.func_190916_E() > 0) {
                    takeQuantity = Math.min(networkStack.func_190916_E(), input.func_190916_E());
                    ItemStack inputStack = ItemHandlerHelper.copyStackWithSize((ItemStack)networkStack, (int)takeQuantity);
                    this.toTake.add(inputStack.func_77946_l());
                    actualInputs.add(inputStack.func_77946_l());
                    input.func_190918_g(takeQuantity);
                    networkList.remove(inputStack);
                    if (input.func_190916_E() <= 0) continue;
                    i = 0;
                    do {
                        networkStack = networkList.get(inputs.get(i), compare);
                    } while ((extraStack == null || extraStack.func_190916_E() == 0) && ++i < inputs.size());
                    continue;
                }
                int oreDictedCompare = compare | (pattern.isOredict() ? 8 : 0);
                if (inputPattern == null) {
                    inputPattern = this.network.getCraftingManager().getPattern(input, oreDictedCompare, networkList);
                }
                if (inputPattern != null) {
                    ItemStack actualCraft = inputPattern.getActualOutput(input, oreDictedCompare);
                    int craftQuantity = Math.min(inputPattern.getQuantityPerRequest(input, oreDictedCompare), input.func_190916_E());
                    ItemStack inputCrafted = ItemHandlerHelper.copyStackWithSize((ItemStack)actualCraft, (int)craftQuantity);
                    this.toCraft.add(inputCrafted.func_77946_l());
                    actualInputs.add(inputCrafted.func_77946_l());
                    previousSteps.add(this.calculate(networkList, networkFluidList, inputPattern, toInsert));
                    input.func_190918_g(craftQuantity);
                    if (this.recurseFound) continue;
                    ItemStack inserted = toInsert.get(inputCrafted, compare);
                    toInsert.remove(inserted, craftQuantity);
                    continue;
                }
                ItemStack fluidCheck = ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)1);
                while (input.func_190916_E() > 0 && this.doFluidCalculation(networkList, networkFluidList, fluidCheck, toInsert, previousSteps)) {
                    actualInputs.add(fluidCheck);
                    input.func_190918_g(1);
                }
                if (input.func_190916_E() <= 0) continue;
                ItemStack copy = input.func_77946_l();
                if (copy.func_77952_i() == Short.MAX_VALUE) {
                    copy.func_77964_b(0);
                }
                this.missing.add(copy);
                input.func_190920_e(0);
            }
        }
        ItemStack[] took = null;
        if (this.missing.isEmpty() && !pattern.isProcessing()) {
            took = StackListItem.toCraftingGrid(actualInputs, usedStacks, compare | (pattern.isOredict() ? 8 : 0));
        }
        List<ItemStack> list = outputs = !pattern.isProcessing() && pattern.isOredict() && this.missing.isEmpty() ? pattern.getOutputs(took) : pattern.getOutputs();
        if (outputs == null) {
            outputs = pattern.getOutputs();
        }
        for (ItemStack output : outputs) {
            if (output == null || output.func_190926_b()) continue;
            toInsert.add(output.func_77946_l());
        }
        for (ItemStack byproduct : !pattern.isProcessing() && pattern.isOredict() && this.missing.isEmpty() ? pattern.getByproducts(took) : pattern.getByproducts()) {
            if (byproduct == null || byproduct.func_190926_b()) continue;
            toInsert.add(byproduct.func_77946_l());
        }
        this.usedPatterns.remove(pattern);
        return pattern.isProcessing() ? new CraftingStepProcess(this.network, pattern, previousSteps) : new CraftingStepCraft(this.network, pattern, usedStacks, previousSteps);
    }

    private boolean doFluidCalculation(IStackList<ItemStack> networkList, IStackList<FluidStack> networkFluidList, ItemStack input, IStackList<ItemStack> toInsert, List<ICraftingStep> previousSteps) {
        if (API.instance().getComparer().isEqual(input, StackUtils.WATER_BOTTLE)) {
            FluidStack fluidInStorage = networkFluidList.get(new FluidStack(FluidRegistry.WATER, 1000));
            if (fluidInStorage == null || fluidInStorage.amount < 1000) {
                this.missing.add(input);
            } else {
                ItemStack emptyBottle = toInsert.get(StackUtils.EMPTY_BOTTLE);
                boolean hasBottle = false;
                if (emptyBottle != null && emptyBottle.func_190916_E() > 0) {
                    hasBottle = toInsert.remove(StackUtils.EMPTY_BOTTLE, 1);
                }
                if (!hasBottle && (emptyBottle = networkList.get(StackUtils.EMPTY_BOTTLE)) != null && emptyBottle.func_190916_E() > 0) {
                    hasBottle = networkList.remove(StackUtils.EMPTY_BOTTLE);
                }
                ICraftingPattern emptyBottlePattern = this.network.getCraftingManager().getPattern(StackUtils.EMPTY_BOTTLE);
                if (!hasBottle) {
                    if (emptyBottlePattern == null) {
                        this.missing.add(StackUtils.EMPTY_BOTTLE.func_77946_l());
                    } else {
                        this.toCraft.add(StackUtils.EMPTY_BOTTLE.func_77946_l());
                        previousSteps.add(this.calculate(networkList, networkFluidList, emptyBottlePattern, toInsert));
                        toInsert.remove(StackUtils.EMPTY_BOTTLE, 1);
                    }
                }
                if (hasBottle || emptyBottlePattern != null) {
                    this.toTake.add(StackUtils.EMPTY_BOTTLE.func_77946_l());
                    networkList.remove(StackUtils.EMPTY_BOTTLE);
                }
            }
            return true;
        }
        FluidStack fluidInItem = (FluidStack)StackUtils.getFluid(input, true).getValue();
        if (fluidInItem != null && StackUtils.hasFluidBucket(fluidInItem)) {
            FluidStack fluidInStorage = networkFluidList.get(fluidInItem);
            if (fluidInStorage == null || fluidInStorage.amount < fluidInItem.amount) {
                this.missing.add(input);
            } else {
                ItemStack bucket = toInsert.get(StackUtils.EMPTY_BUCKET);
                boolean hasBucket = false;
                if (bucket != null && bucket.func_190916_E() > 0) {
                    hasBucket = toInsert.remove(StackUtils.EMPTY_BUCKET, 1);
                }
                if (!hasBucket && (bucket = networkList.get(StackUtils.EMPTY_BUCKET)) != null && bucket.func_190916_E() > 0) {
                    hasBucket = networkList.remove(StackUtils.EMPTY_BUCKET, 1);
                }
                ICraftingPattern bucketPattern = this.network.getCraftingManager().getPattern(StackUtils.EMPTY_BUCKET);
                if (!hasBucket) {
                    if (bucketPattern == null) {
                        this.missing.add(StackUtils.EMPTY_BUCKET.func_77946_l());
                    } else {
                        this.toCraft.add(StackUtils.EMPTY_BUCKET.func_77946_l());
                        previousSteps.add(this.calculate(networkList, networkFluidList, bucketPattern, toInsert));
                        toInsert.remove(StackUtils.EMPTY_BUCKET, 1);
                    }
                }
                if (hasBucket || bucketPattern != null) {
                    this.toTakeFluids.add(fluidInItem.copy());
                    networkFluidList.remove(fluidInItem);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onCancelled() {
        for (ItemStack stack : this.toInsertItems) {
            this.network.insertItemTracked(stack, stack.func_190916_E());
        }
        for (ICraftingStep step : this.getSteps()) {
            if (!step.getPattern().isBlocking()) continue;
            step.getPattern().getContainer().setBlocked(false);
        }
        this.network.markCraftingMonitorForUpdate();
    }

    public String toString() {
        return "\nCraftingTask{quantity=" + this.quantity + "\n, automated=" + this.automated + "\n, toTake=" + this.toTake + "\n, toTakeFluids=" + this.toTakeFluids + "\n, toCraft=" + this.toCraft + "\n, toInsertItems=" + this.toInsertItems + "\n, toInsertFluids=" + this.toInsertFluids + "\n, mainSteps=" + this.mainSteps + '}';
    }

    @Override
    public boolean update(Map<ICraftingPatternContainer, Integer> usedContainers) {
        Object step;
        IStackList<ItemStack> oreDictPrepped = this.network.getItemStorageCache().getList().getOredicted();
        IStackList<FluidStack> networkFluids = this.network.getFluidStorageCache().getList();
        if (!this.missing.isEmpty()) {
            for (ItemStack missing : this.missing.getStacks()) {
                if (oreDictPrepped.trackedRemove(missing)) continue;
                oreDictPrepped.undo();
                return false;
            }
            oreDictPrepped.undo();
            this.reschedule();
            return false;
        }
        int times = this.toInsertItems.size();
        for (int i = 0; i < times; ++i) {
            ItemStack remainder;
            ItemStack insert = this.toInsertItems.poll();
            if (insert == null || (remainder = this.network.insertItemTracked(insert, insert.func_190916_E())) == null) continue;
            this.toInsertItems.add(remainder);
        }
        LinkedList<Object> leafSteps = new LinkedList<Object>();
        LinkedList<ICraftingStep> steps = new LinkedList<ICraftingStep>();
        steps.addAll(this.mainSteps);
        while (steps.size() > 0) {
            step = (ICraftingStep)steps.poll();
            if (step.getPreliminarySteps().size() > 0) {
                steps.addAll(step.getPreliminarySteps());
                continue;
            }
            leafSteps.add(step);
        }
        for (ICraftingStep iCraftingStep : leafSteps) {
            if (iCraftingStep.hasStartedProcessing()) continue;
            ICraftingPatternContainer container = iCraftingStep.getPattern().getContainer();
            Integer timesUsed = usedContainers.get(container);
            if (timesUsed == null) {
                timesUsed = 0;
            }
            Integer n = timesUsed;
            Integer n2 = timesUsed = Integer.valueOf(timesUsed + 1);
            if (n > container.getSpeedUpdateCount() || iCraftingStep.getPattern().isProcessing() && container.isBlocked() || !iCraftingStep.canStartProcessing(oreDictPrepped, networkFluids)) continue;
            iCraftingStep.setStartedProcessing();
            iCraftingStep.execute(this.toInsertItems, this.toInsertFluids);
            usedContainers.put(container, timesUsed);
            this.network.markCraftingMonitorForUpdate();
        }
        if (this.getSteps().stream().filter(ICraftingStep::hasStartedProcessing).count() == 0L) {
            this.reschedule();
        }
        steps.clear();
        this.mainSteps.removeIf(ICraftingStep::hasReceivedOutputs);
        steps.addAll(this.mainSteps);
        while (steps.size() > 0) {
            step = (ICraftingStep)steps.poll();
            step.getPreliminarySteps().removeIf(ICraftingStep::hasReceivedOutputs);
            steps.addAll(step.getPreliminarySteps());
        }
        return this.isFinished();
    }

    @Override
    public void reschedule() {
        List mainSteps = this.mainSteps.stream().filter(s -> s.getPattern().alike(this.pattern)).collect(Collectors.toList());
        this.missing.clear();
        this.mainSteps.clear();
        if (!mainSteps.isEmpty()) {
            this.quantity = 0;
            int quantityPerRequest = this.pattern.getQuantityPerRequest(this.requested);
            for (ICraftingStep step : mainSteps) {
                this.quantity += quantityPerRequest - step.getReceivedOutput(this.requested);
            }
            if (this.quantity > 0) {
                this.calculate();
            }
            this.network.markCraftingMonitorForUpdate();
        }
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    @Nullable
    public ItemStack getRequested() {
        return this.requested;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        this.writeDefaultsToNBT(tag);
        NBTTagList stepsList = new NBTTagList();
        for (ICraftingStep iCraftingStep : this.mainSteps) {
            stepsList.func_74742_a((NBTBase)iCraftingStep.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_STEPS, (NBTBase)stepsList);
        NBTTagList toInsertItemsList = new NBTTagList();
        for (ItemStack insert : this.toInsertItems) {
            toInsertItemsList.func_74742_a((NBTBase)insert.serializeNBT());
        }
        tag.func_74782_a(NBT_TO_INSERT_ITEMS, (NBTBase)toInsertItemsList);
        tag.func_74782_a(NBT_TO_TAKE_FLUIDS, (NBTBase)StackUtils.serializeFluidStackList(this.toTakeFluids));
        NBTTagList nBTTagList = new NBTTagList();
        for (FluidStack insert : this.toInsertFluids) {
            nBTTagList.func_74742_a((NBTBase)insert.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_TO_INSERT_FLUIDS, (NBTBase)nBTTagList);
        return tag;
    }

    @Override
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        ICraftingMonitorElementList elements = API.instance().createCraftingMonitorElementList();
        elements.directAdd(new CraftingMonitorElementItemRender(this.network.getCraftingManager().getTasks().indexOf(this), this.requested != null ? this.requested : this.pattern.getOutputs().get(0), this.quantity, 0));
        if (!this.missing.isEmpty()) {
            elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_missing", 16));
            this.missing.getStacks().stream().map(stack -> new CraftingMonitorElementError(new CraftingMonitorElementItemRender(-1, (ItemStack)stack, stack.func_190916_E(), 32), "")).forEach(elements::add);
            elements.commit();
        }
        if (!this.toInsertItems.isEmpty()) {
            elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_inserting", 16));
            this.toInsertItems.stream().map(stack -> new CraftingMonitorElementItemRender(-1, (ItemStack)stack, stack.func_190916_E(), 32)).forEach(elements::add);
            elements.commit();
        }
        if (!this.isFinished()) {
            if (this.getSteps().stream().filter(s -> !s.getPattern().isProcessing()).count() > 0L) {
                elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_crafting", 16));
                IStackList<ItemStack> oreDictPrepped = this.network.getItemStorageCache().getList().getOredicted();
                IStackList<FluidStack> networkFluids = this.network.getFluidStorageCache().getList();
                for (ICraftingStep step : this.getSteps().stream().filter(s -> !s.getPattern().isProcessing()).collect(Collectors.toList())) {
                    for (int i = 0; i < step.getPattern().getOutputs().size(); ++i) {
                        ICraftingMonitorElement element = new CraftingMonitorElementItemRender(-1, step.getPattern().getOutputs().get(i), step.getPattern().getOutputs().get(i).func_190916_E(), 32);
                        if (!step.hasStartedProcessing() && !step.canStartProcessing(oreDictPrepped, networkFluids)) {
                            element = new CraftingMonitorElementInfo(element, "gui.refinedstorage:crafting_monitor.waiting_for_items");
                        }
                        elements.add(element);
                    }
                }
                elements.commit();
            }
            if (this.getSteps().stream().filter(s -> s.getPattern().isProcessing()).count() > 0L) {
                elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_processing", 16));
                for (ICraftingStep step : this.getSteps().stream().filter(s -> s.getPattern().isProcessing()).collect(Collectors.toList())) {
                    for (int i = 0; i < step.getPattern().getOutputs().size(); ++i) {
                        ICraftingMonitorElement element = new CraftingMonitorElementItemRender(-1, step.getPattern().getOutputs().get(i), step.getPattern().getOutputs().get(i).func_190916_E(), 32);
                        if (step.getPattern().getContainer().getFacingTile() == null) {
                            element = new CraftingMonitorElementError(element, "gui.refinedstorage:crafting_monitor.machine_none");
                        } else if (!step.hasStartedProcessing() && !step.canStartProcessing()) {
                            element = new CraftingMonitorElementError(element, "gui.refinedstorage:crafting_monitor.machine_in_use");
                        } else if (!step.hasStartedProcessing() && step.getPattern().getContainer().isBlocked()) {
                            element = new CraftingMonitorElementError(element, "gui.refinedstorage:crafting_monitor.blocked");
                        }
                        elements.add(element);
                    }
                }
                elements.commit();
            }
        }
        return elements.getElements();
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public List<ICraftingStep> getSteps() {
        LinkedList<ICraftingStep> allSteps = new LinkedList<ICraftingStep>();
        LinkedList<ICraftingStep> steps = new LinkedList<ICraftingStep>();
        steps.addAll(this.mainSteps);
        while (steps.size() > 0) {
            ICraftingStep step = (ICraftingStep)steps.poll();
            allSteps.add(step);
            steps.addAll(step.getPreliminarySteps());
        }
        return allSteps;
    }

    @Override
    public boolean isValid() {
        return !this.recurseFound;
    }

    @Override
    public IStackList<ItemStack> getMissing() {
        return this.missing;
    }

    @Override
    public List<ICraftingPreviewElement> getPreviewStacks() {
        CraftingPreviewElementItemStack previewStack;
        int hash;
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        LinkedHashMap<Integer, CraftingPreviewElementItemStack> map = new LinkedHashMap<Integer, CraftingPreviewElementItemStack>();
        for (ItemStack stack : this.toCraft.getStacks()) {
            hash = API.instance().getItemStackHashCode(stack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(stack);
            }
            previewStack.addToCraft(stack.func_190916_E());
            map.put(hash, previewStack);
        }
        for (ItemStack stack : this.missing.getStacks()) {
            hash = API.instance().getItemStackHashCode(stack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(stack);
            }
            previewStack.setMissing(true);
            previewStack.addToCraft(stack.func_190916_E());
            map.put(hash, previewStack);
        }
        for (ItemStack stack : this.toTake.getStacks()) {
            hash = API.instance().getItemStackHashCode(stack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(stack);
            }
            previewStack.addAvailable(stack.func_190916_E());
            map.put(hash, previewStack);
        }
        ArrayList<ICraftingPreviewElement> elements = new ArrayList<ICraftingPreviewElement>(map.values());
        this.toTakeFluids.getStacks().stream().map(CraftingPreviewElementFluidStack::new).forEach(elements::add);
        return elements;
    }

    @Override
    public boolean isAutomated() {
        return this.automated;
    }

    @Override
    public boolean isFinished() {
        return this.mainSteps.stream().allMatch(ICraftingStep::hasReceivedOutputs);
    }
}

