/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.NetworkItemAction;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTask;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingPreviewResponse;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingStartResponse;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandler
implements IItemGridHandler {
    private INetwork network;

    public ItemGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(EntityPlayerMP player, int hash, int flags) {
        ItemStack took;
        ItemStack item = this.network.getItemStorageCache().getList().get(hash);
        if (item == null || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (EntityPlayer)player)) {
            return;
        }
        int itemSize = item.func_190916_E();
        int maxItemSize = item.func_77973_b().getItemStackLimit(item.func_77946_l());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? !held.func_190926_b() && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.func_190916_E() + 1 > held.func_77976_d()) : !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        if ((took = this.network.extractItem(item, size = Math.min(size, maxItemSize), true)) != null) {
            if ((flags & 4) == 4) {
                IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                if (ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)true).func_190926_b()) {
                    took = this.network.extractItem(item, size, false);
                    ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)false);
                }
            } else {
                took = this.network.extractItem(item, size, false);
                if (single && !held.func_190926_b()) {
                    held.func_190917_f(1);
                } else {
                    player.field_71071_by.func_70437_b(took);
                }
                player.func_71113_k();
            }
            INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
            if (networkItem != null) {
                networkItem.onAction(NetworkItemAction.ITEM_EXTRACTED);
            }
        }
    }

    @Override
    public ItemStack onInsert(EntityPlayerMP player, ItemStack stack) {
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (EntityPlayer)player)) {
            return stack;
        }
        ItemStack remainder = this.network.insertItem(stack, stack.func_190916_E(), false);
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null) {
            networkItem.onAction(NetworkItemAction.ITEM_INSERTED);
        }
        return remainder;
    }

    @Override
    public void onInsertHeldItem(EntityPlayerMP player, boolean single) {
        int size;
        if (player.field_71071_by.func_70445_o().func_190926_b() || !this.network.getSecurityManager().hasPermission(Permission.INSERT, (EntityPlayer)player)) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int n = size = single ? 1 : stack.func_190916_E();
        if (single) {
            if (this.network.insertItem(stack, size, true) == null) {
                this.network.insertItem(stack, size, false);
                stack.func_190918_g(size);
                if (stack.func_190916_E() == 0) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            }
        } else {
            player.field_71071_by.func_70437_b(StackUtils.nullToEmpty(this.network.insertItem(stack, size, false)));
        }
        player.func_71113_k();
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null) {
            networkItem.onAction(NetworkItemAction.ITEM_INSERTED);
        }
    }

    @Override
    public ItemStack onShiftClick(EntityPlayerMP player, ItemStack stack) {
        return StackUtils.nullToEmpty(this.onInsert(player, stack));
    }

    @Override
    public void onCraftingPreviewRequested(EntityPlayerMP player, int hash, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        IStackList<ItemStack> cache = API.instance().createItemStackList();
        for (ICraftingPattern pattern : this.network.getCraftingManager().getPatterns()) {
            for (ItemStack output : pattern.getOutputs()) {
                if (output == null) continue;
                cache.add(output);
            }
        }
        ItemStack stack = cache.get(hash);
        if (stack != null) {
            Thread calculationThread = new Thread(() -> {
                CraftingTask task = new CraftingTask(this.network, stack, this.network.getCraftingManager().getPatternChain(stack), quantity, false);
                task.calculate();
                if (noPreview && task.getMissing().isEmpty()) {
                    this.network.getCraftingManager().add(task);
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingStartResponse(), player);
                } else {
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingPreviewResponse(task.getPreviewStacks(), hash, quantity), player);
                }
            }, "RS crafting preview calculation");
            calculationThread.start();
        }
    }

    @Override
    public void onCraftingRequested(EntityPlayerMP player, int hash, int quantity) {
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        ItemStack stack = null;
        for (ICraftingPattern pattern : this.network.getCraftingManager().getPatterns()) {
            for (ItemStack output : pattern.getOutputs()) {
                if (output == null || API.instance().getItemStackHashCode(output) != hash) continue;
                stack = output;
                break;
            }
            if (stack == null) continue;
            break;
        }
        if (stack != null) {
            CraftingTask task = new CraftingTask(this.network, stack, this.network.getCraftingManager().getPatternChain(stack), quantity, false);
            task.calculate();
            task.getMissing().clear();
            this.network.getCraftingManager().add(task);
        }
    }

    @Override
    public void onCraftingCancelRequested(EntityPlayerMP player, int id) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        ICraftingManager manager = this.network.getCraftingManager();
        if (id >= 0 && id < manager.getTasks().size()) {
            manager.cancel(manager.getTasks().get(id));
        } else if (id == -1) {
            for (ICraftingTask task : manager.getTasks()) {
                manager.cancel(task);
            }
        }
        INetworkItem networkItem = this.network.getNetworkItemHandler().getItem((EntityPlayer)player);
        if (networkItem != null) {
            networkItem.onAction(id == -1 ? NetworkItemAction.CRAFTING_TASK_ALL_CANCELLED : NetworkItemAction.CRAFTING_TASK_CANCELLED);
        }
    }
}

