/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDetector;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeDetector
extends NetworkNode
implements IComparable,
IType {
    public static final String ID = "detector";
    private static final int SPEED = 5;
    public static final int MODE_UNDER = 0;
    public static final int MODE_EQUAL = 1;
    public static final int MODE_ABOVE = 2;
    public static final int MODE_AUTOCRAFTING = 3;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_AMOUNT = "Amount";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBase itemFilters = new ItemHandlerBase(1, new ItemHandlerListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(1, new ItemHandlerListenerNetworkNode(this));
    private int compare = 3;
    private int type = 0;
    private int mode = 1;
    private int amount = 0;
    private boolean powered = false;
    private boolean wasPowered;

    public NetworkNodeDetector(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.detectorUsage;
    }

    @Override
    public void update() {
        super.update();
        if (this.powered != this.wasPowered) {
            this.wasPowered = this.powered;
            this.world.func_175685_c(this.pos, (Block)RSBlocks.DETECTOR, true);
            WorldUtils.updateBlock(this.world, this.pos);
        }
        if (this.network != null && this.canUpdate() && this.ticks % 5 == 0) {
            if (this.type == 0) {
                ItemStack slot = this.itemFilters.getStackInSlot(0);
                if (!slot.func_190926_b()) {
                    if (this.mode == 3) {
                        boolean found = false;
                        for (ICraftingTask task : this.network.getCraftingManager().getTasks()) {
                            for (ItemStack output : task.getPattern().getOutputs()) {
                                if (!API.instance().getComparer().isEqualNoQuantity(slot, output)) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            break;
                        }
                        this.powered = found;
                    } else {
                        ItemStack stack = this.network.getItemStorageCache().getList().get(slot, this.compare);
                        this.powered = this.isPowered(stack == null ? null : Integer.valueOf(stack.func_190916_E()));
                    }
                } else {
                    this.powered = this.mode == 3 ? !this.network.getCraftingManager().getTasks().isEmpty() : this.isPowered(this.network.getItemStorageCache().getList().getStacks().stream().map(ItemStack::func_190916_E).mapToInt(Number::intValue).sum());
                }
            } else if (this.type == 1) {
                FluidStack stack;
                FluidStack slot = this.fluidFilters.getFluidStackInSlot(0);
                this.powered = slot != null ? this.isPowered((stack = this.network.getFluidStorageCache().getList().get(slot, this.compare)) == null ? null : Integer.valueOf(stack.amount)) : this.isPowered(this.network.getFluidStorageCache().getList().getStacks().stream().map(s -> s.amount).mapToInt(Number::intValue).sum());
            }
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        if (!state) {
            this.powered = false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    private boolean isPowered(Integer size) {
        if (size != null) {
            switch (this.mode) {
                case 0: {
                    return size < this.amount;
                }
                case 1: {
                    return size == this.amount;
                }
                case 2: {
                    return size > this.amount;
                }
            }
        } else {
            if (this.mode == 0 && this.amount != 0) {
                return true;
            }
            return this.mode == 1 && this.amount == 0;
        }
        return false;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_AMOUNT, this.amount);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        StackUtils.writeItems((IItemHandler)this.fluidFilters, 1, tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_AMOUNT)) {
            this.amount = tag.func_74762_e(NBT_AMOUNT);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 1, tag);
    }

    public IItemHandler getInventory() {
        return this.itemFilters;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileDetector.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }
}

