/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.FluidHandlerFluidInterface;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileFluidInterface;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkNodeFluidInterface
extends NetworkNode
implements IComparable {
    public static final String ID = "fluid_interface";
    public static final int TANK_CAPACITY = 16000;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TANK_IN = "TankIn";
    private static final String NBT_TANK_OUT = "TankOut";
    private int compare = 2;
    private FluidTank tankIn = new FluidTank(16000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (!NetworkNodeFluidInterface.this.world.field_72995_K) {
                ((TileFluidInterface)NetworkNodeFluidInterface.this.world.func_175625_s(NetworkNodeFluidInterface.this.pos)).getDataManager().sendParameterToWatchers(TileFluidInterface.TANK_IN);
            }
            NetworkNodeFluidInterface.this.markDirty();
        }
    };
    private FluidTank tankOut = new FluidTank(16000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (!NetworkNodeFluidInterface.this.world.field_72995_K) {
                ((TileFluidInterface)NetworkNodeFluidInterface.this.world.func_175625_s(NetworkNodeFluidInterface.this.pos)).getDataManager().sendParameterToWatchers(TileFluidInterface.TANK_OUT);
            }
            NetworkNodeFluidInterface.this.markDirty();
        }
    };
    private FluidHandlerFluidInterface tank = new FluidHandlerFluidInterface(this.tankIn, this.tankOut);
    private ItemHandlerBase in = new ItemHandlerBase(1, new ItemHandlerListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerFluid out = new ItemHandlerFluid(1, new ItemHandlerListenerNetworkNode(this));
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ItemHandlerListenerNetworkNode(this), 2, 4);

    public NetworkNodeFluidInterface(World world, BlockPos pos) {
        super(world, pos);
        this.tankIn.setCanDrain(false);
        this.tankIn.setCanFill(true);
        this.tankOut.setCanDrain(true);
        this.tankOut.setCanFill(false);
    }

    @Override
    public void update() {
        Pair<ItemStack, FluidStack> result;
        super.update();
        ItemStack container = this.in.getStackInSlot(0);
        if (!container.func_190926_b() && (result = StackUtils.getFluid(container, true)).getValue() != null && this.tankIn.fillInternal((FluidStack)result.getValue(), false) == ((FluidStack)result.getValue()).amount) {
            result = StackUtils.getFluid(container, false);
            this.tankIn.fillInternal((FluidStack)result.getValue(), true);
            this.in.setStackInSlot(0, (ItemStack)result.getLeft());
        }
        if (this.network != null && this.canUpdate() && this.ticks % this.upgrades.getSpeed() == 0) {
            int toExtract;
            FluidStack took;
            FluidStack stackInStorage;
            FluidStack remainder;
            FluidStack drained = this.tankIn.drainInternal(1000 * this.upgrades.getItemInteractCount(), true);
            if (drained != null && (remainder = this.network.insertFluid(drained, drained.amount, false)) != null) {
                this.tankIn.fillInternal(remainder, true);
            }
            FluidStack stack = this.out.getFluidStackInSlot(0);
            if (this.tankOut.getFluid() != null && (stack == null || this.tankOut.getFluid().getFluid() != stack.getFluid())) {
                FluidStack remainder2 = this.tankOut.drainInternal(1000 * this.upgrades.getItemInteractCount(), true);
                if (remainder2 != null) {
                    this.network.insertFluid(remainder2, remainder2.amount, false);
                }
            } else if (stack != null && (stackInStorage = this.network.getFluidStorageCache().getList().get(stack, this.compare)) != null && (took = this.network.extractFluid(stack, toExtract = Math.min(1000 * this.upgrades.getItemInteractCount(), stackInStorage.amount), this.compare, true)) != null && toExtract - this.tankOut.fillInternal(took, false) == 0) {
                took = this.network.extractFluid(stack, toExtract, this.compare, false);
                this.tankOut.fillInternal(took, true);
            }
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.fluidInterfaceUsage;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 0, tag);
        StackUtils.writeItems((IItemHandler)this.in, 1, tag);
        tag.func_74782_a(NBT_TANK_IN, (NBTBase)this.tankIn.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a(NBT_TANK_OUT, (NBTBase)this.tankOut.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.in, 1, tag);
        if (tag.func_74764_b(NBT_TANK_IN)) {
            this.tankIn.readFromNBT(tag.func_74775_l(NBT_TANK_IN));
        }
        if (tag.func_74764_b(NBT_TANK_OUT)) {
            this.tankOut.readFromNBT(tag.func_74775_l(NBT_TANK_OUT));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.out, 2, tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.out, 2, tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
    }

    public ItemHandlerUpgrade getUpgrades() {
        return this.upgrades;
    }

    public ItemHandlerBase getIn() {
        return this.in;
    }

    public ItemHandlerFluid getOut() {
        return this.out;
    }

    public FluidHandlerFluidInterface getTank() {
        return this.tank;
    }

    public FluidTank getTankIn() {
        return this.tankIn;
    }

    public FluidTank getTankOut() {
        return this.tankOut;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.in, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }
}

