/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.StorageFluidDiskDrive;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.StorageItemDiskDrive;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheItem;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDiskDrive;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IExcessVoidable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeDiskDrive
extends NetworkNode
implements IGuiStorage,
IStorageProvider,
IComparable,
IFilterable,
IPrioritizable,
IType,
IExcessVoidable,
IAccessType {
    public static final Predicate<ItemStack> VALIDATOR_STORAGE_DISK = s -> s.func_77973_b() instanceof IStorageDiskProvider && ((IStorageDiskProvider)s.func_77973_b()).create((ItemStack)s).isValid((ItemStack)s);
    public static final String ID = "disk_drive";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_VOID_EXCESS = "VoidExcess";
    private ItemHandlerBase disks = new ItemHandlerBase(8, new ItemHandlerListenerNetworkNode(this), new Predicate[]{VALIDATOR_STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                StackUtils.createStorages(this.getStackInSlot(slot), slot, NetworkNodeDiskDrive.this.itemStorages, NetworkNodeDiskDrive.this.fluidStorages, s -> new StorageItemDiskDrive(NetworkNodeDiskDrive.this, (IStorageDisk<ItemStack>)s), s -> new StorageFluidDiskDrive(NetworkNodeDiskDrive.this, (IStorageDisk<FluidStack>)s));
                if (NetworkNodeDiskDrive.this.network != null) {
                    NetworkNodeDiskDrive.this.network.getItemStorageCache().invalidate();
                    NetworkNodeDiskDrive.this.network.getFluidStorageCache().invalidate();
                }
                WorldUtils.updateBlock(NetworkNodeDiskDrive.this.world, NetworkNodeDiskDrive.this.pos);
            }
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (NetworkNodeDiskDrive.this.itemStorages[slot] != null) {
                NetworkNodeDiskDrive.this.itemStorages[slot].writeToNBT();
            }
            if (NetworkNodeDiskDrive.this.fluidStorages[slot] != null) {
                NetworkNodeDiskDrive.this.fluidStorages[slot].writeToNBT();
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ItemHandlerListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, new ItemHandlerListenerNetworkNode(this));
    private IStorageDisk[] itemStorages = new IStorageDisk[8];
    private IStorageDisk[] fluidStorages = new IStorageDisk[8];
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 3;
    private int mode = 0;
    private int type = 0;
    private boolean voidExcess = false;

    public NetworkNodeDiskDrive(World world, BlockPos pos) {
        super(world, pos);
    }

    public IStorageDisk[] getItemStorages() {
        return this.itemStorages;
    }

    public IStorageDisk[] getFluidStorages() {
        return this.fluidStorages;
    }

    @Override
    public int getEnergyUsage() {
        int usage = RS.INSTANCE.config.diskDriveUsage;
        for (IStorageDisk storage : this.itemStorages) {
            if (storage == null) continue;
            usage += RS.INSTANCE.config.diskDrivePerDiskUsage;
        }
        for (IStorageDisk storage : this.fluidStorages) {
            if (storage == null) continue;
            usage += RS.INSTANCE.config.diskDrivePerDiskUsage;
        }
        return usage;
    }

    public void onBreak() {
        for (IStorageDisk storage : this.itemStorages) {
            if (storage == null) continue;
            storage.writeToNBT();
        }
        for (IStorageDisk storage : this.fluidStorages) {
            if (storage == null) continue;
            storage.writeToNBT();
        }
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getNodeGraph().schedulePostRebuildAction(StorageCacheItem.INVALIDATE);
        network.getNodeGraph().schedulePostRebuildAction(StorageCacheFluid.INVALIDATE);
        WorldUtils.updateBlock(this.world, this.pos);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        for (IStorageDisk storage : this.itemStorages) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        for (IStorageDisk storage : this.fluidStorages) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.disks, 0, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            if (this.itemStorages[i] != null) {
                this.itemStorages[i].writeToNBT();
            }
            if (this.fluidStorages[i] == null) continue;
            this.fluidStorages[i].writeToNBT();
        }
        StackUtils.writeItems((IItemHandler)this.disks, 0, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 1, tag);
        StackUtils.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_VOID_EXCESS, this.voidExcess);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 1, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 2, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_VOID_EXCESS)) {
            this.voidExcess = tag.func_74767_n(NBT_VOID_EXCESS);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:disk_drive.name";
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return TileDiskDrive.TYPE;
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileDiskDrive.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileDiskDrive.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileDiskDrive.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileDiskDrive.PRIORITY;
    }

    @Override
    public TileDataParameter<Boolean, ?> getVoidExcessParameter() {
        return TileDiskDrive.VOID_EXCESS;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileDiskDrive.ACCESS_TYPE;
    }

    @Override
    public String getVoidExcessType() {
        return "items_fluids";
    }

    @Override
    public int getStored() {
        return TileDiskDrive.STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return TileDiskDrive.CAPACITY.getValue();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getFluidStorageCache().invalidate();
            this.network.getItemStorageCache().invalidate();
        }
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
            this.network.getFluidStorageCache().sort();
        }
    }

    public IItemHandler getDisks() {
        return this.disks;
    }

    @Override
    public boolean getVoidExcess() {
        return this.voidExcess;
    }

    @Override
    public void setVoidExcess(boolean voidExcess) {
        this.voidExcess = voidExcess;
        this.markDirty();
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileDiskDrive.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    public ItemHandlerBase getItemFilters() {
        return this.itemFilters;
    }

    public ItemHandlerFluid getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public IItemHandler getDrops() {
        return this.disks;
    }
}

