/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.tile.TileDiskDrive;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class StorageFluidDiskDrive
implements IStorageDisk<FluidStack> {
    private NetworkNodeDiskDrive diskDrive;
    private IStorageDisk<FluidStack> parent;
    private int lastState;

    public StorageFluidDiskDrive(NetworkNodeDiskDrive diskDrive, IStorageDisk<FluidStack> parent) {
        this.diskDrive = diskDrive;
        this.parent = parent;
        this.onPassContainerContext(() -> {
            diskDrive.markDirty();
            int currentState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
            if (this.lastState != currentState) {
                this.lastState = currentState;
                WorldUtils.updateBlock(diskDrive.getWorld(), diskDrive.getPos());
            }
        }, diskDrive::getVoidExcess, diskDrive::getAccessType);
        this.lastState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
    }

    @Override
    public int getPriority() {
        return this.diskDrive.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    @Nullable
    public FluidStack insert(@Nonnull FluidStack stack, int size, boolean simulate) {
        if (!IFilterable.canTakeFluids(this.diskDrive.getFluidFilters(), this.diskDrive.getMode(), this.diskDrive.getCompare(), stack)) {
            return StackUtils.copy(stack, size);
        }
        return this.parent.insert(stack, size, simulate);
    }

    @Override
    @Nullable
    public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, boolean simulate) {
        return this.parent.extract(stack, size, flags, simulate);
    }

    @Override
    public int getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }

    @Override
    public int getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return this.parent.isValid(stack);
    }

    @Override
    public void onPassContainerContext(Runnable listener, Supplier<Boolean> voidExcess, Supplier<AccessType> accessType) {
        this.parent.onPassContainerContext(listener, voidExcess, accessType);
    }

    @Override
    public void readFromNBT() {
        this.parent.readFromNBT();
    }

    @Override
    public void writeToNBT() {
        this.parent.writeToNBT();
    }

    @Override
    public StorageDiskType getType() {
        return this.parent.getType();
    }
}

