/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandlerFactory;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ReaderWriterChannel
implements IReaderWriterChannel {
    private static final String NBT_HANDLER = "Handler_%s";
    private String name;
    private INetwork network;
    private List<IReaderWriterHandler> handlers = new ArrayList<IReaderWriterHandler>();

    public ReaderWriterChannel(String name, INetwork network) {
        this.name = name;
        this.network = network;
        this.handlers.addAll(API.instance().getReaderWriterHandlerRegistry().all().stream().map(f -> f.create(null)).collect(Collectors.toList()));
    }

    @Override
    public List<IReaderWriterHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public List<IReader> getReaders() {
        return this.network.getNodeGraph().all().stream().filter(n -> n instanceof IReader && this.name.equals(((IReader)n).getChannel())).map(n -> (IReader)n).collect(Collectors.toList());
    }

    @Override
    public List<IWriter> getWriters() {
        return this.network.getNodeGraph().all().stream().filter(n -> n instanceof IWriter && this.name.equals(((IWriter)n).getChannel())).map(n -> (IWriter)n).collect(Collectors.toList());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        for (IReaderWriterHandler handler : this.handlers) {
            tag.func_74782_a(String.format(NBT_HANDLER, handler.getId()), (NBTBase)handler.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        for (IReaderWriterHandler handler : this.handlers) {
            IReaderWriterHandlerFactory factory;
            String id = String.format(NBT_HANDLER, handler.getId());
            if (!tag.func_74764_b(id) || (factory = API.instance().getReaderWriterHandlerRegistry().get(id)) == null) continue;
            this.handlers.add(factory.create(tag.func_74775_l(id)));
        }
    }
}

